/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request.schema;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.schema.AbstractSchemaRequest;
import org.apache.solr.client.solrj.request.schema.AnalyzerDefinition;
import org.apache.solr.client.solrj.request.schema.FieldTypeDefinition;
import org.apache.solr.client.solrj.response.schema.SchemaResponse;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;

public class SchemaRequest
extends AbstractSchemaRequest<SchemaResponse> {
    public SchemaRequest() {
        this(null);
    }

    public SchemaRequest(SolrParams q) {
        super(SolrRequest.METHOD.GET, "/schema", q);
    }

    private static NamedList<Object> createAddFieldTypeNamedList(FieldTypeDefinition fieldTypeDefinition) {
        Map<String, Object> similarityAttributes;
        AnalyzerDefinition multiTermAnalyzerDefinition;
        AnalyzerDefinition queryAnalyzerDefinition;
        AnalyzerDefinition indexAnalyzerDefinition;
        NamedList<Object> addFieldTypeNamedList = new NamedList<Object>();
        addFieldTypeNamedList.addAll(fieldTypeDefinition.getAttributes());
        AnalyzerDefinition analyzerDefinition = fieldTypeDefinition.getAnalyzer();
        if (analyzerDefinition != null) {
            NamedList<Object> analyzerNamedList = SchemaRequest.createAnalyzerNamedList(analyzerDefinition);
            addFieldTypeNamedList.add("analyzer", analyzerNamedList);
        }
        if ((indexAnalyzerDefinition = fieldTypeDefinition.getIndexAnalyzer()) != null) {
            NamedList<Object> indexAnalyzerNamedList = SchemaRequest.createAnalyzerNamedList(indexAnalyzerDefinition);
            addFieldTypeNamedList.add("indexAnalyzer", indexAnalyzerNamedList);
        }
        if ((queryAnalyzerDefinition = fieldTypeDefinition.getQueryAnalyzer()) != null) {
            NamedList<Object> queryAnalyzerNamedList = SchemaRequest.createAnalyzerNamedList(queryAnalyzerDefinition);
            addFieldTypeNamedList.add("queryAnalyzer", queryAnalyzerNamedList);
        }
        if ((multiTermAnalyzerDefinition = fieldTypeDefinition.getMultiTermAnalyzer()) != null) {
            NamedList<Object> multiTermAnalyzerNamedList = SchemaRequest.createAnalyzerNamedList(multiTermAnalyzerDefinition);
            addFieldTypeNamedList.add("multiTermAnalyzer", multiTermAnalyzerNamedList);
        }
        if ((similarityAttributes = fieldTypeDefinition.getSimilarity()) != null && !similarityAttributes.isEmpty()) {
            addFieldTypeNamedList.add("similarity", new NamedList<Object>(similarityAttributes));
        }
        return addFieldTypeNamedList;
    }

    private static NamedList<Object> createAnalyzerNamedList(AnalyzerDefinition analyzerDefinition) {
        List<Map<String, Object>> filtersAttributes;
        Map<String, Object> tokenizerAttributes;
        List<Map<String, Object>> charFiltersAttributes;
        NamedList<Object> analyzerNamedList = new NamedList<Object>();
        Map<String, Object> analyzerAttributes = analyzerDefinition.getAttributes();
        if (analyzerAttributes != null) {
            analyzerNamedList.addAll(analyzerAttributes);
        }
        if ((charFiltersAttributes = analyzerDefinition.getCharFilters()) != null) {
            LinkedList<NamedList<Object>> charFiltersList = new LinkedList<NamedList<Object>>();
            for (Map<String, Object> charFilterAttributes : charFiltersAttributes) {
                charFiltersList.add(new NamedList<Object>(charFilterAttributes));
            }
            analyzerNamedList.add("charFilters", charFiltersList);
        }
        if ((tokenizerAttributes = analyzerDefinition.getTokenizer()) != null) {
            analyzerNamedList.add("tokenizer", new NamedList<Object>(tokenizerAttributes));
        }
        if ((filtersAttributes = analyzerDefinition.getFilters()) != null) {
            LinkedList<NamedList<Object>> filtersList = new LinkedList<NamedList<Object>>();
            for (Map<String, Object> filterAttributes : filtersAttributes) {
                filtersList.add(new NamedList<Object>(filterAttributes));
            }
            analyzerNamedList.add("filters", filtersList);
        }
        return analyzerNamedList;
    }

    private static NamedList<Object> createAddFieldNamedList(Map<String, Object> fieldAttributes) {
        NamedList<Object> addFieldProps = new NamedList<Object>();
        if (fieldAttributes != null) {
            addFieldProps.addAll(fieldAttributes);
        }
        return addFieldProps;
    }

    @Override
    protected SchemaResponse createResponse(SolrClient client) {
        return new SchemaResponse();
    }

    public static class MultiUpdate
    extends Update {
        private List<Update> updateSchemaRequests = new LinkedList<Update>();

        public MultiUpdate(List<Update> updateSchemaRequests) {
            this(updateSchemaRequests, null);
        }

        public MultiUpdate(List<Update> updateSchemaRequests, SolrParams q) {
            super(q);
            if (updateSchemaRequests == null) {
                throw new IllegalArgumentException("updateSchemaRequests must be non-null");
            }
            for (Update updateSchemaRequest : updateSchemaRequests) {
                if (updateSchemaRequest == null) {
                    throw new IllegalArgumentException("updateSchemaRequests elements must be non-null");
                }
                this.updateSchemaRequests.add(updateSchemaRequest);
            }
        }

        @Override
        protected NamedList<Object> getRequestParameters() {
            NamedList<Object> multipleRequestsParameters = new NamedList<Object>();
            for (Update updateSchemaRequest : this.updateSchemaRequests) {
                multipleRequestsParameters.addAll(updateSchemaRequest.getRequestParameters());
            }
            return multipleRequestsParameters;
        }
    }

    private static abstract class SingleUpdate
    extends Update {
        private final NamedList<Object> requestParameters;

        public SingleUpdate(NamedList<Object> requestParameters) {
            this(requestParameters, null);
        }

        public SingleUpdate(NamedList<Object> requestParameters, SolrParams q) {
            super(q);
            this.requestParameters = requestParameters;
        }

        @Override
        protected NamedList<Object> getRequestParameters() {
            return this.requestParameters;
        }
    }

    public static abstract class Update
    extends AbstractSchemaRequest<SchemaResponse.UpdateResponse> {
        public Update() {
            this(null);
        }

        public Update(SolrParams q) {
            super(SolrRequest.METHOD.POST, "/schema", q);
        }

        protected abstract NamedList<Object> getRequestParameters();

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new RequestWriter.ContentWriter(){

                @Override
                public void write(OutputStream os) throws IOException {
                    Utils.writeJson(this.getRequestParameters(), os, false);
                }

                @Override
                public String getContentType() {
                    return "application/json";
                }
            };
        }

        @Override
        protected SchemaResponse.UpdateResponse createResponse(SolrClient client) {
            return new SchemaResponse.UpdateResponse();
        }
    }

    public static class DeleteCopyField
    extends SingleUpdate {
        public DeleteCopyField(String source, List<String> dest) {
            this(source, dest, null);
        }

        public DeleteCopyField(String source, List<String> dest, SolrParams q) {
            super(DeleteCopyField.createRequestParameters(source, dest), q);
        }

        private static NamedList<Object> createRequestParameters(String source, List<String> dest) {
            NamedList<Object> addCopyFieldParameters = new NamedList<Object>();
            addCopyFieldParameters.add("source", source);
            addCopyFieldParameters.add("dest", dest);
            NamedList<Object> requestParameters = new NamedList<Object>();
            requestParameters.add("delete-copy-field", addCopyFieldParameters);
            return requestParameters;
        }
    }

    public static class AddCopyField
    extends SingleUpdate {
        public AddCopyField(String source, List<String> dest) {
            this(source, dest, (SolrParams)null);
        }

        public AddCopyField(String source, List<String> dest, Integer maxChars) {
            this(source, dest, maxChars, null);
        }

        public AddCopyField(String source, List<String> dest, SolrParams q) {
            super(AddCopyField.createRequestParameters(source, dest, null), q);
        }

        public AddCopyField(String source, List<String> dest, Integer maxChars, SolrParams q) {
            super(AddCopyField.createRequestParameters(source, dest, maxChars), q);
        }

        private static NamedList<Object> createRequestParameters(String source, List<String> dest, Integer maxchars) {
            NamedList<Object> addCopyFieldParameters = new NamedList<Object>();
            addCopyFieldParameters.add("source", source);
            addCopyFieldParameters.add("dest", dest);
            if (maxchars != null) {
                addCopyFieldParameters.add("maxChars", maxchars);
            }
            NamedList<Object> requestParameters = new NamedList<Object>();
            requestParameters.add("add-copy-field", addCopyFieldParameters);
            return requestParameters;
        }
    }

    public static class DeleteFieldType
    extends SingleUpdate {
        public DeleteFieldType(String fieldTypeName) {
            this(fieldTypeName, null);
        }

        public DeleteFieldType(String fieldTypeName, SolrParams q) {
            super(DeleteFieldType.createRequestParameters(fieldTypeName), q);
        }

        private static NamedList<Object> createRequestParameters(String fieldTypeName) {
            NamedList<String> deleteFieldTypeParameters = new NamedList<String>();
            deleteFieldTypeParameters.add("name", fieldTypeName);
            NamedList<Object> requestParameters = new NamedList<Object>();
            requestParameters.add("delete-field-type", deleteFieldTypeParameters);
            return requestParameters;
        }
    }

    public static class ReplaceFieldType
    extends SingleUpdate {
        public ReplaceFieldType(FieldTypeDefinition fieldTypeDefinition) {
            this(fieldTypeDefinition, null);
        }

        public ReplaceFieldType(FieldTypeDefinition fieldTypeDefinition, SolrParams q) {
            super(ReplaceFieldType.createRequestParameters(fieldTypeDefinition), q);
        }

        private static NamedList<Object> createRequestParameters(FieldTypeDefinition fieldTypeDefinition) {
            NamedList<Object> replaceFieldTypeParameters = SchemaRequest.createAddFieldTypeNamedList(fieldTypeDefinition);
            NamedList<Object> requestParameters = new NamedList<Object>();
            requestParameters.add("replace-field-type", replaceFieldTypeParameters);
            return requestParameters;
        }
    }

    public static class AddFieldType
    extends SingleUpdate {
        public AddFieldType(FieldTypeDefinition fieldTypeDefinition) {
            this(fieldTypeDefinition, null);
        }

        public AddFieldType(FieldTypeDefinition fieldTypeDefinition, SolrParams q) {
            super(AddFieldType.createRequestParameters(fieldTypeDefinition), q);
        }

        private static NamedList<Object> createRequestParameters(FieldTypeDefinition fieldTypeDefinition) {
            NamedList<Object> addFieldTypeParameters = SchemaRequest.createAddFieldTypeNamedList(fieldTypeDefinition);
            NamedList<Object> requestParameters = new NamedList<Object>();
            requestParameters.add("add-field-type", addFieldTypeParameters);
            return requestParameters;
        }
    }

    public static class DeleteDynamicField
    extends SingleUpdate {
        public DeleteDynamicField(String dynamicFieldName) {
            this(dynamicFieldName, null);
        }

        public DeleteDynamicField(String fieldName, SolrParams q) {
            super(DeleteDynamicField.createRequestParameters(fieldName), q);
        }

        private static NamedList<Object> createRequestParameters(String fieldName) {
            NamedList<String> deleteDynamicFieldParameters = new NamedList<String>();
            deleteDynamicFieldParameters.add("name", fieldName);
            NamedList<Object> requestParameters = new NamedList<Object>();
            requestParameters.add("delete-dynamic-field", deleteDynamicFieldParameters);
            return requestParameters;
        }
    }

    public static class ReplaceDynamicField
    extends SingleUpdate {
        public ReplaceDynamicField(Map<String, Object> dynamicFieldAttributes) {
            this(dynamicFieldAttributes, null);
        }

        public ReplaceDynamicField(Map<String, Object> dynamicFieldAttributes, SolrParams q) {
            super(ReplaceDynamicField.createRequestParameters(dynamicFieldAttributes), q);
        }

        private static NamedList<Object> createRequestParameters(Map<String, Object> dynamicFieldAttributes) {
            NamedList<Object> replaceDynamicFieldParameters = SchemaRequest.createAddFieldNamedList(dynamicFieldAttributes);
            NamedList<Object> requestParameters = new NamedList<Object>();
            requestParameters.add("replace-dynamic-field", replaceDynamicFieldParameters);
            return requestParameters;
        }
    }

    public static class AddDynamicField
    extends SingleUpdate {
        public AddDynamicField(Map<String, Object> fieldAttributes) {
            this(fieldAttributes, null);
        }

        public AddDynamicField(Map<String, Object> fieldAttributes, SolrParams q) {
            super(AddDynamicField.createRequestParameters(fieldAttributes), q);
        }

        private static NamedList<Object> createRequestParameters(Map<String, Object> fieldAttributes) {
            NamedList<Object> addDynamicFieldParameters = SchemaRequest.createAddFieldNamedList(fieldAttributes);
            NamedList<Object> requestParameters = new NamedList<Object>();
            requestParameters.add("add-dynamic-field", addDynamicFieldParameters);
            return requestParameters;
        }
    }

    public static class DeleteField
    extends SingleUpdate {
        public DeleteField(String fieldName) {
            this(fieldName, null);
        }

        public DeleteField(String fieldName, SolrParams q) {
            super(DeleteField.createRequestParameters(fieldName), q);
        }

        private static NamedList<Object> createRequestParameters(String fieldName) {
            NamedList<String> deleteFieldParameters = new NamedList<String>();
            deleteFieldParameters.add("name", fieldName);
            NamedList<Object> requestParameters = new NamedList<Object>();
            requestParameters.add("delete-field", deleteFieldParameters);
            return requestParameters;
        }
    }

    public static class ReplaceField
    extends SingleUpdate {
        public ReplaceField(Map<String, Object> fieldAttributes) {
            this(fieldAttributes, null);
        }

        public ReplaceField(Map<String, Object> fieldAttributes, SolrParams q) {
            super(ReplaceField.createRequestParameters(fieldAttributes), q);
        }

        private static NamedList<Object> createRequestParameters(Map<String, Object> fieldAttributes) {
            NamedList<Object> replaceFieldParameters = SchemaRequest.createAddFieldNamedList(fieldAttributes);
            NamedList<Object> requestParameters = new NamedList<Object>();
            requestParameters.add("replace-field", replaceFieldParameters);
            return requestParameters;
        }
    }

    public static class AddField
    extends SingleUpdate {
        public AddField(Map<String, Object> fieldAttributes) {
            this(fieldAttributes, null);
        }

        public AddField(Map<String, Object> fieldAttributes, SolrParams q) {
            super(AddField.createRequestParameters(fieldAttributes), q);
        }

        private static NamedList<Object> createRequestParameters(Map<String, Object> fieldAttributes) {
            NamedList<Object> addFieldParameters = SchemaRequest.createAddFieldNamedList(fieldAttributes);
            NamedList<Object> requestParameters = new NamedList<Object>();
            requestParameters.add("add-field", addFieldParameters);
            return requestParameters;
        }
    }

    public static class GlobalSimilarity
    extends AbstractSchemaRequest<SchemaResponse.GlobalSimilarityResponse> {
        public GlobalSimilarity() {
            this(null);
        }

        public GlobalSimilarity(SolrParams q) {
            super(SolrRequest.METHOD.GET, "/schema/similarity", q);
        }

        @Override
        protected SchemaResponse.GlobalSimilarityResponse createResponse(SolrClient client) {
            return new SchemaResponse.GlobalSimilarityResponse();
        }
    }

    public static class UniqueKey
    extends AbstractSchemaRequest<SchemaResponse.UniqueKeyResponse> {
        public UniqueKey() {
            this(null);
        }

        public UniqueKey(SolrParams q) {
            super(SolrRequest.METHOD.GET, "/schema/uniquekey", q);
        }

        @Override
        protected SchemaResponse.UniqueKeyResponse createResponse(SolrClient client) {
            return new SchemaResponse.UniqueKeyResponse();
        }
    }

    public static class CopyFields
    extends AbstractSchemaRequest<SchemaResponse.CopyFieldsResponse> {
        public CopyFields() {
            this(null);
        }

        public CopyFields(SolrParams q) {
            super(SolrRequest.METHOD.GET, "/schema/copyfields", q);
        }

        @Override
        protected SchemaResponse.CopyFieldsResponse createResponse(SolrClient client) {
            return new SchemaResponse.CopyFieldsResponse();
        }
    }

    public static class FieldType
    extends AbstractSchemaRequest<SchemaResponse.FieldTypeResponse> {
        public FieldType(String fieldTypeName) {
            this(fieldTypeName, null);
        }

        public FieldType(String fieldTypeName, SolrParams q) {
            super(SolrRequest.METHOD.GET, "/schema/fieldtypes/" + fieldTypeName, q);
        }

        @Override
        protected SchemaResponse.FieldTypeResponse createResponse(SolrClient client) {
            return new SchemaResponse.FieldTypeResponse();
        }
    }

    public static class FieldTypes
    extends AbstractSchemaRequest<SchemaResponse.FieldTypesResponse> {
        public FieldTypes() {
            this(null);
        }

        public FieldTypes(SolrParams q) {
            super(SolrRequest.METHOD.GET, "/schema/fieldtypes", q);
        }

        @Override
        protected SchemaResponse.FieldTypesResponse createResponse(SolrClient client) {
            return new SchemaResponse.FieldTypesResponse();
        }
    }

    public static class DynamicField
    extends AbstractSchemaRequest<SchemaResponse.DynamicFieldResponse> {
        public DynamicField(String dynamicFieldName) {
            this(dynamicFieldName, null);
        }

        public DynamicField(String dynamicFieldName, SolrParams q) {
            super(SolrRequest.METHOD.GET, "/schema/dynamicfields/" + dynamicFieldName, q);
        }

        @Override
        protected SchemaResponse.DynamicFieldResponse createResponse(SolrClient client) {
            return new SchemaResponse.DynamicFieldResponse();
        }
    }

    public static class DynamicFields
    extends AbstractSchemaRequest<SchemaResponse.DynamicFieldsResponse> {
        public DynamicFields() {
            this(null);
        }

        public DynamicFields(SolrParams q) {
            super(SolrRequest.METHOD.GET, "/schema/dynamicfields", q);
        }

        @Override
        protected SchemaResponse.DynamicFieldsResponse createResponse(SolrClient client) {
            return new SchemaResponse.DynamicFieldsResponse();
        }
    }

    public static class Field
    extends AbstractSchemaRequest<SchemaResponse.FieldResponse> {
        public Field(String fieldName) {
            this(fieldName, null);
        }

        public Field(String fieldName, SolrParams q) {
            super(SolrRequest.METHOD.GET, "/schema/fields/" + fieldName, q);
        }

        @Override
        protected SchemaResponse.FieldResponse createResponse(SolrClient client) {
            return new SchemaResponse.FieldResponse();
        }
    }

    public static class Fields
    extends AbstractSchemaRequest<SchemaResponse.FieldsResponse> {
        public Fields() {
            this(null);
        }

        public Fields(SolrParams q) {
            super(SolrRequest.METHOD.GET, "/schema/fields", q);
        }

        @Override
        protected SchemaResponse.FieldsResponse createResponse(SolrClient client) {
            return new SchemaResponse.FieldsResponse();
        }
    }

    public static class SchemaVersion
    extends AbstractSchemaRequest<SchemaResponse.SchemaVersionResponse> {
        public SchemaVersion() {
            this(null);
        }

        public SchemaVersion(SolrParams q) {
            super(SolrRequest.METHOD.GET, "/schema/version", q);
        }

        @Override
        protected SchemaResponse.SchemaVersionResponse createResponse(SolrClient client) {
            return new SchemaResponse.SchemaVersionResponse();
        }
    }

    public static class SchemaName
    extends AbstractSchemaRequest<SchemaResponse.SchemaNameResponse> {
        public SchemaName() {
            this(null);
        }

        public SchemaName(SolrParams q) {
            super(SolrRequest.METHOD.GET, "/schema/name", q);
        }

        @Override
        protected SchemaResponse.SchemaNameResponse createResponse(SolrClient client) {
            return new SchemaResponse.SchemaNameResponse();
        }
    }
}

