/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.util.Objects;
import org.apache.nifi.security.ssl.BuilderConfigurationException;
import org.apache.nifi.security.ssl.KeyStoreBuilder;

public class StandardKeyStoreBuilder
implements KeyStoreBuilder {
    private Provider provider;
    private String type = KeyStore.getDefaultType();
    private InputStream inputStream;
    private char[] password;

    @Override
    public KeyStore build() {
        KeyStore keyStore = this.getKeyStore();
        if (this.inputStream == null) {
            throw new BuilderConfigurationException("Key Store InputStream not configured");
        }
        try {
            keyStore.load(this.inputStream, this.password);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new BuilderConfigurationException("Key Store loading failed", e);
        }
        return keyStore;
    }

    public StandardKeyStoreBuilder provider(Provider provider) {
        this.provider = Objects.requireNonNull(provider, "Key Store Provider required");
        return this;
    }

    public StandardKeyStoreBuilder type(String type) {
        this.type = Objects.requireNonNull(type, "Key Store Type required");
        return this;
    }

    public StandardKeyStoreBuilder password(char[] password) {
        this.password = Objects.requireNonNull(password, "Key Store Password required");
        return this;
    }

    public StandardKeyStoreBuilder inputStream(InputStream inputStream) {
        this.inputStream = Objects.requireNonNull(inputStream, "Key Store InputStream required");
        return this;
    }

    private KeyStore getKeyStore() {
        try {
            return this.provider == null ? KeyStore.getInstance(this.type) : KeyStore.getInstance(this.type, this.provider);
        }
        catch (KeyStoreException e) {
            String message = String.format("Key Store Type [%s] creation failed", this.type);
            throw new BuilderConfigurationException(message, e);
        }
    }
}

