/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.file;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.registry.security.authorization.AccessPolicy;
import org.apache.nifi.registry.security.authorization.RequestAction;
import org.apache.nifi.registry.security.authorization.file.generated.Authorizations;
import org.apache.nifi.registry.security.authorization.file.generated.Policies;
import org.apache.nifi.registry.security.authorization.file.generated.Policy;
import org.apache.nifi.registry.security.authorization.util.AccessPolicyProviderUtils;

public class AuthorizationsHolder {
    private final Authorizations authorizations;
    private final Set<AccessPolicy> allPolicies;
    private final Map<String, Set<AccessPolicy>> policiesByResource;
    private final Map<String, AccessPolicy> policiesById;

    public AuthorizationsHolder(Authorizations authorizations) {
        this.authorizations = authorizations;
        Policies policies = authorizations.getPolicies();
        Set<AccessPolicy> allPolicies = Collections.unmodifiableSet(this.createAccessPolicies(policies));
        Map<String, Set<AccessPolicy>> policiesByResourceMap = Collections.unmodifiableMap(AccessPolicyProviderUtils.createResourcePolicyMap(allPolicies));
        Map<String, AccessPolicy> policiesByIdMap = Collections.unmodifiableMap(AccessPolicyProviderUtils.createPoliciesByIdMap(allPolicies));
        this.allPolicies = allPolicies;
        this.policiesByResource = policiesByResourceMap;
        this.policiesById = policiesByIdMap;
    }

    private Set<AccessPolicy> createAccessPolicies(Policies policies) {
        HashSet<AccessPolicy> allPolicies = new HashSet<AccessPolicy>();
        if (policies == null || policies.getPolicy() == null) {
            return allPolicies;
        }
        for (Policy policy : policies.getPolicy()) {
            String policyIdentifier = policy.getIdentifier();
            String resourceIdentifier = policy.getResource();
            AccessPolicy.Builder builder = new AccessPolicy.Builder().identifier(policyIdentifier).resource(resourceIdentifier);
            for (Policy.User user : policy.getUser()) {
                builder.addUser(user.getIdentifier());
            }
            for (Policy.Group group : policy.getGroup()) {
                builder.addGroup(group.getIdentifier());
            }
            String authorizationCode = policy.getAction();
            if (authorizationCode.equals("R")) {
                builder.action(RequestAction.READ);
            } else if (authorizationCode.equals("W")) {
                builder.action(RequestAction.WRITE);
            } else if (authorizationCode.equals("D")) {
                builder.action(RequestAction.DELETE);
            } else {
                throw new IllegalStateException("Unknown Policy Action: " + authorizationCode);
            }
            allPolicies.add(builder.build());
        }
        return allPolicies;
    }

    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    public Set<AccessPolicy> getAllPolicies() {
        return this.allPolicies;
    }

    public Map<String, Set<AccessPolicy>> getPoliciesByResource() {
        return this.policiesByResource;
    }

    public Map<String, AccessPolicy> getPoliciesById() {
        return this.policiesById;
    }
}

