/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.debug;

import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.expression.ExpressionParserException;
import org.apache.olingo.odata2.core.debug.DebugInfo;
import org.apache.olingo.odata2.core.debug.DebugInfoException;
import org.apache.olingo.odata2.core.debug.DebugInfoRequest;
import org.apache.olingo.odata2.core.debug.DebugInfoResponse;
import org.apache.olingo.odata2.core.debug.DebugInfoRuntime;
import org.apache.olingo.odata2.core.debug.DebugInfoServer;
import org.apache.olingo.odata2.core.debug.DebugInfoUri;
import org.apache.olingo.odata2.core.ep.util.CircleStreamBuffer;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;
import org.apache.olingo.odata2.core.exception.MessageService;
import org.apache.olingo.odata2.core.exception.ODataRuntimeException;

public class ODataDebugResponseWrapper {
    public static final String ODATA_DEBUG_QUERY_PARAMETER = "odata-debug";
    public static final String ODATA_DEBUG_JSON = "json";
    public static final String ODATA_DEBUG_HTML = "html";
    public static final String ODATA_DEBUG_DOWNLOAD = "download";
    private final ODataContext context;
    private final ODataResponse response;
    private final UriInfo uriInfo;
    private final Exception exception;
    private final boolean isJson;
    private final boolean isDownload;

    public ODataDebugResponseWrapper(ODataContext context, ODataResponse response, UriInfo uriInfo, Exception exception, String debugValue) {
        this.context = context;
        this.response = response;
        this.uriInfo = uriInfo;
        this.exception = exception;
        this.isJson = ODATA_DEBUG_JSON.equals(debugValue);
        this.isDownload = ODATA_DEBUG_DOWNLOAD.equals(debugValue);
    }

    public ODataResponse wrapResponse() {
        try {
            List<DebugInfo> parts = this.createParts();
            ODataResponse.ODataResponseBuilder builder = ODataResponse.status((HttpStatusCodes)HttpStatusCodes.OK).entity((Object)(this.isJson ? this.wrapInJson(parts) : this.wrapInHtml(parts))).contentHeader(this.isJson ? "application/json;charset=utf-8" : "text/html");
            if (this.isDownload) {
                builder.header("Content-Disposition", "attachment; filename=OData-Response." + new Date().toString().replace(' ', '_').replace(':', '.') + ".html");
            }
            return builder.build();
        }
        catch (ODataException e) {
            throw new ODataRuntimeException("Should not happen", e);
        }
        catch (IOException e) {
            throw new ODataRuntimeException("Should not happen", e);
        }
    }

    private List<DebugInfo> createParts() throws ODataException {
        Throwable candidate;
        ArrayList<DebugInfo> parts = new ArrayList<DebugInfo>();
        HttpServletRequest servletRequest = (HttpServletRequest)this.context.getParameter("~httpRequestObject");
        String protocol = servletRequest == null ? null : servletRequest.getProtocol();
        parts.add(new DebugInfoRequest(this.context.getHttpMethod(), this.context.getPathInfo().getRequestUri(), protocol, this.context.getRequestHeaders()));
        parts.add(new DebugInfoResponse(this.response, this.context.getPathInfo().getServiceRoot().toASCIIString()));
        if (servletRequest != null) {
            parts.add(new DebugInfoServer(servletRequest));
        }
        for (candidate = this.exception; candidate != null && !(candidate instanceof ExpressionParserException); candidate = candidate.getCause()) {
        }
        ExpressionParserException expressionParserException = (ExpressionParserException)candidate;
        if (this.uriInfo != null && (this.uriInfo.getFilter() != null || this.uriInfo.getOrderBy() != null || !this.uriInfo.getExpand().isEmpty() || !this.uriInfo.getSelect().isEmpty()) || expressionParserException != null && expressionParserException.getFilterTree() != null) {
            parts.add(new DebugInfoUri(this.uriInfo, expressionParserException));
        }
        if (this.context.getRuntimeMeasurements() != null) {
            parts.add(new DebugInfoRuntime(this.context.getRuntimeMeasurements()));
        }
        if (this.exception != null) {
            Locale locale = MessageService.getSupportedLocale(this.context.getAcceptableLanguages(), Locale.ENGLISH);
            parts.add(new DebugInfoException(this.exception, locale));
        }
        return parts;
    }

    private InputStream wrapInJson(List<DebugInfo> parts) throws IOException {
        CircleStreamBuffer csb = new CircleStreamBuffer();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(csb.getOutputStream(), "UTF-8"));
        JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
        jsonStreamWriter.beginObject().name(parts.get(0).getName().toLowerCase(Locale.ROOT));
        parts.get(0).appendJson(jsonStreamWriter);
        jsonStreamWriter.separator().name(parts.get(1).getName().toLowerCase(Locale.ROOT));
        parts.get(1).appendJson(jsonStreamWriter);
        jsonStreamWriter.separator().name("server").beginObject().namedStringValueRaw("version", ODataDebugResponseWrapper.class.getPackage().getImplementationVersion());
        for (DebugInfo part : parts.subList(2, parts.size())) {
            jsonStreamWriter.separator().name(part.getName().toLowerCase(Locale.ROOT));
            part.appendJson(jsonStreamWriter);
        }
        jsonStreamWriter.endObject().endObject();
        writer.flush();
        csb.closeWrite();
        return csb.getInputStream();
    }

    private InputStream wrapInHtml(List<DebugInfo> parts) throws IOException {
        StringWriter writer = new StringWriter();
        PathInfo pathInfo = null;
        try {
            pathInfo = this.context.getPathInfo();
        }
        catch (ODataException oDataException) {
            // empty catch block
        }
        writer.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"\n").append("  \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n").append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\n").append("<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n").append("<title>").append(pathInfo == null ? "" : ODataDebugResponseWrapper.escapeHtml(pathInfo.getServiceRoot().relativize(pathInfo.getRequestUri()).getPath())).append("</title>\n").append("<style type=\"text/css\">\n").append("body { font-family: Arial, sans-serif; font-size: 13px;\n").append("       line-height: 16px; margin: 0;\n").append("       background-color: #eeeeee; color: #333333; }\n").append(".header { float: left; }\n").append(".header a { line-height: 22px; padding: 10px 18px;\n").append("            text-decoration: none; color: #333333; }\n").append(":target, .header:nth-last-child(2) { background-color: #cccccc; }\n").append(":target ~ .header:nth-last-child(2) { background-color: inherit; }\n").append(".header:focus, .header:hover,\n").append("  .header:nth-last-child(2):focus, .header:nth-last-child(2):hover\n").append("    { background-color: #999999; }\n").append(".section { position: absolute; top: 42px; min-width: 100%;\n").append("           padding-top: 18px; border-top: 1px solid #dddddd; }\n").append(".section > * { margin-left: 18px; }\n").append(":target + .section, .section:last-child { display: block; }\n").append(".section, :target + .section ~ .section { display: none; }\n").append("h1 { font-size: 18px; font-weight: normal; margin: 10px 0; }\n").append("h2 { font-size: 15px; }\n").append("h2:not(:first-child) { margin-top: 2em; }\n").append("table { border-collapse: collapse; border-spacing: 0;\n").append("        margin-top: 1.5em; }\n").append("table, thead { border-width: 1px 0; border-style: solid;\n").append("               border-color: #dddddd; text-align: left; }\n").append("th.name, td.name { padding: 1ex 2em 1ex 0; }\n").append("tbody > tr:hover { background-color: #cccccc; }\n").append(".code { font-family: \"Courier New\", monospace; }\n").append(".code, .tree li { line-height: 15px; }\n").append(".code a { text-decoration: underline; color: #666666; }\n").append(".xml .ns { font-style: italic; color: #999999; }\n").append("ul, .tree { list-style-type: none; }\n").append("div > ul.expr, div > .expand, .tree { padding-left: 0; }\n").append(".expr, .expand, .null, .numeric { padding-left: 1.5em; }\n").append("</style>\n").append("</head>\n").append("<body>\n");
        char count = '0';
        for (DebugInfo part : parts) {
            count = (char)(count + 1);
            writer.append("<div class=\"header\" id=\"sec").append(count).append("\">\n").append("<h1><a href=\"#sec").append(count).append("\">").append(part.getName()).append("</a></h1>\n").append("</div>\n").append("<div class=\"section\">\n");
            part.appendHtml(writer);
            writer.append("</div>\n");
        }
        writer.append("</body>\n").append("</html>\n").close();
        byte[] bytes = writer.toString().getBytes("UTF-8");
        return new ByteArrayInputStream(bytes);
    }

    protected static String escapeHtml(String value) {
        return value == null ? null : value.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    protected static void appendJsonTable(JsonStreamWriter jsonStreamWriter, Map<String, String> entries) throws IOException {
        jsonStreamWriter.beginObject();
        boolean first = true;
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            String value = entries.get(entry.getKey());
            if (value == null) continue;
            if (!first) {
                jsonStreamWriter.separator();
            }
            first = false;
            jsonStreamWriter.namedStringValue(entry.getKey(), value);
        }
        jsonStreamWriter.endObject();
    }

    protected static void appendHtmlTable(Writer writer, Map<String, String> entries) throws IOException {
        writer.append("<table>\n<thead>\n").append("<tr><th class=\"name\">Name</th><th class=\"value\">Value</th></tr>\n").append("</thead>\n<tbody>\n");
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            writer.append("<tr><td class=\"name\">").append(entry.getKey()).append("</td>").append("<td class=\"value\">").append(ODataDebugResponseWrapper.escapeHtml(value)).append("</td></tr>\n");
        }
        writer.append("</tbody>\n</table>\n");
    }
}

