/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.lan;

import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.nio.charset.Charset;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.lan.Country;
import org.apache.sis.xml.bind.lan.LanguageCode;
import org.apache.sis.xml.bind.metadata.code.MD_CharacterSetCode;

public final class PT_Locale {
    private Locale locale;
    @XmlElement(name="PT_Locale")
    public Wrapper element;

    public PT_Locale() {
    }

    public PT_Locale(Locale locale) {
        this.locale = locale;
    }

    private PT_Locale(Map.Entry<Locale, Charset> entry) {
        this.locale = entry.getKey();
        this.setCharacterSet(entry.getValue());
    }

    public Locale getLocale() {
        if (this.locale == null && this.element != null) {
            this.locale = Country.getLocale(Context.current(), this.element.language, this.element.country, PT_Locale.class);
        }
        return this.locale;
    }

    final Charset getCharacterSet() {
        return this.element != null ? this.element.characterEncoding : null;
    }

    final void setCharacterSet(Charset encoding) {
        this.element = new Wrapper(this.locale, encoding);
    }

    final boolean addInto(Map<Locale, Charset> addTo) {
        Locale locale = this.getLocale();
        Charset encoding = this.getCharacterSet();
        if (locale != null || encoding != null) {
            boolean wasAbsent = encoding == null && !addTo.containsKey(locale);
            return addTo.put(locale, encoding) != encoding | wasAbsent;
        }
        return false;
    }

    public static PT_Locale first(Map<Locale, Charset> locales) {
        Map.Entry first;
        if (locales != null && (first = (Map.Entry)CollectionsExt.first(locales.entrySet())) != null) {
            return new PT_Locale(first);
        }
        return null;
    }

    public static Set<PT_Locale> wrap(Map<Locale, Charset> locales) {
        return locales != null && !locales.isEmpty() ? new Sequence(locales) : null;
    }

    @XmlType(name="PT_Locale_Type", propOrder={"languageCode", "language", "country", "characterEncoding"})
    public static final class Wrapper {
        LanguageCode language;
        @XmlElement
        public Country country;
        @XmlElement(required=true)
        @XmlJavaTypeAdapter(value=MD_CharacterSetCode.class)
        public Charset characterEncoding;
        private boolean isLegacyMetadata;

        public Wrapper() {
        }

        Wrapper(Locale locale, Charset encoding) {
            Context context = Context.current();
            this.isLegacyMetadata = Context.isFlagSet(context, 32);
            this.language = LanguageCode.create(context, locale);
            this.country = Country.create(context, locale);
            this.characterEncoding = encoding;
        }

        @XmlElement(name="languageCode", namespace="http://www.isotc211.org/2005/gmd")
        public LanguageCode getLanguageCode() {
            return this.isLegacyMetadata ? this.language : null;
        }

        public void setLanguageCode(LanguageCode newValue) {
            this.language = newValue;
        }

        @XmlElement(name="language", required=true)
        public LanguageCode getLanguage() {
            return this.isLegacyMetadata ? null : this.language;
        }

        public void setLanguage(LanguageCode newValue) {
            this.language = newValue;
        }

        public void beforeMarshal(Marshaller marshaller) {
            if (this.characterEncoding == null) {
                String encoding;
                try {
                    encoding = (String)marshaller.getProperty("jaxb.encoding");
                }
                catch (PropertyException | ClassCastException e) {
                    Context.warningOccured(Context.current(), PT_Locale.class, "beforeMarshal", (Exception)e, true);
                    return;
                }
                if (encoding != null) {
                    Context context = Context.current();
                    this.characterEncoding = Context.converter(context).toCharset(context, encoding);
                }
            }
        }
    }

    private static final class Sequence
    extends AbstractSet<PT_Locale> {
        final Map<Locale, Charset> locales;

        Sequence(Map<Locale, Charset> locales) {
            this.locales = locales;
        }

        @Override
        public int size() {
            return this.locales.size();
        }

        @Override
        public boolean add(PT_Locale value) {
            return value != null && value.addInto(this.locales);
        }

        @Override
        public Iterator<PT_Locale> iterator() {
            final Iterator<Map.Entry<Locale, Charset>> it = this.locales.entrySet().iterator();
            return new Iterator<PT_Locale>(){
                final /* synthetic */ Sequence this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public PT_Locale next() {
                    return new PT_Locale((Map.Entry)it.next());
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }
    }
}

