/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.j2d;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Iterator;
import org.apache.sis.geometry.wrapper.j2d.FlatShape;
import org.apache.sis.geometry.wrapper.j2d.Polygon;
import org.apache.sis.util.Classes;

class Polyline
extends FlatShape {
    private final float[] coordinates;
    private final AffineTransform inflate;

    Polyline(double[] coordinates, int size) {
        super(coordinates, size);
        this.coordinates = new float[size];
        double tx = Polyline.round(this.bounds.getCenterX(), this.bounds.xmin, this.bounds.xmax);
        double ty = Polyline.round(this.bounds.getCenterY(), this.bounds.ymin, this.bounds.ymax);
        this.inflate = AffineTransform.getTranslateInstance(tx, ty);
        AffineTransform.getTranslateInstance(-tx, -ty).transform(coordinates, 0, this.coordinates, 0, size / 2);
    }

    private static double round(double center, double min, double max) {
        int e = Math.getExponent(Math.max(Math.abs(min), Math.abs(max))) - 20;
        return Math.scalb(Math.round(Math.scalb(center, -e)), e);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.bounds.contains(x, y) && Path2D.contains(this.iterator(), x, y);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.bounds.intersects(x, y, w, h) && Path2D.intersects(this.iterator(), x, y, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.bounds.intersects(r) && Path2D.intersects(this.iterator(), r);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.bounds.contains(x, y, w, h) && Path2D.contains(this.iterator(), x, y, w, h);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.bounds.contains(r) && Path2D.contains(this.iterator(), r);
    }

    private PathIterator iterator() {
        return this.getPathIterator(null);
    }

    @Override
    public final PathIterator getPathIterator(AffineTransform at) {
        return new Iter(at, this, Collections.emptyIterator());
    }

    public String toString() {
        return Classes.getShortClassName((Object)this) + "[" + this.coordinates.length / 2 + " points]";
    }

    static final class Iter
    implements PathIterator {
        private final AffineTransform toUserSpace;
        private AffineTransform inflate;
        private final Iterator<Polyline> polylines;
        private float[] coordinates;
        private int position;
        private boolean closing;
        private boolean isPolygon;
        private boolean isDone;

        Iter() {
            this.toUserSpace = null;
            this.polylines = null;
            this.isDone = true;
        }

        Iter(AffineTransform at, Polyline first, Iterator<Polyline> next) {
            if (at != null) {
                this.inflate = new AffineTransform();
            }
            this.toUserSpace = at;
            this.polylines = next;
            this.setSource(first);
        }

        private void setSource(Polyline polyline) {
            this.isPolygon = polyline instanceof Polygon;
            this.coordinates = polyline.coordinates;
            if (this.toUserSpace != null) {
                this.inflate.setTransform(this.toUserSpace);
                this.inflate.concatenate(polyline.inflate);
            } else {
                this.inflate = polyline.inflate;
            }
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.isDone;
        }

        @Override
        public void next() {
            if ((this.position += 2) >= this.coordinates.length) {
                if (this.isPolygon) {
                    boolean bl = this.closing = !this.closing;
                    if (this.closing) {
                        return;
                    }
                }
                if (this.polylines.hasNext()) {
                    this.setSource(this.polylines.next());
                    this.position = 0;
                } else {
                    this.isDone = true;
                }
            }
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.closing) {
                return 4;
            }
            this.inflate.transform(this.coordinates, this.position, coords, 0, 1);
            return this.position == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.closing) {
                return 4;
            }
            this.inflate.transform(this.coordinates, this.position, coords, 0, 1);
            return this.position == 0 ? 0 : 1;
        }
    }
}

