/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.wizards.np;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.sling.ide.eclipse.ui.wizards.np.AbstractNewMavenBasedSlingApplicationWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2e.core.project.IArchetype;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.archetype.ArchetypePlugin;
import org.eclipse.m2e.core.ui.internal.archetype.MavenArchetype;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ArchetypeParametersWizardPage
extends WizardPage {
    private static final String KEY_PROPERTY = "key";
    private static final String VALUE_PROPERTY = "value";
    private Text groupId;
    private Text artifactId;
    private Text javaPackage;
    private boolean javaPackageModified;
    private final AbstractNewMavenBasedSlingApplicationWizard parent;
    private TableViewer propertiesViewer;
    private Table propertiesTable;
    private List<RequiredProperty> properties;
    private Text version;

    public ArchetypeParametersWizardPage(AbstractNewMavenBasedSlingApplicationWizard parent) {
        super("archetypeParametersPage");
        this.parent = parent;
        this.setTitle("Configure Archetype Properties");
        this.setDescription("This step configures the archetype properties");
        this.setImageDescriptor(parent.getLogo());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Group Id:");
        this.groupId = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.groupId.setLayoutData((Object)gd);
        this.groupId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArchetypeParametersWizardPage.this.dialogChanged();
                if (!ArchetypeParametersWizardPage.this.javaPackageModified) {
                    if (ArchetypeParametersWizardPage.this.artifactId.getText().length() == 0) {
                        ArchetypeParametersWizardPage.this.javaPackage.setText(ArchetypeParametersWizardPage.getDefaultJavaPackage(ArchetypeParametersWizardPage.this.groupId.getText(), ""));
                    } else {
                        ArchetypeParametersWizardPage.this.javaPackage.setText(ArchetypeParametersWizardPage.getDefaultJavaPackage(ArchetypeParametersWizardPage.this.groupId.getText(), ArchetypeParametersWizardPage.this.artifactId.getText()));
                    }
                }
            }
        });
        label = new Label(container, 0);
        label.setText("&Artifact Id:");
        this.artifactId = new Text(container, 2052);
        gd = new GridData(768);
        this.artifactId.setLayoutData((Object)gd);
        this.artifactId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArchetypeParametersWizardPage.this.dialogChanged();
                if (ArchetypeParametersWizardPage.this.javaPackageModified) {
                    return;
                }
                if (ArchetypeParametersWizardPage.this.groupId.getText().length() == 0) {
                    ArchetypeParametersWizardPage.this.javaPackage.setText(ArchetypeParametersWizardPage.getDefaultJavaPackage("", ArchetypeParametersWizardPage.this.artifactId.getText()));
                } else {
                    ArchetypeParametersWizardPage.this.javaPackage.setText(ArchetypeParametersWizardPage.getDefaultJavaPackage(ArchetypeParametersWizardPage.this.groupId.getText(), ArchetypeParametersWizardPage.this.artifactId.getText()));
                }
            }
        });
        label = new Label(container, 0);
        label.setText("&Version:");
        this.version = new Text(container, 2052);
        gd = new GridData(768);
        this.version.setLayoutData((Object)gd);
        this.version.setText("0.0.1-SNAPSHOT");
        this.version.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArchetypeParametersWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("&Package:");
        this.javaPackage = new Text(container, 2052);
        gd = new GridData(768);
        this.javaPackage.setLayoutData((Object)gd);
        this.javaPackageModified = false;
        this.javaPackage.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ArchetypeParametersWizardPage.this.javaPackageModified = true;
            }
        });
        this.javaPackage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArchetypeParametersWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        gd = new GridData(16384, 128, false, false);
        label.setLayoutData((Object)gd);
        label.setText("&Parameters:");
        this.propertiesViewer = new TableViewer(container, 67584);
        this.propertiesTable = this.propertiesViewer.getTable();
        this.propertiesTable.setLinesVisible(true);
        this.propertiesTable.setHeaderVisible(true);
        this.propertiesTable.setLayoutData((Object)new GridData(4, 4, true, true, 2, 2));
        CellNavigationStrategy strategy = new CellNavigationStrategy();
        TableViewerFocusCellManager focusCellMgr = new TableViewerFocusCellManager(this.propertiesViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.propertiesViewer), strategy);
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.propertiesViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        int features = 122;
        TableViewerEditor.create((TableViewer)this.propertiesViewer, (SWTFocusCellManager)focusCellMgr, (ColumnViewerEditorActivationStrategy)actSupport, (int)features);
        TableColumn propertiesTableNameColumn = new TableColumn(this.propertiesTable, 0);
        propertiesTableNameColumn.setWidth(130);
        propertiesTableNameColumn.setText("Name");
        TableColumn propertiesTableValueColumn = new TableColumn(this.propertiesTable, 0);
        propertiesTableValueColumn.setWidth(230);
        propertiesTableValueColumn.setText("Value");
        this.propertiesViewer.setColumnProperties(new String[]{KEY_PROPERTY, VALUE_PROPERTY});
        this.propertiesViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.propertiesTable, 0), new TextCellEditor((Composite)this.propertiesTable, 0)});
        this.propertiesViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof TableItem) {
                    ((TableItem)element).setText(ArchetypeParametersWizardPage.this.getTextIndex(property), String.valueOf(value));
                    ArchetypeParametersWizardPage.this.dialogChanged();
                }
            }

            public Object getValue(Object element, String property) {
                if (element instanceof TableItem) {
                    return ((TableItem)element).getText(ArchetypeParametersWizardPage.this.getTextIndex(property));
                }
                return null;
            }
        });
        this.initialize();
        this.setPageComplete(false);
        this.setControl((Control)container);
    }

    protected int getTextIndex(String property) {
        if (KEY_PROPERTY.equals(property)) {
            return 0;
        }
        return 1;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initialize();
        }
    }

    private void initialize() {
        if (this.propertiesTable == null) {
            return;
        }
        Archetype archetype = this.parent.getChooseArchetypePage().getSelectedArchetype();
        if (archetype == null) {
            return;
        }
        try {
            ArchetypePlugin archetypeManager = M2EUIPluginActivator.getDefault().getArchetypePlugin();
            MavenArchetype mavenArchetype = new MavenArchetype(archetype);
            this.properties = archetypeManager.getRequiredProperties((IArchetype)mavenArchetype, null);
            Table table = this.propertiesViewer.getTable();
            table.setItemCount(this.properties.size());
            int i = 0;
            for (RequiredProperty rp : this.properties) {
                TableItem item = table.getItem(i++);
                if (rp.getKey().equals(item.getText())) continue;
                item.setText(0, rp.getKey());
                item.setText(1, "");
                item.setData((Object)item);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not process archetype: " + e.getMessage(), e);
        }
    }

    private void dialogChanged() {
        if (this.groupId.getText().length() == 0) {
            this.updateStatus("group Id must be specified");
            return;
        }
        if (this.artifactId.getText().length() == 0) {
            this.updateStatus("artifact Id must be specified");
            return;
        }
        if (this.version.getText().length() == 0) {
            this.updateStatus("version must be specified");
            return;
        }
        if (this.javaPackage.getText().length() == 0) {
            this.updateStatus("package must be specified");
            return;
        }
        IProject existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.artifactId.getText());
        if (existingProject.exists()) {
            this.updateStatus("A project with the name " + this.artifactId.getText() + " already exists.");
            return;
        }
        int cnt = this.propertiesTable.getItemCount();
        int i = 0;
        while (i < cnt) {
            TableItem item = this.propertiesTable.getItem(i);
            if (item.getText(1).length() == 0) {
                this.updateStatus(item.getText(0) + " must be specified");
                return;
            }
            ++i;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getGroupId() {
        return this.groupId.getText();
    }

    public String getArtifactId() {
        return this.artifactId.getText();
    }

    public String getVersion() {
        return this.version.getText();
    }

    public String getJavaPackage() {
        return this.javaPackage.getText();
    }

    public Map<String, String> getProperties() {
        int cnt = this.propertiesTable.getItemCount();
        HashMap<String, String> p = new HashMap<String, String>();
        int i = 0;
        while (i < cnt) {
            TableItem item = this.propertiesTable.getItem(i);
            p.put(item.getText(0), item.getText(1));
            ++i;
        }
        return p;
    }

    public static String getDefaultJavaPackage(String groupId, String artifactId) {
        String name = artifactId.isEmpty() ? groupId : groupId + "." + artifactId;
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(name.replaceAll("-", "_"), ".");
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            while (part.length() > 0 && !Character.isJavaIdentifierStart(part.charAt(0))) {
                part = part.substring(1);
            }
            if (part.length() == 0) continue;
            if (sb.length() != 0) {
                sb.append(".");
            }
            sb.append(part);
        }
        return sb.toString();
    }
}

