/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.internal.validation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Manifest;
import org.apache.sling.ide.eclipse.core.internal.Activator;
import org.apache.sling.ide.eclipse.core.internal.ProjectHelper;
import org.apache.sling.ide.log.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;

public class ServiceComponentHeaderValidator {
    public List<IFile> findMissingScrDescriptors(IFile manifest) throws CoreException {
        IProject project = manifest.getProject();
        Logger pluginLogger = Activator.getDefault().getPluginLogger();
        IJavaProject javaProject = ProjectHelper.asJavaProject(project);
        IFolder outputFolder = (IFolder)project.getWorkspace().getRoot().findMember(javaProject.getOutputLocation());
        if (!outputFolder.getFullPath().isPrefixOf(manifest.getFullPath())) {
            pluginLogger.trace("Ignoring manifest found at {0} since it is not under the output directory at {1}", new Object[]{manifest.getFullPath(), outputFolder.getFullPath()});
            return Collections.emptyList();
        }
        ArrayList<IFile> missingDescriptors = new ArrayList<IFile>();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (InputStream contents = manifest.getContents();){
                Manifest mf = new Manifest(contents);
                String serviceComponentHeader = mf.getMainAttributes().getValue("Service-Component");
                if (serviceComponentHeader != null) {
                    String[] entries;
                    String[] stringArray = entries = serviceComponentHeader.split(",");
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String entry = stringArray[n2];
                        if ((entry = entry.trim()).contains("*")) {
                            pluginLogger.trace("Ignoring wildcard Service-Component entry {0}", new Object[]{entry});
                        } else {
                            IFile descriptor = outputFolder.getFile(entry);
                            if (descriptor.exists()) {
                                pluginLogger.trace("Found matching resource for Service-Component entry {0}", new Object[]{entry});
                            } else {
                                missingDescriptors.add(descriptor);
                                pluginLogger.trace("Raising error for missing DS descriptor entry {0}", new Object[]{entry});
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Unable to access " + String.valueOf(manifest.getFullPath()), (Throwable)e));
        }
        return missingDescriptors;
    }
}

