/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.impl;

import java.io.File;
import java.io.FileFilter;
import java.util.Map;

public class DirectoryUtil {
    private static final String[] BUNDLE_EXTENSIONS = new String[]{".jar", ".war"};
    public static final String PATH_STARTUP = "startup";
    public static final String PATH_CONF = "conf";
    public static final FileFilter DIRECTORY_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }
    };
    public static final FileFilter BUNDLE_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isFile() && DirectoryUtil.isBundle(f.getName());
        }
    };

    public static boolean isBundle(String path) {
        for (String extension : BUNDLE_EXTENSIONS) {
            if (!path.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public static File getHomeDir(Map<String, String> properties) {
        String home = properties.get("sling.launchpad");
        if (home == null) {
            home = properties.get("sling.home");
        }
        return new File(home);
    }

    public static File getConfigDir(Map<String, String> properties) {
        return new File(DirectoryUtil.getHomeDir(properties), PATH_CONF);
    }

    public static File getStartupDir(Map<String, String> properties) {
        return new File(DirectoryUtil.getHomeDir(properties), PATH_STARTUP);
    }
}

