/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.servlethelpers.internalrequests;

import javax.servlet.Servlet;

import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.ServletResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MockServletResolver implements ServletResolver {

    /**
     * @deprecated Use {@link #resolve(SlingJakartaHttpServletRequest)} instead.
     */
    @Deprecated(since = "2.0.0")
    @Override
    public Servlet resolveServlet(org.apache.sling.api.SlingHttpServletRequest request) {
        if (request.getResource() != null
                && "/NOSERVLET".equals(request.getResource().getPath())) {
            return null;
        } else {
            return new RequestInfoServlet(request);
        }
    }

    /**
     * @deprecated Use {@link #resolve(SlingJakartaHttpServletRequest)} instead.
     */
    @Deprecated(since = "2.0.0")
    @Override
    public Servlet resolveServlet(Resource resource, String scriptName) {
        throw new UnsupportedOperationException();
    }

    /**
     * @deprecated Use {@link #resolve(SlingJakartaHttpServletRequest)} instead.
     */
    @Deprecated(since = "2.0.0")
    @Override
    public Servlet resolveServlet(ResourceResolver resolver, String scriptName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public jakarta.servlet.@Nullable Servlet resolve(@NotNull SlingJakartaHttpServletRequest request) {
        if (request.getResource() != null
                && "/NOSERVLET".equals(request.getResource().getPath())) {
            return null;
        } else {
            return new JakartaRequestInfoServlet(request);
        }
    }

    @Override
    public jakarta.servlet.@Nullable Servlet resolve(@NotNull Resource resource, @NotNull String scriptName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public jakarta.servlet.@Nullable Servlet resolve(@NotNull ResourceResolver resolver, @NotNull String scriptName) {
        throw new UnsupportedOperationException();
    }
}
