/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.context;

import java.lang.reflect.Constructor;
import net.sf.oval.Validator;
import net.sf.oval.context.OValContext;
import net.sf.oval.internal.util.SerializableConstructor;
import net.sf.oval.internal.util.StringUtils;

public class ConstructorParameterContext
extends OValContext {
    private static final long serialVersionUID = 1L;
    private final SerializableConstructor constructor;
    private final int parameterIndex;
    private final String parameterName;

    public ConstructorParameterContext(Constructor<?> constructor, int parameterIndex, String parameterName) {
        this.constructor = new SerializableConstructor(constructor);
        this.parameterIndex = parameterIndex;
        this.parameterName = parameterName;
        this.compileTimeType = constructor.getParameterTypes()[parameterIndex];
    }

    public Constructor<?> getConstructor() {
        return this.constructor.getConstructor();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.constructor.getDeclaringClass();
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String toString() {
        return String.valueOf(this.constructor.getDeclaringClass().getName()) + "." + this.toStringUnqualified();
    }

    @Override
    public String toStringUnqualified() {
        return "<init>(" + StringUtils.join(this.constructor.getParameterTypes(), ',') + ") " + Validator.getMessageResolver().getMessage("net.sf.oval.context.ConstructorParameterContext.parameter") + " " + this.parameterIndex + (this.parameterName == null || this.parameterName.length() == 0 ? "" : " (" + this.parameterName + ")");
    }
}

