/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.hibernate.web.internal;

import org.apache.tapestry5.hibernate.web.internal.EntityPersistentFieldStrategy;
import org.apache.tapestry5.hibernate.web.internal.SessionRestorable;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.internal.services.SessionApplicationStatePersistenceStrategy;
import org.apache.tapestry5.services.ApplicationStateCreator;
import org.hibernate.Session;

public class EntityApplicationStatePersistenceStrategy
extends SessionApplicationStatePersistenceStrategy {
    private final EntityPersistentFieldStrategy delegate;

    public EntityApplicationStatePersistenceStrategy(Request request, Session hibernateSession) {
        super(request);
        this.delegate = new EntityPersistentFieldStrategy(hibernateSession, null);
    }

    protected <T> T transformPersistedValue(Object value) {
        return (T)(value instanceof SessionRestorable ? this.delegate.convertPersistedToApplicationValue(value) : value);
    }

    public <T> T get(Class<T> ssoClass, ApplicationStateCreator<T> creator) {
        Object persistedValue = this.getOrCreate(ssoClass, creator);
        if (persistedValue instanceof SessionRestorable) {
            T restored = this.transformPersistedValue(persistedValue);
            if (restored == null) {
                this.set(ssoClass, null);
                return (T)this.getOrCreate(ssoClass, creator);
            }
            return restored;
        }
        return (T)persistedValue;
    }

    public <T> void set(Class<T> ssoClass, T sso) {
        String key = this.buildKey(ssoClass);
        if (sso == null) {
            this.getSession().setAttribute(key, null);
            return;
        }
        Object persistable = this.delegate.convertApplicationValueToPersisted(sso);
        this.getSession().setAttribute(key, persistable);
    }
}

