/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.function;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.jsr223.SingleGremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.util.function.TriConsumer;

public final class ScriptEngineLambda
implements Function,
Supplier,
Consumer,
Predicate,
BiConsumer,
TriConsumer {
    private static final String A = "a";
    private static final String B = "b";
    private static final String C = "c";
    protected final ScriptEngine engine;
    protected final String script;

    public ScriptEngineLambda(String engineName, String script) {
        this.engine = SingleGremlinScriptEngineManager.get(engineName);
        this.script = script;
    }

    public Object apply(Object a) {
        try {
            SimpleBindings bindings = new SimpleBindings();
            bindings.put(A, a);
            return this.engine.eval(this.script, (Bindings)bindings);
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public Object get() {
        try {
            return this.engine.eval(this.script);
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void accept(Object a) {
        try {
            SimpleBindings bindings = new SimpleBindings();
            bindings.put(A, a);
            this.engine.eval(this.script, (Bindings)bindings);
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void accept(Object a, Object b) {
        try {
            SimpleBindings bindings = new SimpleBindings();
            bindings.put(A, a);
            bindings.put(B, b);
            this.engine.eval(this.script, (Bindings)bindings);
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void accept(Object a, Object b, Object c) {
        try {
            SimpleBindings bindings = new SimpleBindings();
            bindings.put(A, a);
            bindings.put(B, b);
            bindings.put(C, c);
            this.engine.eval(this.script, (Bindings)bindings);
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public boolean test(Object a) {
        try {
            SimpleBindings bindings = new SimpleBindings();
            bindings.put(A, a);
            return (Boolean)this.engine.eval(this.script, (Bindings)bindings);
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

