/*
 * AsteriskTemplate.java
 *
 * Brazil project web application toolkit,
 * export version: 2.1 
 * Copyright (c) 2004 Sun Microsystems, Inc.
 *
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version 
 * 1.0 (the "License"). You may not use this file except in compliance with 
 * the License. A copy of the License is included as the file "license.terms",
 * and also available at http://www.sun.com/
 * 
 * The Original Code is from:
 *    Brazil project web application toolkit release 2.1.
 * The Initial Developer of the Original Code is: suhler.
 * Portions created by suhler are Copyright (C) Sun Microsystems, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s): suhler.
 *
 * Version:  1.2
 * Created by suhler on 04/10/26
 * Last modified by suhler on 04/10/26 11:27:38
 */

package sunlabs.brazil.sunlabs;

import java.io.IOException;
import java.net.Socket;
import sunlabs.brazil.server.Request;
import sunlabs.brazil.template.QueueTemplate;
import sunlabs.brazil.template.RewriteContext;
import sunlabs.brazil.template.Template;
import sunlabs.brazil.util.http.HttpInputStream;
import sunlabs.brazil.util.regexp.Regexp;
import java.util.Enumeration;

/**
 * Connect to Asterisk manager api.  There is exactly one connection
 * per server.  Take care.
 * Usage:<pre>
 * &lt;asterisk host=host:port user=xxx pass=xxx queue=xxx&gt;
 * &lt;asterisk action=xxx name1=value1 ...&gt;
 * &lt;dequeue name=asterisk&gt;
 * </pre>
 * <p>
 * Connect to the Asterisk PBX management console. Actions are the management
 * api actions, followed by the appropriate name=value pairs.  Results
 * are posted to a queue (see the QueueTemplate).
 */

public class AsteriskTemplate extends Template  {
    static boolean init = false;	
    static Request.HttpOutputStream out = null;  // where to write commands to

    public void
    tag_asterisk(RewriteContext hr) {
	if (!init && !start(hr)) {
	   System.out.println("Can't contact asterisk server, sorry");
	   return;
	}
	debug(hr);
	hr.killToken();
	String action = hr.get("action");
	if (action == null) {
	    System.out.println("need action!");
	    return;
	}

	StringBuffer sb = new StringBuffer();
	sb.append("Action: ").append(action).append("\r\n");
	Enumeration e = hr.keys();
	while(e.hasMoreElements()) {
	    String key = (String) e.nextElement();
	    if (key.equals("action")) {
		continue;
	    }
	    sb.append(key).append(": ").append(hr.get(key)).append("\r\n");
	}
	sb.append("\r\n");
	System.out.println("Sending(" + sb + ")");
	try {
	    out.writeBytes(sb.toString());
	    out.flush();
	} catch (IOException ex) {
	    System.out.println("Oops: " + ex);
	    init=false;
	}
    }

    /*
     * Initiate a manager connection to the asterisk server
     */

    static boolean start(RewriteContext hr) {
        String host = hr.get("host", null);
        String user = hr.get("user", null);
        String pass = hr.get("pass", null);
	String queueName= hr.get("queue", "asterisk");
	int port = 5038;

        if (host==null || user == null || pass==null) {
	    System.out.println("need host:port, user, pass");
	    return false;
        }
	int index = host.indexOf(":");
	if (index > 0) {
	    host = host.substring(0,index);
	    try {
		port = Integer.decode(host.substring(index+1)).intValue();
	    } catch (Exception e) {
	        System.out.println("invalid port: " + host);
		return false;
	    }
	}

	try {
	    Socket s = new Socket(host, port);
	    out = new Request.HttpOutputStream(
			s.getOutputStream());
	    SocketReader reader = new SocketReader(queueName,
		    new HttpInputStream( s.getInputStream()));
	    reader.start();
	    String login = "Action: login\r\nUserName: " + user + "\r\n" +
		"Secret: " + pass + "\r\n\r\n";
	    out.writeBytes(login);
	    out.flush();
	    System.out.println("Setting up asterisk manager interface");
	    init = true;
	    return true;
	} catch (Exception e) {
	    System.out.println("Oops: " + e);
	    return false;
	}
    }

    /**
     * Start a thread to read lines from a socket, and dump them
     * onto a Q
     */

    static class SocketReader extends Thread {
	String id;		// the Queue name to dump results into
	HttpInputStream in;	// the input stream to read from

	public SocketReader(String id, HttpInputStream in) {
	    this.id = id;
	    this.in = in;
	}

	/**
	 * Wait for messages from server, place on Q
	 */

        public void run() {
	    System.out.println(id + ": run() starting reader");
	    boolean ok = true;
	    while(ok) {
		try {
		    String s = in.readLine();
		    System.out.println(id + ": read (" + s + ")");
		    if (s != null) {
			QueueTemplate.enqueue(id, "asterisk",
			s, "", false, false); 
		    } else {
			QueueTemplate.enqueue(id, "asterisk",
			"", "bye", false, false); 
			init=false;
			System.out.println("DIED!!!");
			return;
		    }
		} catch (IOException e) {
		    System.out.println(id + ": " + e);
		    break;
		}
	    }
	    System.out.println(id + ": run() stopped");
	    try {
		in.close();
	    } catch (Exception e) {}
	}
    }
}
