/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.annotations;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.cache.Cache;
import org.gradle.cache.internal.ClassCacheFactory;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.properties.annotations.AnnotationHandler;
import org.gradle.internal.properties.annotations.FunctionAnnotationHandler;
import org.gradle.internal.properties.annotations.FunctionMetadata;
import org.gradle.internal.properties.annotations.MissingPropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.properties.annotations.PropertyTypeResolver;
import org.gradle.internal.properties.annotations.TypeAnnotationHandler;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.properties.annotations.TypeMetadataStore;
import org.gradle.internal.reflect.annotations.AnnotationCategory;
import org.gradle.internal.reflect.annotations.FunctionAnnotationMetadata;
import org.gradle.internal.reflect.annotations.PropertyAnnotationMetadata;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadata;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadataStore;
import org.gradle.internal.reflect.validation.ReplayingTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.util.internal.TextUtil;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class DefaultTypeMetadataStore
implements TypeMetadataStore {
    private final Collection<? extends TypeAnnotationHandler> typeAnnotationHandlers;
    private final ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> propertyAnnotationHandlers;
    private final ImmutableMap<Class<? extends Annotation>, ? extends FunctionAnnotationHandler> functionAnnotationHandlers;
    private final ImmutableSet<Class<? extends Annotation>> allowedPropertyModifiers;
    private final ImmutableSet<Class<? extends Annotation>> allowedFunctionModifiers;
    private final Cache<Class<?>, TypeMetadata> cache;
    private final TypeAnnotationMetadataStore typeAnnotationMetadataStore;
    private final PropertyTypeResolver propertyTypeResolver;
    private final String displayName;
    private final MissingPropertyAnnotationHandler missingPropertyAnnotationHandler;
    private static final String ANNOTATION_INVALID_IN_CONTEXT = "ANNOTATION_INVALID_IN_CONTEXT";
    private static final String INCOMPATIBLE_ANNOTATIONS = "INCOMPATIBLE_ANNOTATIONS";

    public DefaultTypeMetadataStore(Collection<? extends TypeAnnotationHandler> typeAnnotationHandlers, Collection<? extends PropertyAnnotationHandler> propertyAnnotationHandlers, Collection<Class<? extends Annotation>> allowedPropertyModifiers, Collection<? extends FunctionAnnotationHandler> functionAnnotationHandlers, Collection<Class<? extends Annotation>> allowedFunctionModifiers, TypeAnnotationMetadataStore typeAnnotationMetadataStore, PropertyTypeResolver propertyTypeResolver, ClassCacheFactory cacheFactory, MissingPropertyAnnotationHandler missingPropertyAnnotationHandler) {
        this.typeAnnotationHandlers = ImmutableSet.copyOf(typeAnnotationHandlers);
        this.propertyAnnotationHandlers = Maps.uniqueIndex(propertyAnnotationHandlers, AnnotationHandler::getAnnotationType);
        this.allowedPropertyModifiers = ImmutableSet.copyOf(allowedPropertyModifiers);
        this.functionAnnotationHandlers = Maps.uniqueIndex(functionAnnotationHandlers, AnnotationHandler::getAnnotationType);
        this.allowedFunctionModifiers = ImmutableSet.copyOf(allowedFunctionModifiers);
        this.typeAnnotationMetadataStore = typeAnnotationMetadataStore;
        this.displayName = DefaultTypeMetadataStore.calculateDisplayName(propertyAnnotationHandlers);
        this.propertyTypeResolver = propertyTypeResolver;
        this.cache = cacheFactory.newClassCache();
        this.missingPropertyAnnotationHandler = missingPropertyAnnotationHandler;
    }

    private static String calculateDisplayName(Collection<? extends PropertyAnnotationHandler> annotationHandlers) {
        return annotationHandlers.stream().map(PropertyAnnotationHandler::getKind).anyMatch(Predicate.isEqual((Object)PropertyAnnotationHandler.Kind.OUTPUT)) ? "an input or output annotation" : "an input annotation";
    }

    @Override
    public <T> TypeMetadata getTypeMetadata(Class<T> type) {
        return (TypeMetadata)this.cache.get(type, this::createTypeMetadata);
    }

    private <T> TypeMetadata createTypeMetadata(Class<T> type) {
        Class publicType = GeneratedSubclasses.unpack(type);
        ReplayingTypeValidationContext validationContext = new ReplayingTypeValidationContext();
        TypeAnnotationMetadata annotationMetadata = this.typeAnnotationMetadataStore.getTypeAnnotationMetadata(publicType);
        annotationMetadata.visitValidationFailures((TypeValidationContext)validationContext);
        for (TypeAnnotationHandler typeAnnotationHandler : this.typeAnnotationHandlers) {
            if (!annotationMetadata.isAnnotationPresent(typeAnnotationHandler.getAnnotationType())) continue;
            typeAnnotationHandler.validateTypeMetadata(publicType, (TypeValidationContext)validationContext);
        }
        ImmutableSet<PropertyMetadata> effectiveProperties = this.getEffectiveProperties(annotationMetadata, validationContext);
        ImmutableSet<FunctionMetadata> immutableSet = this.getEffectiveFunctions(annotationMetadata, validationContext);
        return new DefaultTypeMetadata(publicType, effectiveProperties, immutableSet, validationContext, this.propertyAnnotationHandlers, this.functionAnnotationHandlers, annotationMetadata);
    }

    private @NonNull ImmutableSet<PropertyMetadata> getEffectiveProperties(TypeAnnotationMetadata annotationMetadata, ReplayingTypeValidationContext validationContext) {
        ImmutableSet.Builder effectiveProperties = ImmutableSet.builderWithExpectedSize((int)annotationMetadata.getPropertiesAnnotationMetadata().size());
        for (PropertyAnnotationMetadata propertyAnnotationMetadata : annotationMetadata.getPropertiesAnnotationMetadata()) {
            ImmutableMap propertyAnnotations = propertyAnnotationMetadata.getAnnotationsByCategory();
            Class<? extends Annotation> propertyType = this.propertyTypeResolver.resolveAnnotationType((Map<AnnotationCategory, Annotation>)propertyAnnotations);
            if (propertyType == null) {
                this.missingPropertyAnnotationHandler.handleMissingPropertyAnnotation((TypeValidationContext)validationContext, propertyAnnotationMetadata, this.displayName);
                continue;
            }
            PropertyAnnotationHandler annotationHandler = (PropertyAnnotationHandler)this.propertyAnnotationHandlers.get(propertyType);
            if (annotationHandler == null) {
                validationContext.visitPropertyProblem(problem -> problem.forProperty(propertyAnnotationMetadata.getPropertyName()).id(TextUtil.screamingSnakeToKebabCase((String)ANNOTATION_INVALID_IN_CONTEXT), "Invalid annotation in context", GradleCoreProblemGroup.validation().property()).contextualLabel(String.format("is annotated with invalid property type @%s", propertyType.getSimpleName())).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)ANNOTATION_INVALID_IN_CONTEXT.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("The '@" + propertyType.getSimpleName() + "' annotation cannot be used in this context").solution("Remove the property").solution("Use a different annotation, e.g one of " + DefaultTypeMetadataStore.toListOfAnnotations((ImmutableSet<Class<? extends Annotation>>)this.propertyAnnotationHandlers.keySet())));
                continue;
            }
            ImmutableSet<Class<? extends Annotation>> allowedModifiersForPropertyType = annotationHandler.getAllowedModifiers();
            for (Map.Entry entry : propertyAnnotations.entrySet()) {
                AnnotationCategory annotationCategory = (AnnotationCategory)entry.getKey();
                if (annotationCategory == AnnotationCategory.TYPE) continue;
                Class<? extends Annotation> annotationType = ((Annotation)entry.getValue()).annotationType();
                if (!allowedModifiersForPropertyType.contains(annotationType)) {
                    validationContext.visitPropertyProblem(problem -> problem.forProperty(propertyAnnotationMetadata.getPropertyName()).id(TextUtil.screamingSnakeToKebabCase((String)INCOMPATIBLE_ANNOTATIONS), "Incompatible annotations", GradleCoreProblemGroup.validation().property()).contextualLabel("is annotated with @" + annotationType.getSimpleName() + " but that is not allowed for '" + propertyType.getSimpleName() + "' properties").documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)INCOMPATIBLE_ANNOTATIONS.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("This modifier is used in conjunction with a property of type '" + propertyType.getSimpleName() + "' but this doesn't have semantics").solution("Remove the '@" + annotationType.getSimpleName() + "' annotation"));
                    continue;
                }
                if (this.allowedPropertyModifiers.contains(annotationType)) continue;
                validationContext.visitPropertyProblem(problem -> problem.forProperty(propertyAnnotationMetadata.getPropertyName()).id(TextUtil.screamingSnakeToKebabCase((String)ANNOTATION_INVALID_IN_CONTEXT), "Invalid annotation in context", GradleCoreProblemGroup.validation().property()).contextualLabel(String.format("is annotated with invalid modifier @%s", annotationType.getSimpleName())).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)ANNOTATION_INVALID_IN_CONTEXT.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("The '@" + annotationType.getSimpleName() + "' annotation cannot be used in this context").solution("Use a different annotation, e.g one of " + DefaultTypeMetadataStore.toListOfAnnotations(this.allowedPropertyModifiers)).solution("Remove the annotation"));
            }
            DefaultPropertyMetadata property = new DefaultPropertyMetadata(propertyType, propertyAnnotationMetadata);
            annotationHandler.validatePropertyMetadata(property, (TypeValidationContext)validationContext);
            if (!annotationHandler.isPropertyRelevant()) continue;
            effectiveProperties.add((Object)property);
        }
        return effectiveProperties.build();
    }

    private @NonNull ImmutableSet<FunctionMetadata> getEffectiveFunctions(TypeAnnotationMetadata annotationMetadata, ReplayingTypeValidationContext validationContext) {
        ImmutableSet.Builder effectiveFunctions = ImmutableSet.builderWithExpectedSize((int)annotationMetadata.getFunctionAnnotationMetadata().size());
        for (FunctionAnnotationMetadata functionAnnotationMetadata : annotationMetadata.getFunctionAnnotationMetadata()) {
            ImmutableMap functionAnnotations = functionAnnotationMetadata.getAnnotationsByCategory();
            Annotation functionAnnotation = (Annotation)functionAnnotations.get(AnnotationCategory.TYPE);
            if (functionAnnotation == null) continue;
            Class<? extends Annotation> functionType = functionAnnotation.annotationType();
            FunctionAnnotationHandler annotationHandler = (FunctionAnnotationHandler)this.functionAnnotationHandlers.get(functionType);
            if (annotationHandler == null) {
                validationContext.visitPropertyProblem(problem -> problem.forFunction(functionAnnotationMetadata.getMethod().getName()).id(TextUtil.screamingSnakeToKebabCase((String)ANNOTATION_INVALID_IN_CONTEXT), "Invalid annotation in context", GradleCoreProblemGroup.validation().type()).contextualLabel(String.format("is annotated with invalid function type @%s", functionType.getSimpleName())).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)ANNOTATION_INVALID_IN_CONTEXT.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("The '@" + functionType.getSimpleName() + "' annotation cannot be used in this context").solution("Remove the method").solution("Use a different annotation, e.g one of " + DefaultTypeMetadataStore.toListOfAnnotations((ImmutableSet<Class<? extends Annotation>>)this.functionAnnotationHandlers.keySet())));
                continue;
            }
            ImmutableSet<Class<? extends Annotation>> allowedModifiersForFunctionType = annotationHandler.getAllowedModifiers();
            for (Map.Entry entry : functionAnnotations.entrySet()) {
                AnnotationCategory annotationCategory = (AnnotationCategory)entry.getKey();
                if (annotationCategory == AnnotationCategory.TYPE) continue;
                Class<? extends Annotation> annotationType = ((Annotation)entry.getValue()).annotationType();
                if (!allowedModifiersForFunctionType.contains(annotationType)) {
                    validationContext.visitPropertyProblem(problem -> problem.forFunction(functionAnnotationMetadata.getMethod().getName()).id(TextUtil.screamingSnakeToKebabCase((String)INCOMPATIBLE_ANNOTATIONS), "Incompatible annotations", GradleCoreProblemGroup.validation().type()).contextualLabel("is annotated with @" + annotationType.getSimpleName() + " but that is not allowed for '" + functionType.getSimpleName() + "' functions").documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)INCOMPATIBLE_ANNOTATIONS.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("This modifier is used in conjunction with a property of type '" + functionType.getSimpleName() + "' but this doesn't have semantics").solution("Remove the '@" + annotationType.getSimpleName() + "' annotation"));
                    continue;
                }
                if (this.allowedFunctionModifiers.contains(annotationType)) continue;
                validationContext.visitPropertyProblem(problem -> problem.forProperty(functionAnnotationMetadata.getMethod().getName()).id(TextUtil.screamingSnakeToKebabCase((String)ANNOTATION_INVALID_IN_CONTEXT), "Invalid annotation in context", GradleCoreProblemGroup.validation().property()).contextualLabel(String.format("is annotated with invalid modifier @%s", annotationType.getSimpleName())).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)ANNOTATION_INVALID_IN_CONTEXT.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("The '@" + annotationType.getSimpleName() + "' annotation cannot be used in this context").solution("Use a different annotation, e.g one of " + DefaultTypeMetadataStore.toListOfAnnotations(this.allowedPropertyModifiers)).solution("Remove the annotation"));
            }
            DefaultFunctionMetadata function = new DefaultFunctionMetadata(functionType, functionAnnotationMetadata);
            annotationHandler.validateFunctionMetadata(function, (TypeValidationContext)validationContext);
            effectiveFunctions.add((Object)function);
        }
        return effectiveFunctions.build();
    }

    private static String toListOfAnnotations(ImmutableSet<Class<? extends Annotation>> classes) {
        return classes.stream().map(Class::getSimpleName).map(s -> "@" + s).sorted().collect(DefaultTypeMetadataStore.forDisplay());
    }

    private static Collector<? super String, ?, String> forDisplay() {
        return Collectors.collectingAndThen(Collectors.toList(), stringList -> {
            if (stringList.isEmpty()) {
                return "";
            }
            if (stringList.size() == 1) {
                return (String)stringList.get(0);
            }
            int bound = stringList.size() - 1;
            return String.join((CharSequence)", ", stringList.subList(0, bound)) + " or " + (String)stringList.get(bound);
        });
    }

    private static class DefaultTypeMetadata
    implements TypeMetadata {
        private final Class<?> type;
        private final ImmutableSet<PropertyMetadata> propertiesMetadata;
        private final ImmutableSet<FunctionMetadata> functionsMetadata;
        private final ReplayingTypeValidationContext validationProblems;
        private final ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> propertyAnnotationHandlers;
        private final ImmutableMap<Class<? extends Annotation>, ? extends FunctionAnnotationHandler> functionAnnotationHandlers;
        private final TypeAnnotationMetadata typeAnnotationMetadata;

        DefaultTypeMetadata(Class<?> type, ImmutableSet<PropertyMetadata> propertiesMetadata, ImmutableSet<FunctionMetadata> functionsMetadata, ReplayingTypeValidationContext validationProblems, ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> propertyAnnotationHandlers, ImmutableMap<Class<? extends Annotation>, ? extends FunctionAnnotationHandler> functionAnnotationHandlers, TypeAnnotationMetadata typeAnnotationMetadata) {
            this.type = type;
            this.propertiesMetadata = propertiesMetadata;
            this.functionsMetadata = functionsMetadata;
            this.validationProblems = validationProblems;
            this.propertyAnnotationHandlers = propertyAnnotationHandlers;
            this.functionAnnotationHandlers = functionAnnotationHandlers;
            this.typeAnnotationMetadata = typeAnnotationMetadata;
        }

        @Override
        public void visitValidationFailures(@Nullable String ownerPropertyPath, TypeValidationContext validationContext) {
            this.validationProblems.replay(ownerPropertyPath, validationContext);
        }

        @Override
        public Set<PropertyMetadata> getPropertiesMetadata() {
            return this.propertiesMetadata;
        }

        @Override
        public Set<FunctionMetadata> getFunctionMetadata() {
            return this.functionsMetadata;
        }

        @Override
        public boolean hasAnnotatedProperties() {
            return !this.propertiesMetadata.isEmpty();
        }

        @Override
        public PropertyAnnotationHandler getAnnotationHandlerFor(PropertyMetadata propertyMetadata) {
            return (PropertyAnnotationHandler)this.propertyAnnotationHandlers.get(propertyMetadata.getPropertyType());
        }

        @Override
        public FunctionAnnotationHandler getAnnotationHandlerFor(FunctionMetadata functionMetadata) {
            return (FunctionAnnotationHandler)this.functionAnnotationHandlers.get(functionMetadata.getFunctionType());
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public TypeAnnotationMetadata getTypeAnnotationMetadata() {
            return this.typeAnnotationMetadata;
        }
    }

    private static class DefaultPropertyMetadata
    implements PropertyMetadata {
        private final Class<? extends Annotation> propertyType;
        private final PropertyAnnotationMetadata annotationMetadata;

        public DefaultPropertyMetadata(Class<? extends Annotation> propertyType, PropertyAnnotationMetadata annotationMetadata) {
            this.propertyType = propertyType;
            this.annotationMetadata = annotationMetadata;
        }

        @Override
        public String getPropertyName() {
            return this.annotationMetadata.getPropertyName();
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.annotationMetadata.isAnnotationPresent(annotationType);
        }

        @Override
        public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
            return this.annotationMetadata.getAnnotation(annotationType);
        }

        @Override
        public Optional<Annotation> getAnnotationForCategory(AnnotationCategory category) {
            return Optional.ofNullable((Annotation)this.annotationMetadata.getAnnotationsByCategory().get((Object)category));
        }

        @Override
        public boolean hasAnnotationForCategory(AnnotationCategory category) {
            return this.annotationMetadata.getAnnotationsByCategory().get((Object)category) != null;
        }

        @Override
        public Class<? extends Annotation> getPropertyType() {
            return this.propertyType;
        }

        @Override
        public TypeToken<?> getDeclaredType() {
            return this.annotationMetadata.getDeclaredReturnType();
        }

        @Override
        public @Nullable Object getPropertyValue(Object object) {
            return this.annotationMetadata.getPropertyValue(object);
        }

        public String toString() {
            return String.format("@%s %s", this.propertyType.getSimpleName(), this.getPropertyName());
        }
    }

    private static class DefaultFunctionMetadata
    implements FunctionMetadata {
        private final Class<? extends Annotation> functionType;
        private final FunctionAnnotationMetadata annotationMetadata;

        public DefaultFunctionMetadata(Class<? extends Annotation> functionType, FunctionAnnotationMetadata annotationMetadata) {
            this.functionType = functionType;
            this.annotationMetadata = annotationMetadata;
        }

        @Override
        public String getMethodName() {
            return this.annotationMetadata.getMethod().getName();
        }

        @Override
        public Method getMethod() {
            return this.annotationMetadata.getMethod();
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.annotationMetadata.isAnnotationPresent(annotationType);
        }

        @Override
        public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
            return this.annotationMetadata.getAnnotation(annotationType);
        }

        @Override
        public Optional<Annotation> getAnnotationForCategory(AnnotationCategory category) {
            return Optional.ofNullable((Annotation)this.annotationMetadata.getAnnotationsByCategory().get((Object)category));
        }

        @Override
        public boolean hasAnnotationForCategory(AnnotationCategory category) {
            return this.annotationMetadata.getAnnotationsByCategory().get((Object)category) != null;
        }

        @Override
        public Class<? extends Annotation> getFunctionType() {
            return this.functionType;
        }

        @Override
        public TypeToken<?> getDeclaredType() {
            return this.annotationMetadata.getDeclaredReturnType();
        }

        public int hashCode() {
            return this.annotationMetadata.hashCode();
        }

        public boolean equals(Object obj) {
            return this.annotationMetadata.equals(obj);
        }

        public String toString() {
            return this.annotationMetadata.toString();
        }
    }
}

