/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.executor.streaming;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.executor.streaming.MetadataLog;

public class DefaultMetadataLog<T>
implements MetadataLog<T> {
    private static final long MIN_ACCEPTABLE_ID = 0L;
    private final SortedMap<Long, T> metadataMap = new TreeMap<Long, T>();

    @Override
    public boolean add(Long batchId, T metadata) {
        Preconditions.checkArgument((batchId >= 0L ? 1 : 0) != 0, (Object)"batch id must large or equal 0");
        if (this.metadataMap.containsKey(batchId)) {
            return false;
        }
        this.metadataMap.put(batchId, metadata);
        return true;
    }

    @Override
    public Optional<T> get(Long batchId) {
        if (!this.metadataMap.containsKey(batchId)) {
            return Optional.empty();
        }
        return Optional.of(this.metadataMap.get(batchId));
    }

    @Override
    public List<T> get(Optional<Long> startBatchId, Optional<Long> endBatchId) {
        if (startBatchId.isEmpty() && endBatchId.isEmpty()) {
            return new ArrayList<T>(this.metadataMap.values());
        }
        Long s = startBatchId.orElse(0L);
        Long e = endBatchId.map(i -> i + 1L).orElse(Long.MAX_VALUE);
        return new ArrayList<T>(this.metadataMap.subMap(s, e).values());
    }

    @Override
    public Optional<Pair<Long, T>> getLatest() {
        if (this.metadataMap.isEmpty()) {
            return Optional.empty();
        }
        Long latestId = this.metadataMap.lastKey();
        return Optional.of(Pair.of((Object)latestId, this.metadataMap.get(latestId)));
    }

    @Override
    public void purge(Long batchId) {
        this.metadataMap.headMap(batchId).clear();
    }
}

