/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import java.lang.invoke.StringConcatFactory;
import java.lang.reflect.Method;
import java.text.Format;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LocalCacheProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.DataSourceUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.registry.NavigatorExtensionsRegistry;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.INavigatorNodeActionHandler;
import org.jkiss.dbeaver.ui.navigator.database.DefaultNavigatorNodeRenderer;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorThemeSettings;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class StatisticsNavigatorNodeRenderer
extends DefaultNavigatorNodeRenderer {
    private static final Log log = Log.getLog(StatisticsNavigatorNodeRenderer.class);
    private static final int ELEMENT_MARGIN = 3;
    private static final int PERCENT_FILL_WIDTH = 50;
    private static final boolean PAINT_ACTION_HOVER = false;
    private final INavigatorModelView view;
    private static final ByteNumberFormat numberFormat = new ByteNumberFormat();
    private final Map<String, Format> classFormatMap = new HashMap<String, Format>();
    private static final Map<DBSObject, StatReadJob> statReaders = new IdentityHashMap<DBSObject, StatReadJob>();

    public StatisticsNavigatorNodeRenderer(INavigatorModelView view) {
        this.view = view;
    }

    public INavigatorModelView getView() {
        return this.view;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paintNodeDetails(DBNNode node, Tree tree, GC gc, Event event) {
        super.paintNodeDetails(node, tree, gc, event);
        if (!(node instanceof DBNDatabaseNode)) {
            return;
        }
        DBNDatabaseNode dBNDatabaseNode = (DBNDatabaseNode)node;
        Rectangle client = StatisticsNavigatorNodeRenderer.getClientArea(tree);
        Rectangle item = StatisticsNavigatorNodeRenderer.getItemBounds(client, (TreeItem)event.item);
        boolean hovering = (event.detail & 0x20) != 0;
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        if (node instanceof DBNDataSource) {
            DBNDataSource dataSourceNode = (DBNDataSource)node;
            if (store.getBoolean("navigator.show.node.actions")) {
                this.drawDataSourceActions(gc, dataSourceNode, item, client, hovering);
            }
            if (store.getBoolean("navigator.show.connection.host")) {
                this.drawDataSourceAddress(gc, dataSourceNode, item);
            }
        } else {
            void databaseNode;
            if (store.getBoolean("navigator.show.statistics.info")) {
                this.drawObjectStatistics(gc, (DBNDatabaseNode)databaseNode, item, event);
            }
            if (node instanceof DBNDatabaseFolder && store.getBoolean("navigator.show.child.count") && !databaseNode.needsInitialization()) {
                this.drawObjectChildrenCounter(gc, (DBNDatabaseNode)databaseNode, item);
            }
            if (node instanceof DBNDatabaseItem && store.getBoolean("navigator.show.objects.description")) {
                this.drawObjectDescription(gc, (DBNDatabaseNode)databaseNode, item);
            }
        }
    }

    private void drawDataSourceAddress(@NotNull GC gc, @NotNull DBNDataSource node, @NotNull Rectangle bounds) {
        this.drawText(gc, DataSourceUtils.getDataSourceAddressText((DBPDataSourceContainer)node.getDataSourceContainer()), bounds);
    }

    private void drawDataSourceActions(@NotNull GC gc, @NotNull DBNDataSource node, @NotNull Rectangle item, @NotNull Rectangle client, boolean hovering) {
        List<INavigatorNodeActionHandler> actions = NavigatorExtensionsRegistry.getInstance().getNodeActions(this.getView(), (DBNNode)node);
        if (actions.isEmpty()) {
            return;
        }
        int width = (actions.size() - 1) * 3;
        for (INavigatorNodeActionHandler action : actions) {
            Image image = DBeaverIcons.getImage((DBPImage)action.getNodeActionIcon(this.getView(), (DBNNode)node));
            Rectangle size = image.getBounds();
            width += size.width;
        }
        boolean overdraw = hovering && item.width < width;
        Rectangle bounds = item;
        if (overdraw) {
            bounds = new Rectangle(client.x, bounds.y, client.width, bounds.height);
        }
        int i = actions.size() - 1;
        while (i >= 0) {
            INavigatorNodeActionHandler action = actions.get(i);
            Image image = DBeaverIcons.getImage((DBPImage)action.getNodeActionIcon(this.getView(), (DBNNode)node));
            Rectangle size = image.getBounds();
            if (bounds.width < size.width) {
                return;
            }
            if (overdraw) {
                gc.setBackground(gc.getDevice().getSystemColor(25));
                gc.fillRectangle(bounds.x + bounds.width - size.width - 3, bounds.y, size.width + 6, bounds.height);
            }
            gc.drawImage(image, bounds.x + bounds.width - size.width, bounds.y + (bounds.height - size.height) / 2);
            bounds.width -= size.width + 3;
            --i;
        }
        if (overdraw) {
            gc.setBackground(gc.getDevice().getSystemColor(26));
            gc.fillRectangle(bounds.x + bounds.width - 1, bounds.y, 1, bounds.height);
            item.width -= client.width - bounds.width;
        }
    }

    private void drawObjectDescription(@NotNull GC gc, @NotNull DBNDatabaseNode node, @NotNull Rectangle bounds) {
        String description;
        DBSObject object = node.getObject();
        if (object != null && !CommonUtils.isEmptyTrimmed((String)(description = object.getDescription()))) {
            this.drawText(gc, CommonUtils.getSingleLineString((String)description), bounds);
        }
    }

    private void drawObjectChildrenCounter(@NotNull GC gc, @NotNull DBNDatabaseNode node, @NotNull Rectangle bounds) {
        int childCount = 0;
        try {
            DBNDatabaseNode[] nodeChildren = node.getChildren((DBRProgressMonitor)new LocalCacheProgressMonitor((DBRProgressMonitor)new VoidProgressMonitor()));
            childCount = nodeChildren == null ? 0 : nodeChildren.length;
        }
        catch (DBException dBException) {
            return;
        }
        String text = "(" + childCount + ")";
        this.drawText(gc, text, bounds);
    }

    private void drawObjectStatistics(@NotNull GC gc, @NotNull DBNDatabaseNode node, @NotNull Rectangle bounds, @NotNull Event event) {
        int percentFull;
        String text;
        if (bounds.width < 50) {
            return;
        }
        ObjectStatistics statistics = this.getObjectStatistics(node, event);
        if (statistics == null) {
            return;
        }
        if (statistics instanceof ObjectStatistics.Known) {
            ObjectStatistics.Known known = (ObjectStatistics.Known)statistics;
            text = known.format.format(known.statObjectSize);
            percentFull = known.maxObjectSize == 0L ? 0 : (int)(known.statObjectSize * 100L / known.maxObjectSize);
        } else {
            text = "...";
            percentFull = 0;
        }
        Point textSize = gc.textExtent(text);
        Tree tree = (Tree)event.widget;
        gc.setForeground(NavigatorThemeSettings.instance.statisticsFrameColor);
        gc.drawRectangle(bounds.x + bounds.width - 50, bounds.y + 1, 50, bounds.height - 3);
        int width = Math.max((int)Math.ceil((double)(47 * percentFull) / 100.0), 1);
        gc.setBackground(NavigatorThemeSettings.instance.statisticsFrameColor);
        gc.fillRectangle(bounds.x + bounds.width - 50 + 2, bounds.y + 3, width, bounds.height - 6);
        if (UIStyles.isDarkHighContrastTheme() && 50 - width < 25) {
            gc.setForeground(tree.getBackground());
        } else if (CommonUtils.isBitSet((int)event.detail, (int)2)) {
            gc.setForeground(UIStyles.getDefaultTextSelectionForeground());
        } else {
            gc.setForeground(tree.getForeground());
        }
        gc.setFont(tree.getFont());
        gc.drawText(text, bounds.x + bounds.width - textSize.x, bounds.y + (bounds.height - textSize.y) / 2, true);
        bounds.width -= 53;
    }

    private void drawText(@NotNull GC gc, @NotNull String text, @NotNull Rectangle bounds) {
        if (text.isEmpty()) {
            return;
        }
        bounds.x += 5;
        Color foreground = gc.getForeground();
        Font font = gc.getFont();
        try {
            gc.setForeground(NavigatorThemeSettings.instance.hintColor);
            gc.setFont(BaseThemeSettings.instance.treeAndTableFontItalic);
            StatisticsNavigatorNodeRenderer.drawTextClipped(gc, text, bounds);
        }
        finally {
            gc.setFont(font);
            gc.setForeground(foreground);
        }
    }

    private static void drawTextClipped(@NotNull GC gc, @NotNull String text, @NotNull Rectangle bounds) {
        Point extent = gc.textExtent(text);
        if (extent.x > bounds.width) {
            int low = 0;
            int high = text.length();
            String clipped = text;
            while (low <= high) {
                int mid = low + high >>> 1;
                clipped = text.substring(0, mid);
                int ext = gc.textExtent((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001..."}, (String)clipped))).x;
                if (ext < bounds.width) {
                    low = mid + 1;
                    continue;
                }
                if (ext <= bounds.width) break;
                high = mid - 1;
            }
            if (clipped.isEmpty()) {
                return;
            }
            StatisticsNavigatorNodeRenderer.drawTextSegment(gc, clipped, bounds);
            StatisticsNavigatorNodeRenderer.drawTextSegment(gc, "...", bounds);
        } else {
            StatisticsNavigatorNodeRenderer.drawTextSegment(gc, text, bounds);
        }
    }

    private static void drawTextSegment(@NotNull GC gc, @NotNull String text, @NotNull Rectangle bounds) {
        Point extent = gc.textExtent(text);
        gc.drawText(text, bounds.x, bounds.y + (bounds.height - extent.y) / 2, true);
        bounds.x += extent.x;
        bounds.width -= extent.x;
    }

    @NotNull
    private static Rectangle getClientArea(@NotNull Tree tree) {
        Rectangle client = tree.getClientArea();
        client.x += 3;
        client.width -= 6;
        return client;
    }

    @NotNull
    private static Rectangle getItemBounds(@NotNull Rectangle client, @NotNull TreeItem item) {
        Rectangle bounds = item.getBounds();
        return new Rectangle(client.x + bounds.x + bounds.width, bounds.y, client.width - bounds.x - bounds.width, bounds.height);
    }

    @Override
    @Nullable
    public String getToolTipText(@NotNull DBNNode node, @NotNull Tree tree, @NotNull Event event) {
        if (node instanceof DBNDatabaseNode) {
            INavigatorNodeActionHandler overActionButton;
            long statObjectSize;
            DBPObjectStatistics statistics;
            DBSObject object;
            DBNDatabaseNode dbNode = (DBNDatabaseNode)node;
            if (this.isOverObjectStatistics(dbNode, tree, event) && (object = dbNode.getObject()) instanceof DBPObjectStatistics && (statistics = (DBPObjectStatistics)object).hasStatistics() && (statObjectSize = statistics.getStatObjectSize()) > 0L) {
                String formattedSize;
                try {
                    DBDDataFormatterProfile profile = object.getDataSource().getContainer().getDataFormatterProfile();
                    DBDDataFormatter formatter = profile.createFormatter("number", null);
                    formattedSize = formatter.formatValue((Object)statObjectSize);
                }
                catch (Exception exception) {
                    formattedSize = String.valueOf(statObjectSize);
                }
                return NLS.bind((String)"Object size on disk: {0} bytes", (Object)formattedSize);
            }
            if (node instanceof DBNDataSource && (overActionButton = this.getActionButton(node, tree, event)) != null) {
                return overActionButton.getNodeActionToolTip(this.view, node);
            }
        }
        return null;
    }

    @Override
    public void performAction(DBNNode node, Tree tree, Event event, boolean defaultAction) {
        INavigatorNodeActionHandler overActionButton;
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.node.actions") && (overActionButton = this.getActionButton(node, tree, event)) != null) {
            overActionButton.handleNodeAction(this.view, node, event, defaultAction);
        }
    }

    @Override
    @Nullable
    public Cursor getCursor(@NotNull DBNNode node, @NotNull Tree tree, @NotNull Event event) {
        DBNDatabaseNode n;
        DBNDataSource n2;
        if (node instanceof DBNDataSource && this.isOverActionButton((DBNNode)(n2 = (DBNDataSource)node), tree, event)) {
            return tree.getDisplay().getSystemCursor(21);
        }
        if (node instanceof DBNDatabaseNode && this.isOverObjectStatistics(n = (DBNDatabaseNode)node, tree, event)) {
            return tree.getDisplay().getSystemCursor(4);
        }
        return null;
    }

    private boolean isOverActionButton(@NotNull DBNNode node, @NotNull Tree tree, @NotNull Event event) {
        return this.getActionButton(node, tree, event) != null;
    }

    @Nullable
    private INavigatorNodeActionHandler getActionButton(@NotNull DBNNode node, @NotNull Tree tree, @NotNull Event event) {
        if (!DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.node.actions")) {
            return null;
        }
        List<INavigatorNodeActionHandler> actions = NavigatorExtensionsRegistry.getInstance().getNodeActions(this.getView(), node);
        if (actions.isEmpty()) {
            return null;
        }
        TreeItem item = tree.getItem(new Point(event.x, event.y));
        if (item == null) {
            return null;
        }
        Rectangle bounds = item.getBounds();
        Rectangle client = StatisticsNavigatorNodeRenderer.getClientArea(tree);
        client.y = bounds.y;
        client.height = bounds.height;
        int i = actions.size() - 1;
        while (i >= 0) {
            INavigatorNodeActionHandler action = actions.get(i);
            Image image = DBeaverIcons.getImage((DBPImage)action.getNodeActionIcon(this.getView(), node));
            Rectangle size = image.getBounds();
            if (client.width < size.width || event.y < client.y || event.y >= client.y + client.height) {
                return null;
            }
            if (event.x >= client.x + client.width - size.width && event.x < client.x + client.width) {
                return action;
            }
            client.width -= size.width + 3;
            --i;
        }
        return null;
    }

    private boolean isOverObjectStatistics(@NotNull DBNDatabaseNode node, @NotNull Tree tree, @NotNull Event event) {
        DBPObjectStatistics statistics;
        if (!DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.statistics.info")) {
            return false;
        }
        DBSObject dBSObject = node.getObject();
        if (!(dBSObject instanceof DBPObjectStatistics) || !(statistics = (DBPObjectStatistics)dBSObject).hasStatistics() || statistics.getStatObjectSize() <= 0L) {
            return false;
        }
        TreeItem treeItem = tree.getItem(new Point(event.x, event.y));
        if (treeItem == null) {
            return false;
        }
        Rectangle client = StatisticsNavigatorNodeRenderer.getClientArea(tree);
        Rectangle item = StatisticsNavigatorNodeRenderer.getItemBounds(client, treeItem);
        return event.x < item.x + item.width && event.x >= item.x + item.width - 50 && item.width >= 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    private ObjectStatistics getObjectStatistics(@NotNull DBNDatabaseNode node, @NotNull Event event) {
        long maxObjectSize;
        DBSObject dBSObject;
        DBSObject object = node.getObject();
        if (!(object instanceof DBPObjectStatistics)) {
            return null;
        }
        DBPObjectStatistics dBPObjectStatistics = (DBPObjectStatistics)object;
        DBNNode parentNode = this.getParentItem(node);
        if (parentNode instanceof DBNDatabaseNode) {
            DBNDatabaseNode pn = (DBNDatabaseNode)parentNode;
            dBSObject = DBUtils.getPublicObject((DBSObject)pn.getObject());
        } else {
            dBSObject = null;
        }
        DBSObject parentObject = dBSObject;
        boolean statsWasRead = parentObject instanceof DBPObjectStatisticsCollector ? ((DBPObjectStatisticsCollector)parentObject).isStatisticsCollected() : true;
        long l = maxObjectSize = statsWasRead ? this.getMaxObjectSize((TreeItem)event.item) : -1L;
        if (statsWasRead && maxObjectSize >= 0L) {
            Format format;
            void statistics;
            long statObjectSize = statistics.getStatObjectSize();
            if (statObjectSize <= 0L) {
                return null;
            }
            Map<String, Format> map = this.classFormatMap;
            synchronized (map) {
                format = this.classFormatMap.get(object.getClass().getName());
                if (format == null) {
                    try {
                        Class formatterClass;
                        Method getStatObjectSizeMethod = object.getClass().getMethod("getStatObjectSize", new Class[0]);
                        Property propAnnotation = getStatObjectSizeMethod.getAnnotation(Property.class);
                        if (propAnnotation != null && (formatterClass = propAnnotation.formatter()) != Format.class) {
                            format = (Format)formatterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                    if (format == null) {
                        format = numberFormat;
                    }
                    this.classFormatMap.put(object.getClass().getName(), format);
                }
            }
            return new ObjectStatistics.Known(statObjectSize, maxObjectSize, format);
        }
        if (parentNode instanceof DBNDatabaseNode) {
            DBSObject realParentObject = DBUtils.getPublicObject((DBSObject)((DBNDatabaseNode)parentNode).getObject());
            TreeItem parentItem = ((TreeItem)event.item).getParentItem();
            this.getObjectStatistics(node.getParentNode(), realParentObject, parentItem);
        }
        return new ObjectStatistics.Unknown();
    }

    private DBNNode getParentItem(DBNDatabaseNode element) {
        DBNNode parentNode = element.getParentNode();
        while (parentNode instanceof DBNDatabaseFolder) {
            parentNode = parentNode.getParentNode();
        }
        return parentNode;
    }

    private long getMaxObjectSize(TreeItem item) {
        Object maxSize;
        TreeItem parentItem = item.getParentItem();
        if (parentItem != null && (maxSize = parentItem.getData("nav.stat.maxSize")) instanceof Number) {
            return ((Number)maxSize).longValue();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getObjectStatistics(DBNNode parentNode, DBSObject parentObject, TreeItem parentItem) {
        Map<DBSObject, StatReadJob> map = statReaders;
        synchronized (map) {
            StatReadJob statReadJob = statReaders.get(parentObject);
            if (statReadJob == null) {
                statReadJob = new StatReadJob(parentNode, parentObject, parentItem);
                statReaders.put(parentObject, statReadJob);
                statReadJob.schedule();
            }
        }
    }

    private static sealed interface ObjectStatistics {

        public record Known(long statObjectSize, long maxObjectSize, @NotNull Format format) implements ObjectStatistics
        {
        }

        public record Unknown() implements ObjectStatistics
        {
        }
    }

    private static class StatReadJob
    extends AbstractJob {
        private final DBNNode parentNode;
        private final DBSObject object;
        private final TreeItem treeItem;

        StatReadJob(DBNNode parentNode, DBSObject object, TreeItem treeItem) {
            super("Read statistics for " + DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.UI));
            this.parentNode = parentNode;
            this.object = object;
            this.treeItem = treeItem;
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                try {
                    DBNDatabaseNode dbNode;
                    DBNDatabaseNode[] children;
                    monitor.beginTask("Collect database statistics", 1);
                    if (this.object instanceof DBPObjectStatisticsCollector) {
                        ((DBPObjectStatisticsCollector)this.object).collectObjectStatistics(monitor, false, false);
                    }
                    long maxStatSize = 0L;
                    DBNNode dBNNode = this.parentNode;
                    if (dBNNode instanceof DBNDatabaseNode && (children = (dbNode = (DBNDatabaseNode)dBNNode).getChildren(monitor)) != null) {
                        DBNDatabaseNode[] dBNDatabaseNodeArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DBNDatabaseNode childNode = dBNDatabaseNodeArray[n2];
                            DBSObject child = childNode.getObject();
                            if (child instanceof DBPObjectStatistics) {
                                long statObjectSize = ((DBPObjectStatistics)child).getStatObjectSize();
                                maxStatSize = Math.max(maxStatSize, statObjectSize);
                            }
                            ++n2;
                        }
                    }
                    long finalMaxStatSize = maxStatSize;
                    UIUtils.asyncExec(() -> {
                        try {
                            if (this.treeItem != null && !this.treeItem.isDisposed()) {
                                this.treeItem.getData("nav.stat.maxSize");
                                this.treeItem.setData("nav.stat.maxSize", (Object)finalMaxStatSize);
                                this.treeItem.getParent().redraw();
                            }
                        }
                        finally {
                            this.removeStatReader();
                        }
                    });
                }
                catch (DBException e) {
                    this.removeStatReader();
                    log.debug((Object)e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeStatReader() {
            Map<DBSObject, StatReadJob> map = statReaders;
            synchronized (map) {
                statReaders.remove(this.object);
            }
        }
    }
}

