/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data.hints.standard;

import java.util.EnumSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDResultSetModel;
import org.jkiss.dbeaver.model.data.DBDValueRow;
import org.jkiss.dbeaver.model.data.hints.DBDCellHintProvider;
import org.jkiss.dbeaver.model.data.hints.DBDValueHint;
import org.jkiss.dbeaver.model.data.hints.ValueHintText;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class BinaryCellHintProvider
implements DBDCellHintProvider {
    private static final Log log = Log.getLog(BinaryCellHintProvider.class);
    private final ByteNumberFormat LENGTH_FORMAT = new ByteNumberFormat();

    @Override
    @Nullable
    public DBDValueHint[] getCellHints(@NotNull DBDResultSetModel model, @NotNull DBDAttributeBinding attribute, @NotNull DBDValueRow row, @Nullable Object value, @NotNull EnumSet<DBDValueHint.HintType> types, int options) {
        if (types.contains((Object)DBDValueHint.HintType.STRING) && !DBUtils.isNullValue(value)) {
            DBDContent content;
            long contentLength = 0L;
            if (value instanceof DBDContent && !ContentUtils.isTextContent(content = (DBDContent)value)) {
                try {
                    contentLength = content.getContentLength();
                }
                catch (DBCException e) {
                    log.debug("Cannot read content length", e);
                }
            } else if (value instanceof CharSequence) {
                CharSequence chars = (CharSequence)value;
                contentLength = chars.length();
            } else if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                contentLength = bytes.length;
            }
            if (contentLength == 0L) {
                return null;
            }
            String formattedLength = this.LENGTH_FORMAT.format(contentLength);
            return new DBDValueHint[]{new ValueHintText((String)(!CommonUtils.isBitSet((int)options, (int)4) ? "[" + formattedLength + "]" : formattedLength), "Data length", null)};
        }
        return null;
    }
}

