/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDResultSetModel;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerConfigurable;
import org.jkiss.dbeaver.model.data.DBDValueRenderer;
import org.jkiss.dbeaver.model.data.DBDValueRow;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetTrace;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.exec.trace.DBCTrace;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.virtual.DBVColorOverride;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCellLocation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetHintContext;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ResultSetModel
implements DBDResultSetModel {
    private static final Log log = Log.getLog(ResultSetModel.class);
    private DBDAttributeBinding[] attributes = new DBDAttributeBinding[0];
    private List<DBDAttributeBinding> visibleAttributes = new ArrayList<DBDAttributeBinding>();
    private DBDAttributeBinding documentAttribute = null;
    private DBDDataFilter dataFilter;
    private DBSEntity singleSourceEntity;
    private DBCExecutionSource executionSource;
    private final ResultSetHintContext hintContext;
    private List<ResultSetRow> curRows = new ArrayList<ResultSetRow>();
    private Long totalRowCount = null;
    private int changesCount = 0;
    private volatile boolean hasData = false;
    private volatile DataSourceJob updateInProgress = null;
    private DBCStatistics statistics;
    private DBCTrace trace;
    private transient boolean metadataChanged;
    private transient boolean metadataDynamic;
    private final Comparator<DBDAttributeBinding> POSITION_SORTER = new Comparator<DBDAttributeBinding>(){

        @Override
        public int compare(DBDAttributeBinding o1, DBDAttributeBinding o2) {
            DBDAttributeConstraint c1 = ResultSetModel.this.dataFilter.getConstraint(o1);
            DBDAttributeConstraint c2 = ResultSetModel.this.dataFilter.getConstraint(o2);
            if (c1 == null) {
                log.debug((Object)("Missing constraint for " + String.valueOf(o1)));
                return -1;
            }
            if (c2 == null) {
                log.debug((Object)("Missing constraint for " + String.valueOf(o2)));
                return 1;
            }
            return c1.getVisualPosition() - c2.getVisualPosition();
        }
    };
    private final Map<DBDAttributeBinding, List<AttributeColorSettings>> colorMapping = new TreeMap<DBDAttributeBinding, List<AttributeColorSettings>>(this.POSITION_SORTER);

    public ResultSetModel() {
        this.hintContext = new ResultSetHintContext(this::getDataContainer, this::getSingleSource);
        this.dataFilter = this.createDataFilter();
    }

    public ResultSetHintContext getHintContext() {
        return this.hintContext;
    }

    public String getReadOnlyStatus(DBPDataSourceContainer dataSourceContainer) {
        if (this.isUpdateInProgress()) {
            return "Update in progress";
        }
        String containerReadOnlyStatus = DBExecUtils.getResultSetReadOnlyStatus((DBPDataSourceContainer)dataSourceContainer);
        if (containerReadOnlyStatus != null) {
            return containerReadOnlyStatus;
        }
        if (this.isUniqueKeyUndefinedButRequired(dataSourceContainer)) {
            return "No unique key defined";
        }
        return null;
    }

    public boolean isUniqueKeyUndefinedButRequired(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBPPreferenceStore store = dataSourceContainer.getPreferenceStore();
        if (store.getBoolean("resultset.edit.disableIfKeyMissing")) {
            DBDRowIdentifier identifier = this.getDefaultRowIdentifier();
            return identifier == null || !identifier.isValidIdentifier();
        }
        return false;
    }

    @NotNull
    public DBDDataFilter createDataFilter() {
        this.fillVisibleAttributes();
        ArrayList<DBDAttributeConstraint> constraints = new ArrayList<DBDAttributeConstraint>(this.attributes.length);
        DBDAttributeBinding[] dBDAttributeBindingArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
            this.addConstraints(constraints, binding);
            ++n2;
        }
        return new DBDDataFilter(constraints);
    }

    private void addConstraints(List<DBDAttributeConstraint> constraints, DBDAttributeBinding binding) {
        int constraintsSize = constraints.size();
        DBDAttributeConstraint constraint = new DBDAttributeConstraint(binding, constraintsSize, constraintsSize);
        constraint.setVisible(this.visibleAttributes.contains(binding) || binding.getParentObject() != null);
        constraints.add(constraint);
        List nestedBindings = binding.getNestedBindings();
        if (nestedBindings != null) {
            for (DBDAttributeBinding nested : nestedBindings) {
                this.addConstraints(constraints, nested);
            }
        }
    }

    public boolean isSingleSource() {
        return this.singleSourceEntity != null;
    }

    @Nullable
    public DBSEntity getSingleSource() {
        return this.singleSourceEntity;
    }

    public void refreshChangeCount() {
        this.changesCount = 0;
        for (ResultSetRow row : this.curRows) {
            if (row.getState() != 1) {
                ++this.changesCount;
                continue;
            }
            if (row.changes == null) continue;
            this.changesCount += row.changes.size();
        }
    }

    public DBDAttributeBinding getDocumentAttribute() {
        return this.documentAttribute;
    }

    @NotNull
    public DBDAttributeBinding[] getAttributes() {
        return this.attributes;
    }

    @NotNull
    public DBDAttributeBinding getAttribute(int index) {
        return this.attributes[index];
    }

    @NotNull
    public DBDAttributeBinding[] getRealAttributes() {
        ArrayList<DBDAttributeBinding> result = new ArrayList<DBDAttributeBinding>();
        DBDAttributeBinding[] dBDAttributeBindingArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
            if (!attr.isCustom()) {
                result.add(attr);
            }
            ++n2;
        }
        return result.toArray(new DBDAttributeBinding[0]);
    }

    @NotNull
    public List<DBDAttributeBinding> getVisibleAttributes() {
        return this.visibleAttributes;
    }

    public int getVisibleAttributeCount() {
        return this.visibleAttributes.size();
    }

    @Nullable
    public List<DBDAttributeBinding> getVisibleAttributes(DBDAttributeBinding parent) {
        List nestedBindings = parent.getNestedBindings();
        if (nestedBindings == null || nestedBindings.isEmpty()) {
            return null;
        }
        ArrayList<DBDAttributeBinding> result = new ArrayList<DBDAttributeBinding>(nestedBindings);
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            DBDAttributeConstraint constraint = this.dataFilter.getConstraint((DBDAttributeBinding)iter.next());
            if (constraint == null || constraint.isVisible()) continue;
            iter.remove();
        }
        return result;
    }

    @NotNull
    public DBDAttributeBinding getVisibleAttribute(int index) {
        return this.visibleAttributes.get(index);
    }

    @NotNull
    public List<DBDAttributeBinding> getVisibleLeafAttributes() {
        ArrayList<DBDAttributeBinding> children = new ArrayList<DBDAttributeBinding>();
        ArrayDeque<DBDAttributeBinding> parents = new ArrayDeque<DBDAttributeBinding>(this.getVisibleAttributes());
        while (!parents.isEmpty()) {
            DBDAttributeBinding attribute = (DBDAttributeBinding)parents.removeFirst();
            List<DBDAttributeBinding> nested = this.getVisibleAttributes(attribute);
            if (CommonUtils.isEmpty(nested)) {
                children.add(attribute);
                continue;
            }
            int i = nested.size() - 1;
            while (i >= 0) {
                parents.offerFirst(nested.get(i));
                --i;
            }
        }
        return children;
    }

    public void setAttributeVisibility(@NotNull DBDAttributeBinding attribute, boolean visible) {
        DBDAttributeConstraint constraint = this.dataFilter.getConstraint(attribute);
        if (constraint != null && constraint.isVisible() != visible) {
            constraint.setVisible(visible);
            if (attribute.getParentObject() == null || attribute.getParentObject() == this.documentAttribute) {
                if (visible) {
                    int position = Math.min(constraint.getVisualPosition(), this.visibleAttributes.size());
                    this.visibleAttributes.add(position, attribute);
                } else {
                    this.visibleAttributes.remove(attribute);
                }
            }
        }
    }

    @Nullable
    public DBDAttributeBinding getAttributeBinding(@Nullable DBSAttributeBase attribute) {
        return DBUtils.findBinding((DBDAttributeBinding[])this.attributes, (DBSAttributeBase)attribute);
    }

    @Nullable
    DBDAttributeBinding getAttributeBinding(@Nullable DBSEntity entity, @NotNull String attrName) {
        for (DBDAttributeBinding attribute : this.visibleAttributes) {
            DBDRowIdentifier rowIdentifier = attribute.getRowIdentifier();
            if (entity != null && (rowIdentifier == null || rowIdentifier.getEntity() != entity) || !attribute.getName().equals(attrName)) continue;
            return attribute;
        }
        return null;
    }

    @Nullable
    public DBDRowIdentifier getDefaultRowIdentifier() {
        DBDAttributeBinding[] dBDAttributeBindingArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding column = dBDAttributeBindingArray[n2];
            DBDRowIdentifier rowIdentifier = column.getRowIdentifier();
            if (rowIdentifier != null) {
                return rowIdentifier;
            }
            ++n2;
        }
        return null;
    }

    void refreshValueHandlersConfiguration() {
        DBDAttributeBinding[] dBDAttributeBindingArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBDValueRenderer valueRenderer;
            DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
            DBDValueHandler valueHandler = binding.getValueHandler();
            if (valueHandler instanceof DBDValueHandlerConfigurable) {
                DBDValueHandlerConfigurable vhc = (DBDValueHandlerConfigurable)valueHandler;
                vhc.refreshValueHandlerConfiguration((DBSTypedObject)binding);
            }
            if ((valueRenderer = binding.getValueRenderer()) != valueHandler && valueRenderer instanceof DBDValueHandlerConfigurable) {
                DBDValueHandlerConfigurable vhc = (DBDValueHandlerConfigurable)valueRenderer;
                vhc.refreshValueHandlerConfiguration((DBSTypedObject)binding);
            }
            ++n2;
        }
    }

    public DBVEntity getVirtualEntity(boolean create) {
        DBSEntity entity = this.isSingleSource() ? this.getSingleSource() : null;
        return this.getVirtualEntity(entity, create);
    }

    public DBVEntity getVirtualEntity(DBSEntity entity, boolean create) {
        if (entity != null) {
            return DBVUtils.getVirtualEntity((DBSEntity)entity, (boolean)true);
        }
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null) {
            return DBVUtils.getVirtualEntity((DBSDataContainer)dataContainer, (boolean)create);
        }
        return null;
    }

    @Nullable
    private DBSDataContainer getDataContainer() {
        return this.executionSource == null ? null : this.executionSource.getDataContainer();
    }

    public boolean isEmpty() {
        return this.getRowCount() <= 0 || this.visibleAttributes.size() <= 0;
    }

    public int getRowCount() {
        return this.curRows.size();
    }

    @NotNull
    public List<ResultSetRow> getAllRows() {
        return this.curRows;
    }

    @NotNull
    public Object[] getRowData(int index) {
        return this.curRows.get((int)index).values;
    }

    @NotNull
    public ResultSetRow getRow(int index) {
        return this.curRows.get(index);
    }

    public Long getTotalRowCount() {
        return this.totalRowCount;
    }

    void setTotalRowCount(Long totalRowCount) {
        this.totalRowCount = totalRowCount;
    }

    @Nullable
    public Object getCellValue(@NotNull ResultSetCellLocation cellLocation) {
        return this.getCellValue(cellLocation.getAttribute(), cellLocation.getRow(), cellLocation.getRowIndexes(), false);
    }

    @Nullable
    public Object getCellValue(@NotNull DBDAttributeBinding attribute, @NotNull ResultSetRow row) {
        return this.getCellValue(attribute, row, null, false);
    }

    @Nullable
    public Object getCellValue(@NotNull DBDAttributeBinding attribute, @NotNull DBDValueRow row, @Nullable int[] rowIndexes, boolean retrieveDeepestCollectionElement) {
        return DBUtils.getAttributeValue((DBDAttributeBinding)attribute, (DBDAttributeBinding[])this.attributes, (Object[])row.getValues(), (int[])rowIndexes, (boolean)retrieveDeepestCollectionElement);
    }

    boolean updateCellValue(@NotNull DBDAttributeBinding attr, @NotNull ResultSetRow row, @Nullable int[] rowIndexes, @Nullable Object value, boolean updateChanges) throws DBException {
        Object currentValue;
        int rootIndex;
        DBDAttributeBinding topAttribute;
        int depth = attr.getLevel();
        if (depth == 0) {
            topAttribute = attr;
            rootIndex = attr.getOrdinalPosition();
        } else {
            topAttribute = attr.getTopParent();
            rootIndex = topAttribute.getOrdinalPosition();
        }
        if (row.getState() != 1) {
            updateChanges = false;
        }
        if (updateChanges && row.changes == null) {
            row.changes = new HashMap<DBDAttributeBinding, Object>();
        }
        Object oldHistoricValue = updateChanges ? row.changes.get(topAttribute) : null;
        Object valueToEdit = currentValue = row.values[rootIndex];
        if (!attr.getDataKind().isComplex() && !(value instanceof DBDValue) && Objects.equals(CommonUtils.toString((Object)currentValue, null), CommonUtils.toString((Object)value, null))) {
            return false;
        }
        if (currentValue instanceof DBDValue) {
            if (updateChanges && oldHistoricValue == null) {
                if (currentValue instanceof DBDValueCloneable) {
                    DBDValueCloneable vc = (DBDValueCloneable)currentValue;
                    try {
                        valueToEdit = vc.cloneValue((DBRProgressMonitor)new VoidProgressMonitor());
                    }
                    catch (DBCException e) {
                        log.error((Object)"Error copying cell value", (Throwable)e);
                    }
                } else {
                    log.debug((Object)"Cannot copy complex value. Undo is not possible!");
                }
                row.changes.put(topAttribute, currentValue);
            }
        } else if (updateChanges && oldHistoricValue == null) {
            row.changes.put(topAttribute, currentValue);
        }
        if (updateChanges && attr != topAttribute) {
            row.changes.put(attr, topAttribute);
        }
        if (value instanceof DBDValue) {
            if (attr != topAttribute && valueToEdit instanceof DBDValue) {
                DBDValue ownerValue = (DBDValue)valueToEdit;
                DBUtils.updateAttributeValue((DBDValue)ownerValue, (DBDAttributeBinding)attr, (int[])rowIndexes, (Object)value);
            } else {
                valueToEdit = value;
            }
        } else if (valueToEdit instanceof DBDValue) {
            DBDValue complexValue = (DBDValue)valueToEdit;
            DBUtils.updateAttributeValue((DBDValue)complexValue, (DBDAttributeBinding)attr, (int[])rowIndexes, (Object)value);
        } else {
            valueToEdit = value;
        }
        row.values[rootIndex] = valueToEdit;
        if (updateChanges && row.getState() == 1) {
            ++this.changesCount;
        }
        return true;
    }

    void resetCellValue(@NotNull DBDAttributeBinding attr, @NotNull ResultSetRow row, @Nullable int[] rowIndexes) {
        if (row.getState() == 3) {
            row.setState((byte)1);
        } else if (row.changes != null && row.changes.containsKey(attr)) {
            DBUtils.resetValue((Object)this.getCellValue(attr, row, rowIndexes, false));
            try {
                Object origValue = row.changes.get(attr);
                if (origValue instanceof DBDAttributeBinding) {
                    DBDAttributeBinding refAttr = (DBDAttributeBinding)origValue;
                    Iterator<Map.Entry<DBDAttributeBinding, Object>> changedValues = row.changes.entrySet().iterator();
                    while (changedValues.hasNext()) {
                        if (changedValues.next().getValue() != origValue) continue;
                        changedValues.remove();
                    }
                    attr = refAttr;
                    origValue = row.changes.get(attr);
                    rowIndexes = null;
                }
                this.updateCellValue(attr, row, rowIndexes, origValue, false);
            }
            catch (DBException e) {
                log.error((Object)e);
            }
            row.resetChange(attr);
            if (row.getState() == 1) {
                --this.changesCount;
            }
        }
    }

    boolean isDynamicMetadata() {
        return this.metadataDynamic;
    }

    public boolean isMetadataChanged() {
        return this.metadataChanged;
    }

    public void setMetaData(@NotNull DBCResultSet resultSet, @NotNull DBDAttributeBinding[] newAttributes) {
        DBCStatement sourceStatement = resultSet.getSourceStatement();
        this.executionSource = sourceStatement != null ? sourceStatement.getStatementSource() : null;
        this.trace = resultSet instanceof DBCResultSetTrace ? ((DBCResultSetTrace)resultSet).getExecutionTrace() : null;
        this.clearData();
        this.updateMetaData(newAttributes);
    }

    void updateMetaData(@NotNull DBDAttributeBinding[] newAttributes) {
        boolean update = false;
        if (this.documentAttribute != null && newAttributes.length == 1 && newAttributes[0].getDataKind() == DBPDataKind.DOCUMENT && this.isSameSource(this.documentAttribute, newAttributes[0])) {
            update = false;
        } else if (this.attributes == null || this.attributes.length == 0 || this.attributes.length != newAttributes.length || this.isDynamicMetadata()) {
            update = true;
        } else {
            int i = 0;
            while (i < this.attributes.length) {
                DBCAttributeMetaData oldMeta = this.attributes[i].getMetaAttribute();
                DBCAttributeMetaData newMeta = newAttributes[i].getMetaAttribute();
                if (oldMeta == null && newMeta != null || oldMeta != null && newMeta == null) {
                    update = true;
                    break;
                }
                if (oldMeta != newMeta && !DBExecUtils.equalAttributes((DBCAttributeMetaData)oldMeta, (DBCAttributeMetaData)newMeta)) {
                    update = true;
                    break;
                }
                ++i;
            }
        }
        this.metadataChanged = update;
        if (update) {
            this.metadataChanged = ArrayUtils.isEmpty((Object[])this.attributes) || ArrayUtils.isEmpty((Object[])newAttributes) || !this.isDynamicMetadata() || this.attributes[0].getTopParent().getMetaAttribute() == null || newAttributes[0].getTopParent().getMetaAttribute() == null || this.attributes[0].getTopParent().getMetaAttribute().getSource() != newAttributes[0].getTopParent().getMetaAttribute().getSource();
        }
        this.attributes = newAttributes;
        this.documentAttribute = null;
        this.metadataDynamic = this.attributes.length > 0 && this.attributes[0].getTopParent().getDataSource().getInfo().isDynamicMetadata();
        DBDAttributeBinding realAttr = null;
        if (this.attributes.length == 1) {
            realAttr = this.attributes[0];
        } else {
            DBDAttributeBinding[] dBDAttributeBindingArray = this.attributes;
            int n = this.attributes.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
                if (!attr.isPseudoAttribute()) {
                    if (realAttr != null) {
                        realAttr = null;
                        break;
                    }
                    realAttr = attr;
                }
                ++n2;
            }
        }
        if (realAttr != null && (realAttr.getDataKind() == DBPDataKind.DOCUMENT || realAttr.getDataKind() == DBPDataKind.CONTENT)) {
            this.documentAttribute = realAttr;
        }
        if (this.metadataChanged) {
            this.hintContext.resetCache();
        }
    }

    private boolean isSameSource(DBDAttributeBinding attr1, DBDAttributeBinding attr2) {
        if (attr1.getMetaAttribute() == null || attr2.getMetaAttribute() == null) {
            return false;
        }
        DBCEntityMetaData ent1 = attr1.getMetaAttribute().getEntityMetaData();
        DBCEntityMetaData ent2 = attr2.getMetaAttribute().getEntityMetaData();
        if (ent1 == null || ent2 == null) {
            return false;
        }
        return CommonUtils.equalObjects((Object)ent1.getCatalogName(), (Object)ent2.getCatalogName()) && CommonUtils.equalObjects((Object)ent1.getSchemaName(), (Object)ent2.getSchemaName()) && CommonUtils.equalObjects((Object)ent1.getEntityName(), (Object)ent2.getEntityName());
    }

    void resetMetaData() {
        this.attributes = new DBDAttributeBinding[0];
        this.visibleAttributes.clear();
        this.documentAttribute = null;
        this.singleSourceEntity = null;
    }

    void updateDataFilter() {
        if (this.metadataChanged) {
            this.dataFilter = this.createDataFilter();
        } else {
            DBDDataFilter prevFilter = this.dataFilter;
            this.dataFilter = this.createDataFilter();
            this.updateDataFilter(prevFilter, false);
        }
    }

    public void setData(@NotNull DBRProgressMonitor monitor, @NotNull List<Object[]> rows) {
        DBSDataContainer dataContainer;
        DBDAttributeBinding topAttr;
        this.releaseAllData();
        this.clearData();
        boolean isDocumentBased = false;
        if (this.attributes.length == 1 && this.attributes[0].getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.transform.complex.type") && (topAttr = this.attributes[0]).getDataKind() == DBPDataKind.DOCUMENT) {
            isDocumentBased = true;
            List nested = topAttr.getNestedBindings();
            if (nested != null && !nested.isEmpty()) {
                this.attributes = nested.toArray(new DBDAttributeBinding[0]);
                this.fillVisibleAttributes();
            }
        }
        if (isDocumentBased && (dataContainer = this.getDataContainer()) instanceof DBSEntity) {
            this.singleSourceEntity = (DBSEntity)dataContainer;
        }
        this.updateDataFilter();
        if (this.singleSourceEntity == null) {
            this.singleSourceEntity = DBExecUtils.detectSingleSourceTable((DBDAttributeBinding[])this.visibleAttributes.toArray(new DBDAttributeBinding[0]));
        }
        this.updateColorMapping(false);
        this.appendData(monitor, rows, true);
        this.updateDataFilter();
        this.visibleAttributes.sort(this.POSITION_SORTER);
        this.hasData = true;
    }

    private void processColorOverrides(@NotNull DBVEntity virtualEntity) {
        List coList = virtualEntity.getColorOverrides();
        if (!CommonUtils.isEmpty((Collection)coList)) {
            for (DBVColorOverride co : coList) {
                DBDAttributeBinding binding = (DBDAttributeBinding)DBUtils.findObject((DBPNamedObject[])this.attributes, (String)co.getAttributeName());
                if (binding != null) {
                    List cmList = this.colorMapping.computeIfAbsent(binding, k -> new ArrayList());
                    cmList.add(new AttributeColorSettings(co));
                    continue;
                }
                log.debug((Object)("Attribute '" + co.getAttributeName() + "' not found in bindings. Skip colors."));
            }
        }
    }

    public void updateColorMapping(@NotNull DBVEntity virtualEntity, boolean reset) {
        this.colorMapping.clear();
        this.processColorOverrides(virtualEntity);
        if (reset) {
            this.updateRowColors(true, this.curRows);
        }
    }

    public void updateColorMapping(boolean reset) {
        this.colorMapping.clear();
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer == null) {
            return;
        }
        DBVEntity virtualEntity = DBVUtils.getVirtualEntity((DBSDataContainer)dataContainer, (boolean)false);
        if (virtualEntity == null) {
            return;
        }
        this.processColorOverrides(virtualEntity);
        if (reset) {
            this.updateRowColors(true, this.curRows);
        }
    }

    private void updateRowColors(boolean reset, List<ResultSetRow> rows) {
        if (this.colorMapping.isEmpty() || reset) {
            for (ResultSetRow resultSetRow : rows) {
                resultSetRow.colorInfo = null;
            }
        }
        if (!this.colorMapping.isEmpty()) {
            for (Map.Entry entry : this.colorMapping.entrySet()) {
                if (!ArrayUtils.contains((Object[])this.attributes, (Object)((DBDAttributeBinding)entry.getKey()))) continue;
                for (ResultSetRow row : rows) {
                    ResultSetCellLocation cellLocation = new ResultSetCellLocation((DBDAttributeBinding)entry.getKey(), row);
                    for (AttributeColorSettings acs : (List)entry.getValue()) {
                        Color background = null;
                        Color foreground = null;
                        if (acs.rangeCheck) {
                            if (acs.attributeValues != null && acs.attributeValues.length > 1) {
                                double minValue = DBExecUtils.makeNumericValue((Object)acs.attributeValues[0]);
                                double maxValue = DBExecUtils.makeNumericValue((Object)acs.attributeValues[1]);
                                Object cellValue = this.getCellValue(cellLocation);
                                double value = DBExecUtils.makeNumericValue((Object)cellValue);
                                if (value >= minValue && value <= maxValue) {
                                    if (acs.colorBackground != null && acs.colorBackground2 != null && value >= minValue && value <= maxValue) {
                                        RGB bgRowRGB = ResultSetUtils.makeGradientValue(acs.colorBackground.getRGB(), acs.colorBackground2.getRGB(), minValue, maxValue, value);
                                        background = UIUtils.getSharedColor((RGB)bgRowRGB);
                                    }
                                    if (acs.colorForeground != null && acs.colorForeground2 != null) {
                                        RGB fgRowRGB1 = ResultSetUtils.makeGradientValue(acs.colorForeground.getRGB(), acs.colorForeground2.getRGB(), minValue, maxValue, value);
                                        foreground = UIUtils.getSharedColor((RGB)fgRowRGB1);
                                    } else if (acs.colorForeground != null || acs.colorForeground2 != null) {
                                        foreground = acs.colorForeground != null ? acs.colorForeground : acs.colorForeground2;
                                    }
                                }
                            }
                        } else {
                            Object cellValue = this.getCellValue(cellLocation);
                            if (acs.evaluate(cellValue)) {
                                foreground = acs.colorForeground;
                                background = acs.colorBackground;
                            }
                        }
                        if (foreground == null && background == null) continue;
                        ResultSetRow.ColorInfo colorInfo = row.colorInfo;
                        if (colorInfo == null) {
                            row.colorInfo = colorInfo = new ResultSetRow.ColorInfo();
                        }
                        if (!acs.singleColumn) {
                            colorInfo.rowForeground = foreground;
                            colorInfo.rowBackground = background;
                            continue;
                        }
                        if (foreground != null) {
                            Color[] cellFgColors = colorInfo.cellFgColors;
                            if (cellFgColors == null) {
                                colorInfo.cellFgColors = cellFgColors = new Color[this.attributes.length];
                            }
                            cellFgColors[((DBDAttributeBinding)entry.getKey()).getOrdinalPosition()] = foreground;
                        }
                        if (background == null) continue;
                        Color[] cellBgColors = colorInfo.cellBgColors;
                        if (cellBgColors == null) {
                            colorInfo.cellBgColors = cellBgColors = new Color[this.attributes.length];
                        }
                        cellBgColors[((DBDAttributeBinding)entry.getKey()).getOrdinalPosition()] = background;
                    }
                }
            }
        }
    }

    void appendData(@NotNull DBRProgressMonitor monitor, @NotNull List<Object[]> rows, boolean resetOldRows) {
        if (resetOldRows) {
            this.curRows.clear();
        }
        int rowCount = rows.size();
        int firstRowNum = this.curRows.size();
        ArrayList<ResultSetRow> newRows = new ArrayList<ResultSetRow>(rowCount);
        int i = 0;
        while (i < rowCount) {
            newRows.add(new ResultSetRow(firstRowNum + i, rows.get(i)));
            ++i;
        }
        this.curRows.addAll(newRows);
        this.updateRowColors(resetOldRows, newRows);
        this.refreshHintsInfo(monitor, newRows, resetOldRows);
    }

    void refreshHintsInfo(@NotNull DBRProgressMonitor monitor, List<? extends DBDValueRow> newRows, boolean cleanupOldCache) {
        try {
            if (cleanupOldCache) {
                this.hintContext.resetCache();
                this.hintContext.initProviders(this.attributes);
            }
            this.hintContext.cacheRequiredData(monitor, null, newRows, cleanupOldCache);
        }
        catch (Exception e) {
            log.debug((Object)"Error caching data for column hints", (Throwable)e);
        }
    }

    void clearData() {
        this.curRows = new ArrayList<ResultSetRow>();
        this.totalRowCount = null;
        this.singleSourceEntity = null;
        this.hasData = false;
    }

    public boolean hasData() {
        return this.hasData;
    }

    public boolean isDirty() {
        return this.changesCount != 0;
    }

    public boolean isUpdateInProgress() {
        return this.updateInProgress != null;
    }

    public DataSourceJob getUpdateJob() {
        return this.updateInProgress;
    }

    void setUpdateInProgress(DataSourceJob updateService) {
        this.updateInProgress = updateService;
    }

    @NotNull
    ResultSetRow addNewRow(int rowNum, @NotNull Object[] data) {
        ResultSetRow newRow = new ResultSetRow(this.curRows.size(), data);
        newRow.setVisualNumber(rowNum);
        newRow.setState((byte)2);
        this.shiftRows(newRow, 1);
        this.curRows.add(rowNum, newRow);
        ++this.changesCount;
        return newRow;
    }

    boolean deleteRow(@NotNull ResultSetRow row) {
        if (row.getState() == 2) {
            this.cleanupRow(row);
            return true;
        }
        row.setState((byte)3);
        ++this.changesCount;
        return false;
    }

    void cleanupRow(@NotNull ResultSetRow row) {
        row.release();
        int index = row.getVisualNumber();
        if (this.curRows.size() > index) {
            this.curRows.remove(index);
            this.shiftRows(row, -1);
        } else {
            log.debug((Object)("Error removing row from list: invalid row index: " + index));
        }
    }

    boolean cleanupRows(Collection<ResultSetRow> rows) {
        if (rows != null && !rows.isEmpty()) {
            ArrayList<ResultSetRow> rowsToRemove = new ArrayList<ResultSetRow>(rows);
            rowsToRemove.sort(Comparator.comparingInt(ResultSetRow::getVisualNumber));
            for (ResultSetRow row : rowsToRemove) {
                this.cleanupRow(row);
            }
            return true;
        }
        return false;
    }

    private void shiftRows(@NotNull ResultSetRow relative, int delta) {
        for (ResultSetRow row : this.curRows) {
            if (row.getVisualNumber() >= relative.getVisualNumber()) {
                row.setVisualNumber(row.getVisualNumber() + delta);
            }
            if (row.getRowNumber() < relative.getRowNumber()) continue;
            row.setRowNumber(row.getRowNumber() + delta);
        }
    }

    void releaseAllData() {
        List<ResultSetRow> oldRows = this.curRows;
        RuntimeUtils.runTask(monitor -> {
            for (ResultSetRow row : oldRows) {
                row.release();
            }
        }, (String)"Release values", (long)5000L);
    }

    public DBDDataFilter getDataFilter() {
        return this.dataFilter;
    }

    boolean setDataFilter(DBDDataFilter dataFilter) {
        this.dataFilter = dataFilter;
        ArrayList<DBDAttributeConstraint> newConstraints = new ArrayList<DBDAttributeConstraint>();
        DBDAttributeBinding[] dBDAttributeBindingArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
            if (dataFilter.getConstraint(binding) == null) {
                this.addConstraints(newConstraints, binding);
            }
            ++n2;
        }
        if (!newConstraints.isEmpty()) {
            dataFilter.addConstraints(newConstraints);
        }
        ArrayList<DBDAttributeBinding> newBindings = new ArrayList<DBDAttributeBinding>();
        for (DBSAttributeBase attr : this.dataFilter.getOrderedVisibleAttributes()) {
            DBDAttributeBinding binding = this.getAttributeBinding(attr);
            if (binding == null || binding.getParentObject() != null && binding.getParentObject() != this.documentAttribute) continue;
            newBindings.add(binding);
        }
        if (!newBindings.isEmpty() && !newBindings.equals(this.visibleAttributes)) {
            this.visibleAttributes = newBindings;
            this.updateColorMapping(true);
            return true;
        }
        return false;
    }

    void updateDataFilter(DBDDataFilter filter, boolean forceUpdate) {
        this.visibleAttributes.clear();
        Collections.addAll(this.visibleAttributes, this.attributes);
        ArrayList<DBDAttributeConstraint> missingConstraints = new ArrayList<DBDAttributeConstraint>();
        for (DBDAttributeConstraint constraint : filter.getConstraints()) {
            DBDAttributeBinding attribute;
            DBDAttributeConstraint filterConstraint = this.dataFilter.getConstraint(constraint.getAttribute(), true);
            if (filterConstraint == null) {
                if (constraint.getOperator() == null) continue;
                missingConstraints.add(constraint);
                continue;
            }
            if (!forceUpdate && constraint.getVisualPosition() != DBDAttributeConstraint.NULL_VISUAL_POSITION && constraint.getVisualPosition() != filterConstraint.getVisualPosition() && constraint.getVisualPosition() == constraint.getOriginalVisualPosition()) continue;
            if (constraint.getOperator() != null) {
                filterConstraint.setOperator(constraint.getOperator());
                filterConstraint.setReverseOperator(constraint.isReverseOperator());
                filterConstraint.setValue(constraint.getValue());
            } else {
                filterConstraint.setCriteria(constraint.getCriteria());
            }
            filterConstraint.setOrderPosition(constraint.getOrderPosition());
            filterConstraint.setOrderDescending(constraint.isOrderDescending());
            filterConstraint.setVisible(constraint.isVisible());
            if (constraint.getVisualPosition() != DBDAttributeConstraint.NULL_VISUAL_POSITION) {
                filterConstraint.setVisualPosition(constraint.getVisualPosition());
            }
            filterConstraint.setOptions(constraint.getOptions());
            DBSAttributeBase cAttr = filterConstraint.getAttribute();
            if (!(cAttr instanceof DBDAttributeBinding)) continue;
            if (!constraint.isVisible()) {
                this.visibleAttributes.remove(cAttr);
                continue;
            }
            if (this.visibleAttributes.contains(cAttr) || (attribute = (DBDAttributeBinding)cAttr).getParentObject() != null && attribute.getParentObject() != this.documentAttribute) continue;
            this.visibleAttributes.add(attribute);
        }
        if (!missingConstraints.isEmpty()) {
            this.dataFilter.addConstraints(missingConstraints);
        }
        if (filter.getConstraints().size() != this.attributes.length) {
            Iterator<DBDAttributeBinding> iter = this.visibleAttributes.iterator();
            while (iter.hasNext()) {
                DBDAttributeBinding attr = iter.next();
                if (filter.getConstraint((DBSAttributeBase)attr, true) != null || DBDAttributeConstraint.isVisibleByDefault((DBDAttributeBinding)attr)) continue;
                iter.remove();
            }
        }
        this.visibleAttributes.sort(this.POSITION_SORTER);
        this.dataFilter.setWhere(filter.getWhere());
        this.dataFilter.setOrder(filter.getOrder());
        this.dataFilter.setAnyConstraint(filter.isAnyConstraint());
        this.updateColorMapping(true);
    }

    public void resetOrdering(@NotNull Collection<? extends DBDAttributeBinding> bindings) {
        for (DBDAttributeBinding dBDAttributeBinding : bindings) {
            this.resetOrdering(dBDAttributeBinding);
        }
    }

    public void resetOrdering(@NotNull DBDAttributeBinding columnElement) {
        boolean hasOrdering = this.dataFilter.hasOrdering();
        this.curRows.sort(Comparator.comparingInt(ResultSetRow::getRowNumber));
        if (hasOrdering) {
            List orderConstraints = this.dataFilter.getOrderConstraints();
            this.curRows.sort((row1, row2) -> {
                int result = 0;
                for (DBDAttributeConstraint co : orderConstraints) {
                    DBDAttributeBinding binding = this.getAttributeBinding(co.getAttribute());
                    if (binding == null) continue;
                    Object cell1 = this.getCellValue(new ResultSetCellLocation(binding, (ResultSetRow)row1));
                    Object cell2 = this.getCellValue(new ResultSetCellLocation(binding, (ResultSetRow)row2));
                    Comparator comparator = columnElement.getValueHandler().getComparator();
                    result = comparator != null ? comparator.compare(cell1, cell2) : (cell1 instanceof String && cell2 instanceof String ? cell1.toString().compareToIgnoreCase(cell2.toString()) : DBUtils.compareDataValues((Object)cell1, (Object)cell2));
                    if (co.isOrderDescending()) {
                        result = -result;
                    }
                    if (result != 0) break;
                }
                return result;
            });
        }
        int i = 0;
        while (i < this.curRows.size()) {
            this.curRows.get(i).setVisualNumber(i);
            ++i;
        }
    }

    private void fillVisibleAttributes() {
        DBSEntityAttribute entityAttribute;
        DBSEntity entity;
        DBPDataSourceContainer container;
        this.visibleAttributes.clear();
        boolean entityDataView = this.executionSource != null && this.executionSource.getDataContainer() instanceof DBSEntity;
        DBSObjectFilter columnFilter = null;
        if (entityDataView && (container = (entity = (DBSEntity)this.executionSource.getDataContainer()).getDataSource().getContainer()).getPreferenceStore().getBoolean("resultset.filter.use.navigator") && this.attributes.length > 0 && (entityAttribute = this.attributes[0].getEntityAttribute()) != null) {
            columnFilter = container.getObjectFilter(entityAttribute.getClass(), (DBSObject)entity, false);
        }
        DBDAttributeBinding[] dBDAttributeBindingArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
            if (!(entityDataView && !DBDAttributeConstraint.isVisibleByDefault((DBDAttributeBinding)binding) || columnFilter != null && !columnFilter.matches(binding.getName()))) {
                this.visibleAttributes.add(binding);
            }
            ++n2;
        }
    }

    public DBCStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(DBCStatistics statistics) {
        this.statistics = statistics;
    }

    public DBCTrace getTrace() {
        return this.trace;
    }

    public static class AttributeColorSettings {
        private final DBCLogicalOperator operator;
        private final boolean rangeCheck;
        private final boolean singleColumn;
        private final Object[] attributeValues;
        private final Color colorForeground;
        private final Color colorForeground2;
        private final Color colorBackground;
        private final Color colorBackground2;

        AttributeColorSettings(DBVColorOverride co) {
            this.operator = co.getOperator();
            this.rangeCheck = co.isRange();
            this.singleColumn = co.isSingleColumn();
            this.colorForeground = AttributeColorSettings.getColor(co.getColorForeground());
            this.colorForeground2 = AttributeColorSettings.getColor(co.getColorForeground2());
            this.colorBackground = AttributeColorSettings.getColor(co.getColorBackground());
            this.colorBackground2 = AttributeColorSettings.getColor(co.getColorBackground2());
            this.attributeValues = co.getAttributeValues();
        }

        private static Color getColor(String color) {
            if (CommonUtils.isEmpty((String)color)) {
                return null;
            }
            return UIUtils.getSharedColor((String)color);
        }

        public boolean evaluate(Object cellValue) {
            return this.operator.evaluate(cellValue, this.attributeValues);
        }
    }
}

