/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.propagation;

import io.jaegertracing.internal.JaegerSpanContext;
import io.jaegertracing.spi.Codec;
import java.util.LinkedList;
import java.util.List;

public class CompositeCodec<T>
implements Codec<T> {
    private final List<Codec<T>> codecs;

    public CompositeCodec(List<Codec<T>> codecs) {
        this.codecs = new LinkedList<Codec<T>>(codecs);
    }

    @Override
    public void inject(JaegerSpanContext spanContext, T carrier) {
        for (Codec<T> codec : this.codecs) {
            codec.inject(spanContext, carrier);
        }
    }

    @Override
    public JaegerSpanContext extract(T carrier) {
        for (Codec<T> codec : this.codecs) {
            JaegerSpanContext context = codec.extract(carrier);
            if (context == null) continue;
            return context;
        }
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Codec<T> codec : this.codecs) {
            if (buffer.length() > 0) {
                buffer.append(" : ");
            }
            buffer.append(codec.toString());
        }
        return buffer.toString();
    }
}

