def submit_benchmark(benchmark_data: dict):
    """Submit benchmark data to MyData.

    Authenticates the user via the web browser and Blender ID if necessary.
    Authentication tokens are stored on disk and validated before reusing.
    """

    import logging
    import os

    from .client import CommunicationError, BenchmarkClient

    mydata_url = os.environ.get('MYDATA') or 'https://mydata.blender.org/'
    if 'MYDATA' in os.environ:
        # Assume we're debugging here.
        logging.basicConfig(level=logging.DEBUG,
                            format='%(asctime)-15s %(levelname)8s %(name)s %(message)s')

    bc = BenchmarkClient(mydata_url)

    # Make sure we have a token; can start the browser to get one.
    token = bc.load_auth_token()
    result = bc.submit_benchmark(benchmark_data)
    print(result)

    # If we get a location from the MyData server, show it in a browser.
    if result.location:
        import webbrowser
        webbrowser.open_new_tab(result.location)
