## -----------------------------------------------------------------------------
library(GTRT)

## ----eval=FALSE---------------------------------------------------------------
# s <- runif(10,0,1) # Starting points of 10 interval
# t <- runif(10,0,1) # End points of intervals
# e1 <- c(2,10,6,1,5) # Indices for the first interval in 5 pairs formed unsing above 10 intervals.
# e2 <- c(4,3,8,7,9) # Indices for the second interval in 5 pairs formed unsing above 10 intervals.
# nip.rig(s,t,e1,e2)

## -----------------------------------------------------------------------------
y <- arima.sim(model = list(ar=0.9), 1000) ## AR(1) model
rigep.test(y,0.05)

## ----eval=FALSE---------------------------------------------------------------
# cdf.rig(1000)

## ----eval=FALSE---------------------------------------------------------------
# y <- arima.sim(model = list(ar=0.7), 1000) ## AR(1) model
# deg.rig(y)

## -----------------------------------------------------------------------------
y <- arima.sim(model = list(ar=c(0.7,0.2)), 1000) ## AR(2) model
rigdd.test(y)

## ----eval=FALSE---------------------------------------------------------------
# thrsd.rigdd(500,1000,0.05)

## -----------------------------------------------------------------------------
library(timeSeriesDataSets)
data(elecdaily_mts)
x <- elecdaily_mts[,1]
rigep.test(x,0.05)

## -----------------------------------------------------------------------------
rigdd.test(x)

## -----------------------------------------------------------------------------
thrsd.rigdd(length(x),500,c(0.05,0.01))

