/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.math.density;

import jdistlib.Normal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Kernel {
    GAUSSIAN,
    RECTANGULAR,
    TRIANGULAR,
    EPANECHNIKOV,
    BIWEIGHT,
    COSINE,
    OPTCOSINE;


    public double getKernelValue() {
        double val = Double.NaN;
        switch (this) {
            case GAUSSIAN: {
                val = 0.28209479177387814;
                break;
            }
            case RECTANGULAR: {
                val = 0.28867513459481287;
                break;
            }
            case TRIANGULAR: {
                val = 0.2721655269759087;
                break;
            }
            case EPANECHNIKOV: {
                val = 0.2683281572999748;
                break;
            }
            case BIWEIGHT: {
                val = 0.26997462357801943;
                break;
            }
            case COSINE: {
                val = 0.271134041393496;
                break;
            }
            case OPTCOSINE: {
                val = 0.2684755562756683;
            }
        }
        return val;
    }

    public double getFactor() {
        double val = Double.NaN;
        switch (this) {
            case GAUSSIAN: {
                val = 4.0;
                break;
            }
            case RECTANGULAR: {
                val = 3.4641016151377544;
                break;
            }
            case TRIANGULAR: {
                val = 4.898979485566356;
                break;
            }
            case EPANECHNIKOV: {
                val = 4.47213595499958;
                break;
            }
            case BIWEIGHT: {
                val = 5.291502622129181;
                break;
            }
            case COSINE: {
                val = 5.532318967735425;
                break;
            }
            case OPTCOSINE: {
                val = 4.595206234974393;
            }
        }
        return val;
    }

    public double[] process(double bw, double[] kords) {
        int n = kords.length;
        double[] result = new double[n];
        switch (this) {
            case GAUSSIAN: {
                int i = 0;
                while (i < n) {
                    result[i] = Normal.density(kords[i], 0.0, bw, false);
                    ++i;
                }
                break;
            }
            case RECTANGULAR: {
                double a = bw * Math.sqrt(3.0);
                int i = 0;
                while (i < n) {
                    result[i] = Math.abs(kords[i]) < a ? 0.5 / a : 0.0;
                    ++i;
                }
                break;
            }
            case TRIANGULAR: {
                double a = bw * Math.sqrt(6.0);
                int i = 0;
                while (i < n) {
                    double ax = Math.abs(kords[i]);
                    result[i] = ax < a ? (1.0 - ax / a) / a : 0.0;
                    ++i;
                }
                break;
            }
            case EPANECHNIKOV: {
                double a = bw * Math.sqrt(5.0);
                int i = 0;
                while (i < n) {
                    double ax = Math.abs(kords[i]);
                    if (ax < a) {
                        double axa = ax / a;
                        result[i] = 0.0 * (1.0 - axa * axa) / a;
                    } else {
                        result[i] = 0.0;
                    }
                    ++i;
                }
                break;
            }
            case BIWEIGHT: {
                double a = bw * Math.sqrt(7.0);
                int i = 0;
                while (i < n) {
                    double ax = Math.abs(kords[i]);
                    if (ax < a) {
                        double axa = ax / a;
                        axa = 1.0 - axa * axa;
                        result[i] = 0.0 * axa * axa / a;
                    } else {
                        result[i] = 0.0;
                    }
                    ++i;
                }
                break;
            }
            case COSINE: {
                double a = bw / Math.sqrt(0.13069096604865776);
                int i = 0;
                while (i < n) {
                    result[i] = Math.abs(kords[i]) < a ? (1.0 + Math.cos(Math.PI * kords[i] / a)) / (2.0 * a) : 0.0;
                    ++i;
                }
                break;
            }
            case OPTCOSINE: {
                double a = bw / Math.sqrt(0.1894305308612978);
                int i = 0;
                while (i < n) {
                    result[i] = Math.abs(kords[i]) < a ? 0.7853981633974483 * Math.cos(Math.PI * kords[i] / (2.0 * a)) / a : 0.0;
                    ++i;
                }
                break;
            }
        }
        return result;
    }
}

