## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(saeHB.twofold)
data("dataTwofold")

## -----------------------------------------------------------------------------
model=NormalTF(y~x1+x2,vardir="vardir",area = "codearea",weight = "w",iter.mcmc = 100000,thin=50,burn.in = 1000,data=dataTwofold)

## -----------------------------------------------------------------------------
model$Est_sub

## -----------------------------------------------------------------------------
model$Est_area

## -----------------------------------------------------------------------------
model$coefficient

## -----------------------------------------------------------------------------
model$refVar

## -----------------------------------------------------------------------------
CV=(model$Est_sub$SD)/(model$Est_sub$Mean)*100
MSE=model$Est_sub$SD^2
summary(cbind(CV,MSE))

## -----------------------------------------------------------------------------
CV2=(model$Est_area$SD)/(model$Est_area$Mean)*100
MSE2=model$Est_area$SD^2
summary(cbind(CV2,MSE2))

## -----------------------------------------------------------------------------
dirCV=sqrt(dataTwofold$vardir)/(dataTwofold$y)*100
summary(cbind(dirCV,CV))

## -----------------------------------------------------------------------------
boxplot(cbind(dirCV,CV),ylim=c(0,50))

## -----------------------------------------------------------------------------
model$refVar

## -----------------------------------------------------------------------------
model$plot

