# timeperiodsR 0.7.3
* Исправлена ссылка в README файле.

# timeperiodsR 0.7.2
* Исправление документации по требованиям CRAN. исправил файл `timeperiodsR-package.Rd`.

# timeperiodsR 0.7.1
* Исправил ссылки в README и DESCRIPTION

# timeperiodsR 0.7.0
* Незначительное испрвление ошибок
* Вместо `class(y) == "tpr"` теперь везде используется функция `inherits()`.

# timeperiodsR 0.6.2
Дата: 2023-04-11
* Незначительные дработаки обработки ответа от isDayOff API, согласно политике CRAN.

# timeperiodsR 0.6.1
Дата: 2020-01-08

1. Добавлен метод `custom_day_offs()` позволяющий проверить какие даты из периода в объекте класса *tpr* определены как пользовательские выходные дни.
2. Исправлены некоторые ошибки.
3. Добавлена техническая опция *timeperiodsR.parts* которая позволяет избежать в будущем дублирования кода.

# timeperiodsR 0.6.0
Дата: 2020-01-03

## Расширение класса tpr
В класс *tpr* добавлен компонент `custom_day_offs` в котором будут отображаться заданные вами пользовательские выходные дни, например ваш отпуст.

Для определения пользовательских выходных дней можно воспользоваться опциями или переменными среды:

* опция - timeperiodsR.custom_day_offs
* переменная среды - TPR_CUSTOM_DAY_OFFS

В опцию достаочно передать вектор из ваших выходных дней. 
В переменную среды передайте даты в формате ГГГГ-ММ-ДД разделённые запятыми или точкой с запятой, например `2020-01-14;2020-01-15;2020-01-16`.


# timeperiodsR 0.5.0
Дата: 2019-12-28

## Расширение класса tpr
В пакет интегрирован API производственного календаря [isDayOff()](https://isdayoff.ru/). За счёт чего был значительно расширен класс *tpr*.

## Опции
По умолчанию в пакете нет дополнительных компонентов, для их активации вам необходимо активировать следующие опции:

```
options("timeperiodsR.official_day_offs" = TRUE,
        "timeperiodsR.official_day_offs_country" = "ru",
        "timeperiodsR.official_day_offs_pre" = 1)
```

После чего в классе *tpr* вам будут доступны следующие компоненты:
* official_workdays - Официальные рабочие дни;
* official_first_workday - Первый официальный рабочий день;
* official_last_workday - Последний официальный рабочий день;
* official_day_offs - официальные выходные дни в выбранной стране, по умолчанию России;
* dayoffs_marks - пометки о том, какой статус имеет день в официальном календаре страны.

## Переменные среды
Так же в пакеты была добавленна поддержка переменных среды для активации новых компонентов:

* TPR_DAY_OFFS - TRUE, для активации дополнительных компонентов;
* TPR_COUNTRY - Страна: ru, ua, by или kz;
* TPR_PRE - Включать в компонент *official_day_offs* сокращённые рабочие дни, в компоненте *dayoffs_marks* они будут помечены числом 2.

## Новая функция
Функция `check_dayoffs()` позволяет вам проверить любую дату, вектор дат или объект класса tpr и получить пометку о том какой статус выбранные даты имеют в официальном календаре.

## Новый аргумент в метоже sequence
В метод `seq()` добавлен аргумент *what*, который позволяет вам указать какую именно последовательность вы хотите получить из объекта класса tpr.

* "sequence" - вся последовательность дат
* "workdays" - будние дни
* "weekends" - выходные дни
* "official_day_offs" - официальные выходные
* "official_workdays" - официальные рабочие дни

## Документация
Более подробно обо всём функционале можно узнать в виньетке: `vignette("tpr_intro", package = "timeperiodsR")`

# timeperiodsR 0.4.0
Дата: 2019-12-27

* Расширен класс tpr, добавлены следующие компоненты
    * workdays - вектор состоящий из будний дней входящих в период
	* weekends - вектор состоящий из выходных дней входящих в период
	* first_workday - первый будний день периода
	* last_workday - последний будний день периода
	* first_weekend - первый выходной день периода
	* last_weekend - последний выходной день периода
	* workdays_length - количество будних дней в периоде
	* weekends_length - количество выходных дней в периоде

* Добавлены новые методы
    * workdays - получить вектор будних дней периода
	* weekends - получить вектор выходных дней периода
	* first_workday - получить первый будний день периода
	* last_workday - получить последний будний день периода
	* first_weekend - получить первый выходной день периода
	* last_weekend - получить последний выходной день периода
	* workdays_length - получить количество будних дней в периоде
	* weekends_length - получить количество выходных дней в периоде
	
* Аргумент  *part* также теперь принимает больше значений
    * start
	* end
	* length
	* sequence
	* workdays
	* weekends
	* first_workday
	* last_workday
	* first_weekend
	* last_weekend
	* workdays_length
	* weekends_length

# timeperiodsR 0.2.0
Дата: 2019-11-14

В пакет добавлены 4 оператора позволяющие удобно фильтровать объекты класса *tpr*. Все подробности работы с операторами можно узнать их виньетки `vignette("tpr_intro", package = "timeperiodsR")`.


# timeperiodsR 0.1.0
Дата: 2019-09-18

Первый релиз пакета, подробности его использования, и описание возможностей можно посмотреть в виньетке `vignette("tpr_intro", package = "timeperiodsR")`.
