% Generated by roxygen2: do not edit by hand
\name{mapply}
\alias{mapply}
\alias{Map}
\title{Apply Over Multiple Lists/Vectors}
\arguments{
  \item{FUN}{the function to apply}
  \item{...}{list/vector arguments to map FUN over}
  \item{MoreArgs}{a list of additional arguments to FUN (optional)
}
}

\details{
Map over multiple vectors
\code{
mapply(rep, 1:4, 4:1)
mapply(rep, x = 1:4, times = 4:1)
mapply(rep, times = 4:1, x = 1:4)
}

Provide additional arguments via MoreArgs
\code{
mapply(max, c(1:9, NA), c(NA, 9:1), MoreArgs = list(na.rm = TRUE))
}

Prevent automatic coercion with SIMPLIFY or Map()
\code{
mapply(
  FUN = diag,
  nrow = c(1, 2, 4, 8),
  ncol = c(8, 4, 2, 1),
  SIMPLIFY = FALSE
)

Map(
  f = diag,
  nrow = c(1, 2, 4, 8),
  ncol = c(8, 4, 2, 1)
)
}
}

