/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.variable;

import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.variable.ValueImpl;
import com.izforge.izpack.util.config.base.Config;
import com.izforge.izpack.util.config.base.Ini;
import com.izforge.izpack.util.config.base.Options;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class ConfigFileValue
extends ValueImpl
implements Serializable {
    private static final long serialVersionUID = 6082215731362372562L;
    public static final int CONFIGFILE_TYPE_OPTIONS = 0;
    public static final int CONFIGFILE_TYPE_INI = 1;
    public static final int CONFIGFILE_TYPE_XML = 2;
    public int type = 0;
    public String section;
    public String key;
    public boolean escape = true;

    public ConfigFileValue(int type, String section, String key, boolean escape) {
        this.type = type;
        this.section = section;
        this.key = key;
        this.setEscape(escape);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getSection() {
        return this.section;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean isEscape() {
        return this.escape;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    @Override
    public void validate() throws Exception {
        if (this.type == 1 && (this.section == null || this.section.length() <= 0)) {
            throw new Exception("No INI file section defined");
        }
        if (this.type != 1 && this.section != null) {
            throw new Exception("No INI file section expected for non-INI file types");
        }
    }

    protected String resolve(InputStream in) throws Exception {
        switch (this.type) {
            case 0: {
                Config config = Config.getGlobal().clone();
                config.setEscape(this.isEscape());
                Options opts = new Options(config);
                opts.load(in);
                return (String)opts.get(this.key);
            }
            case 1: {
                Config config = Config.getGlobal().clone();
                config.setEscape(this.isEscape());
                Ini ini = new Ini(config);
                ini.load(in);
                return ini.get((Object)this.section, this.key);
            }
            case 2: {
                return ConfigFileValue.parseXPath(in, this.key, System.getProperty("line.separator"));
            }
        }
        throw new Exception("Invalid configuration file type " + this.type);
    }

    protected String resolve(InputStream in, VariableSubstitutor ... substitutors) throws Exception {
        String _key_ = this.key;
        for (VariableSubstitutor substitutor : substitutors) {
            _key_ = substitutor.substitute(_key_);
        }
        switch (this.type) {
            case 0: {
                Config config = Config.getGlobal().clone();
                config.setEscape(this.isEscape());
                Options opts = new Options(in, config);
                return (String)opts.get(_key_);
            }
            case 1: {
                Config config = Config.getGlobal().clone();
                config.setEscape(this.isEscape());
                String _section_ = this.section;
                for (VariableSubstitutor substitutor : substitutors) {
                    _key_ = substitutor.substitute(_key_);
                }
                Ini ini = new Ini(in, config);
                return ini.get((Object)_section_, _key_);
            }
            case 2: {
                return ConfigFileValue.parseXPath(in, _key_, System.getProperty("line.separator"));
            }
        }
        throw new Exception("Invalid configuration file type '" + this.type + "'");
    }

    private static String parseXPath(InputStream in, String expression, String separator) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document doc = builder.parse(in);
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile(expression);
        Object result = expr.evaluate(doc, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String value = nodes.item(i).getNodeValue();
            if (value == null) continue;
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(value);
        }
        return sb.toString();
    }
}

