/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.Debug;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private final String lineSeparator = System.getProperty("line.separator");

    @Override
    public synchronized String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        if (Debug.isDEBUG()) {
            if (record.getSourceClassName() != null) {
                sb.append(record.getSourceClassName());
            } else {
                sb.append(record.getLoggerName());
            }
            if (record.getSourceMethodName() != null) {
                sb.append(" ");
                sb.append(record.getSourceMethodName());
            }
            sb.append(this.lineSeparator);
            sb.append(record.getLevel().getLocalizedName());
            sb.append(": ");
        }
        String message = this.formatMessage(record);
        sb.append(message);
        if (Debug.isSTACKTRACE() && record.getThrown() != null) {
            sb.append(this.lineSeparator);
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        sb.append(this.lineSeparator);
        return sb.toString();
    }
}

