---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, 
              cadre autour des formules, encadrer une formule, 
              mettre une formule en valeur
---

# Comment encadrer des formules mathématiques ?

Si une solution *intuitive* consiste à mettre la formule dans un tableau 
d'une seule cellule, il existe des solutions plus simples à l'usage.


## Avec l'extension <ctanpkg:mathtools>

L'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>) offre la commande 
`\boxed`, présentée dans l'exemple ci-dessous :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\[  \boxed{a=b}  \]
\end{document}
```

Notez qu'il peut être utile d'encapsuler les environnements multilignes 
de <ctanpkg:mathtools> (ou <ctanpkg:amsmath>), tels `multline` ou `split`, 
dans un `math` ou dans un `displaymath`.

Il existe également la commande `\fbox`, comme ici :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\begin{equation}
  \fbox{$
    \begin{array}{rcl}
      x + y + z & = & 0 \\
      2x + 2y + 2z & = & 0
    \end{array}
  $}
\end{equation}
\end{document}
```


## Avec l'extension <ctanpkg:fancybox>

L'extension <ctanpkg:fancybox> propose différents modèles de boîtes (ombrées, 
avec filets doublés...) qui peuvent, entre autres, encadrer des mathématiques,
quitte à utiliser l'environnement `Beqnarray` proposé par l'extension :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{fancybox}

\begin{document}
\linethickness{3pt}
\doublebox{
  \begin{Beqnarray}
    ds^2&\,=\,&
    \displaystyle{\frac{\epsilon^{\prime 2}}{L^2}
    \frac{12N}{(N+1)(N+2)}}
  \end{Beqnarray}
}
\end{document}
```


## Avec l'extension <ctanpkg:tcolorbox> 

L'extension <ctanpkg:tcolorbox>, de Thomas F. Sturm, permet initialement 
d'obtenir des boîtes colorées encadrant du texte avec l'environnement 
`tcolorbox`. Ces boîtes peuvent être finement configurées avec, par exemple,
une couleur ou un motif de fond, une distinction des parties hautes et basses
de la boîte, un bandeau de titre (comme dans l'exemple ci-dessous). 
La configuration des boîtes peut être faite avec le paramètre facultatif 
de l'environnement `tcolorbox` comme avec une commande dédiée, `\tcbset`.

Par défaut, cette extension peut traiter l'encadrement simple d'équations.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tcolorbox}

\begin{document}
Voici une première équation remarquable : 
\tcbset{colback=blue!5!white,colframe=blue!50!white} % Style des boîtes

\begin{tcolorbox}[title=Important] 
  \[  \sum\limits_{n=0}^{\infty} \frac{x^n}{n!} = e^x  \]
\end{tcolorbox}
\end{document}
```

Mais il faut noter que l'extension dispose aussi d'une librairie 
nommée `theorems` pour obtenir des réglages dédiées aux mathématiques 
(pour des formules ou pour des théorèmes). Dès lors, il devient possible 
d'encadrer des *parties* d'une formule avec la commande `\tcbhighmath`. 
En voici différents exemples :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tcolorbox}
  \tcbuselibrary{theorems}    % Appel de la librairie theorems

\begin{document}
\tcbset{ % Définition d'un style "maformule"
  maformule/.style={
    colback=blue!10!white,
    colframe=blue!50!white,
    every box/.style={
      highlight math style={
        colback=red!10!white,
        colframe=red!50!white
}}}}

Un exemple de série divergente :
\begin{equation}
  \tcbhighmath[maformule]{\sum\limits_{n=1}^{\infty} \frac{1}{n}} = \infty.
\end{equation}

Un exemple d'implication :
\begin{equation}
  \tcbset{fonttitle=\scriptsize}
  \tcboxmath[colback=blue!10!white,colframe=blue!50!white]{a^2 = 16 }
  \quad \Rightarrow \quad
  \tcboxmath[colback=red!10!white,colframe=red!50!white,title=Implication]%
  { a = 4 ~\vee~ a=-4. }
\end{equation}

Un exemple de système : 

\begin{tcolorbox}[ams align,maformule]
  \begin{array}{rcl}
    x + y + z & = & \tcbhighmath{0} \\
    2x + 2y + 2z & = & 0
  \end{array}
\end{tcolorbox}
\end{document}
```

Le dernier exemple illustre, avec la définition du style `maformule`, 
la capacité de la commande `\tcbset` à paramétrer le style d'une boîte
(ici avec des nuances de bleu) mais aussi le style d'une boîte imbriquée
dans une autre boîte (avec des nuances de rouge). 