---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, polices de caractères, fontes, caractères flous, 
              lettres floues, texte flou, texte pas net, bug de Ghostscript
---

# Comment corriger le problème de caractères flous générés par Ghostscript ?

:::{warning}
Normalement, ce problème est loin derrière nous (il a été résolu en 2001). 
Si vous rencontrez de nouveau des problèmes de caractères flous, 
il faut sans doute chercher d'autres causes.
:::

Bien que votre installation de polices soit bien faites 
(vous les voyez bien dans votre document en sortie de `dvips`), 
vous obtenez *toujours* des caractères flous dans votre document final 
après avoir l'avoir converti en PDF avec [ghostscript](wpfr:Ghostscript).

Le problème peut provenir d'une version trop ancienne de [ghostscript](https://www.ghostscript.com/), 
que vous utilisez soit directement, soit via un script tel que `ps2pdf` 
(distribué avec `ghostscript` lui-même), `dvipdf`, ou similaire. 
Bien que `ghostscript` soit capable de convertir depuis la version 5.50, 
cette version ne pouvait produire que des sorties bitmap de Type 3 pour toute police 
autre que les 35 polices de base (*Times*, *Helvetica*, etc.). 
Les versions ultérieures ont progressivement ajouté une conversion complète, 
mais ce n'est qu'à partir de la version 6.50 que l'on pouvait s'y fier véritablement.

Donc, si votre sortie PDF semble systématiquement floue dans `Acrobat Reader`, 
mettez à jour `ghostscript`. La nouvelle version doit être au moins la version 6.50, bien sûr, 
mais il est généralement préférable de passer à la version la plus récente 
(des versions 8.xx sorties à compter de 2002 aux versions 10.xx depuis 2023).


:::{sources}
[Fuzzy fonts because « Ghostscript » too old](faquk:FAQ-fuzzy-gs)
:::