/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.LineSegment;
import com.itextpdf.text.pdf.parser.TextExtractionStrategy;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import com.itextpdf.text.pdf.parser.Vector;

public class SimpleTextExtractionStrategy
implements TextExtractionStrategy {
    private Vector lastStart;
    private Vector lastEnd;
    private final StringBuffer result = new StringBuffer();

    public void beginTextBlock() {
    }

    public void endTextBlock() {
    }

    public String getResultantText() {
        return this.result.toString();
    }

    public void renderText(TextRenderInfo renderInfo) {
        float spacing;
        boolean firstRender = this.result.length() == 0;
        boolean hardReturn = false;
        LineSegment segment = renderInfo.getBaseline();
        Vector start = segment.getStartPoint();
        Vector end = segment.getEndPoint();
        if (!firstRender) {
            float sameLineThreshold;
            Vector x0 = start;
            Vector x2 = this.lastEnd;
            Vector x1 = this.lastStart;
            float dist = x2.subtract(x1).cross(x1.subtract(x0)).lengthSquared() / x2.subtract(x1).lengthSquared();
            if (dist > (sameLineThreshold = 1.0f)) {
                hardReturn = true;
            }
        }
        if (hardReturn) {
            this.result.append('\n');
        } else if (!firstRender && this.result.charAt(this.result.length() - 1) != ' ' && renderInfo.getText().charAt(0) != ' ' && (spacing = this.lastEnd.subtract(start).length()) > renderInfo.getSingleSpaceWidth() / 2.0f) {
            this.result.append(' ');
        }
        this.result.append(renderInfo.getText());
        this.lastStart = start;
        this.lastEnd = end;
    }

    public void renderImage(ImageRenderInfo renderInfo) {
    }
}

