{$N-,W-,G+,V-,M 16000,0}

{ Should be 16400 }

{$R wbibdb}
program wbibdb;

Uses
  commdlg,
  Wobjects, WinTypes, WinProcs, strings,  bibvars,  rc_id,    wbibdisp, bibstrg,
  bibinit,  wbibbrws, wbibupdt, bibsave,  bibutil,  bibmain,  wbibabv1,
  wbibabv2, wbibshow, wbib3d,   wbibgui,  wbibinit, rc_strng, bibcache, bibgoto,
  bibmisc,  Ole,      wbibole,  bibfile,  wbibpatt;

type


  TBibDBApp = object(TApplication)
    constructor Init(AName: PChar);
    procedure   InitApplication;   virtual;
    procedure   InitInstance;      virtual;
    procedure   InitMainWindow;    virtual;
    function    ProcessMDIAccels(var Message: TMsg): Boolean; virtual;
    function    ProcessAccels(var Mess: TMsg): Boolean; virtual;
    function    ProcessDlgMsg(var Mess: TMsg): Boolean; virtual;
    function    CanClose: boolean; virtual;
    procedure   Run;               virtual;
    destructor  Done;              virtual;
  end;

var
  App: TBibDBApp;

constructor TBibdbApp.Init(AName: Pchar);
begin
  ArrowCursor:=LoadCursor(0,IDC_Arrow);
  FingerCursor:=LoadCursor(Hinstance,PChar(rc_FingerCursor));
  CrossCursor:=LoadCursor(Hinstance,PChar(rc_CrossCursor));
  HyperCursor:=LoadCursor(Hinstance,PChar(rc_HyperCursor));
  CoffeeCupCursor:=LoadCursor(Hinstance,PChar(rc_CoffeeCupCursor));
  GuitarCursor:=LoadCursor(Hinstance,PChar(rc_GuitarCursor));
  HourglassCursor:=LoadCursor(0,IDC_WAIT);
  MainIcon:=LoadIcon(Hinstance,PChar(rc_MainIcon));
  StdObjectIcon:=LoadIcon(Hinstance,PChar(rc_StdObjectIcon));

  OleCheck(0,Nil,OleRegisterClientDoc('wBibDB','Mem',0,ClientDoc));

  TApplication.Init(AName);

  if UseCoffeeCup then WaitingCursor:=CoffeeCupCursor
  else WaitingCursor:=HourglassCursor;
  HAccTable:=LoadAccelerators(Hinstance,PChar(rc_BrAccel));
end;                { TBibdbApp.Init }

procedure TBibDBApp.InitApplication;
begin
  FirstInstance:=true;
end;

procedure TBibDBApp.InitInstance;
begin
  Pattern:=Nil;
  InitDB(Pattern);
  FindAllPattLists;
  FindAllPattAssoc;
  RegisterBibDBClasses;
  TApplication.InitInstance;
end;

procedure TBibDBApp.InitMainWindow;
begin
  MainWindow:=New(PBrowseWindow, Init(Nil,'BibDB'));
end;

function TBibDBApp.ProcessMDIAccels(var Message: TMsg): Boolean;
begin ProcessMDIAccels:=false; end;

{ Ignore accelerators for other windows }
function TBibDBApp.ProcessAccels(var Mess: TMsg): Boolean;
begin
  ProcessAccels:=false;  
  if (MainWindow^.HWindow=Mess.hWnd) or
      IsChild(MainWindow^.HWindow,Mess.hwnd) then
        ProcessAccels:=TApplication.ProcessAccels(Mess);
end;

function TBibDBApp.ProcessDlgMsg(var Mess: TMsg): boolean;
begin
  ProcessDlgMsg:=IsDialogMessage(FindRepWnd,Mess);
end;

function TBibDBApp.CanClose: boolean;
begin
  CanClose:=TApplication.CanClose and
            ((not LeaveConfirm) or YesNoRC(Str_ReallyQuit,''));
end;

procedure TBibDBApp.run;
var
  Selected: SelectionType;
begin
  MainW:=PWindow(MainWindow);
  HMainW:=MainWindow^.HWindow;
  MessageParent:=HMainW;
  CurrentWindow:=MainW;

  Entry:=Nil; NewEntry(Entry); entry^.nentry:=0;
  ResetBib(Entry); Entry^.name:=''; Entry^.EntryType:='';

  PBrowseWindow(MainWindow)^.CalcSizes(0,0);
  PBrowseWindow(MainWindow)^.Update;
  UpdateWindow(MainWindow^.HWindow);

  WaitingMessage('Loading abbreviations...');
  LoadIniAbbrevs(IniAbbrevsList);
  LoadBibAbbrevs(BIBAbbrevsList,BIBAbbrevsFile^,Entry);
  LoadBstAbbrevs(BSTAbbrevsList,BSTAbbrevsFile^);
  LoadStringAbbrevs(StrAbbrevsList,Entry);
  ResetBib(Entry);
  WaitingOff;

  if AutoBuildIndex and BibFileExists and (not Linked) and (IndexFileName^='')
     and UseIndexFile then
  begin
    FillChar(Selected,sizeof(SelectionType),0);
    Selected[1]:=CFile_AutoIndex;
    DealWithFiles(Entry,Pattern,Selected);
  end;

  if TeXAuxFile^<>'' then
  begin
    MacroCommand:=true; InputStr^:=TexAuxFile^;
    DealWithTagging(Entry,Pattern,CEdit_TagTeX);
    ResetBib(Entry);
  end;
  if SearchString^<>'' then
  begin
    DealWithGoto(Entry,Pattern,0,false,false,false,CGoto_Search);
    if entry^.entrynum=0 then
      DealWithGoto(Entry,Pattern,0,true,false,true,CGoto_Next);
  end else if LabelSearchString^<>'' then
  begin
    DealWithGoto(Entry,Pattern,0,false,false,false,CGoto_label);
    if entry^.entrynum=0 then
      DealWithGoto(Entry,Pattern,0,true,false,true,CGoto_Next);
  end else
  begin
    DealWithGoto(Entry,Pattern,0,true,false,true,CGoto_Next);
  end;
  PBrowseWindow(MainWindow)^.Update;

  TApplication.run;
end;                       { TBibDBApp.run }

destructor TBibDBApp.Done;
var
  i: integer;
begin
  if FindWindow(BibDBMainWinClass,Nil)=0 then UnregisterBibDBClasses;
  if SaveWinOptsOnExit and OptionsModified.WindowsParams then
    SaveWinOptions;
  if SaveWinOptsOnExit and OptionsModified.PattHeirarchies then
    SaveAllPattLists;
  if SaveOptsOnExit then
    SaveConfigOptions(OptionsModified.Preferences,
                      OptionsModified.Registers,
                      OptionsModified.Sort,
                      OptionsModified.Formats,
                      OptionsModified.Fields);
  for i:=FirstFontIndex to LastFontIndex do
    if Fonts^[i].Initialized then
      DeleteObject(Fonts^[i].Font);
  if ENameBackBrush<>0 then DeleteObject(ENameBackBrush);
  if CrossCursor   <>0 then DestroyCursor(CrossCursor);
  DestroyCursor(FingerCursor);
  DestroyCursor(HyperCursor);
  DestroyCursor(CoffeeCupCursor);
  DestroyCursor(GuitarCursor);
  DestroyIcon(MainIcon);
  if StdObjectIcon<>0 then DestroyIcon(StdObjectIcon);
  if HPDevMode    <>0 then GlobalFree(HPDevMode);
  if HPDevNames   <>0 then GlobalFree(HPDevNames);
  OleRevokeClientDoc(ClientDoc);
  TApplication.Done;
end;                           { TBibDBApp.Done }

procedure dummy;
begin
end;

begin
  App.Init('BibDB');
  App.Run;
  App.Done;
end.
