/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import java.util.HashMap;
import java.util.Map;

public enum AntLogLevel {
    ERROR("error", 0),
    WARNING("warning", 1),
    INFO("info", 2),
    VERBOSE("verbose", 3),
    DEBUG("debug", 4);

    private final String name;
    private final int level;
    private static final Map<String, AntLogLevel> reversed;

    private AntLogLevel(String name, int level) {
        this.name = name;
        this.level = level;
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    public static AntLogLevel fromName(String name) {
        return AntLogLevel.fromName(name, null);
    }

    public static AntLogLevel fromName(String name, AntLogLevel defaultLevel) {
        AntLogLevel level = reversed.get(name);
        if (level == null) {
            return defaultLevel;
        }
        return level;
    }

    static {
        reversed = new HashMap<String, AntLogLevel>();
        for (AntLogLevel l : AntLogLevel.values()) {
            reversed.put(l.getName(), l);
        }
    }
}

