unit TexETSub;
{  Main subroutines for conversion TeX to ET.

   CORRECTIONS TO CONSIDER: search '??'

21 Jul 93 JCC  Correct treatment of onecharargs -- see SearchArg
19 Jul 93 JCC  Try to get newlines in middle of constructs correct
17 Jul 93 JCC  Treat space after CS like \frac correctly
26 Jul 92 JCC  Remove space between arguments of fraction
 3 Jan 92 JCC  Remove bell in completion message.
18 Aug 91 JCC  Read using unixio unit to allow long lines and unix
               input files to be treated correctly: reading a line
               now brings in the line terminator (cr/lf under MSDOS
               or lf under unix).  Also long lines => just read partial
               line, then read in rest.  Conversion may be incomplete,
               but at least I won't lose any characters.
12 Jan 91 JCC  ET commands.
               Remove use of Params
 6 Sep 90 JCC  Handle "%ET_" and comments after \frac
 5 Sep 90 JCC  State --> Params
 4 Sep 90 JCC  Start to treat fractions spanning line correctly.
               PendingConstructs variable.
 7 Aug 90 JCC  Fully delimited fractions.
 2 Aug 90 JCC  Fraction support.
10 Sep 89 JCC

PendingConstructs = level of pending constructs that may span line e.g.
                    fraction.  Reset to zero at end of paragraph.

}

{$I etdirect.inc}            {Directives shared by all units}

interface

uses utils, unixio, stderr, ETSyms, texetdef;

type CSType = (CSnothing, CScomment, CSchar, bgroup, egroup, CSsub, CSsuper,
                  CSspecial, CSother);

procedure ProcessTeXFile     (var MyParams : Params);
procedure GetToken (var Line: LongString; posn: integer;
                    var Token: LongString; var FullLen: integer);
procedure ClassToken (var Token: LongString;
                      var ItsClass: CSType; var ItsTran: Longstring);



implementation { ============ IMPLEMENTATION ======================= }
{$R-}

const
   MAXPushedComments = 20;

var {global variables for transformation.}
   Source : Pfile;
   Dest : text;
   BraceLevel, NumLine, PendingConstructs: integer;
   Continuation, Translate: boolean;
   BraceType: array[0..MaxBrace] of SubSupType;
   CurrentMode: Mode;
   SearchState: (NoSearch, FindArg, OneCharArg);
   Pushed: string;       { String to insert at front of continuation line}
   PushedComment: array [1..MAXPushedComments] of string;
   NumPushedComments : integer;

function min (i, j: integer): integer;
   begin if i < j then min := i else min := j; end;


{ --------------------- }

procedure Restart (var MyParams : Params);
begin
   BraceLevel := 0; (*Outside any {...} pairs.  *)
   BraceType[0] := normal;
   PendingConstructs := 0;   { Outside any constructs like fraction}
   Continuation := false;
   Translate := true;        { TeX to ET translation on }
   NumLine := 0;
   CurrentMode := InText;
   SearchState := NoSearch;
   Pushed := '';
   NumPushedComments := 0;
end;


procedure GetToken (var Line: LongString; posn: integer;
                    var Token: LongString; var FullLen: integer);
{ Find token starting at posn.
  Token is either a single character that is not '\', or it is '\'
  followed by a single non-letter, or it is '\' followed by any number of
  letters.  If it is '\' followed be letters, then the first character
  after the token is any non-letter.
  FullLen is set to the length of the string in Line, including trailing
  spaces.  (If the last character in the line is '\', then Token:= '\ '
  and FullLen:=1.)

  Only absorb at most one space after \<letters>.
}
var
   MyPosn : integer;
begin
   if Posn > Length(Line) then begin
      Token := '';
      FullLen := 0;
   end
   else if Line[posn] <> '\' then begin
      Token := Line[posn];
      FullLen := 1;
   end
   else if Posn = Length(Line) then begin
      Token := '\ ';
      FullLen := 1;
   end
   else if not (Line[posn+1] in Letters) then begin
                   { Token is '\' followed by non-letter. }
      Token := '\' + Line[posn+1];
      FullLen := 2;
   end
   else begin       { Token is '\' followed by one or more letters.  }
      MyPosn := Posn + 1;            { Last character so far in token }
      while (MyPosn < Length(Line)) and (Line[MyPosn+1] in Letters) do
         MyPosn := MyPosn + 1;
      FullLen := MyPosn + 1 - Posn;
      Token := copy (Line, Posn, FullLen);
      while (MyPosn < Length(Line)) and (Line[MyPosn+1] = ' ') do
         MyPosn := MyPosn + 1;
      FullLen := MyPosn + 1 - Posn;
   end;
end; {GetToken}


procedure ClassToken (var Token: LongString;
                      var ItsClass: CSType; var ItsTran: Longstring);
{   Classify Token, putting result in ItsClass.
    If it is a CS translating to a simple string, set ItsTran
    to the translation.  }
var TryCode: char;
    done: boolean;
begin
   {Defaults:}
   ItsTran := '';
   if (Length(Token) < 1) then
      ItsClass := CSNothing
   else if (Token = '%') then
      ItsClass := CSComment
   else if (Token = '{') then
      ItsClass := bgroup
   else if (Token = '^') then
      ItsClass := CSSuper
   else if (Token = '_') then
      ItsClass := CSSub
   else if (Token = '}') then
      ItsClass := egroup
   else if ( (Token = '$') or (Token = '#') or (Token = '~')
           or (Token = '&')) then
      ItsClass := CSspecial
   else if length (Token) = 1 then
      ItsClass := CSChar
   else if (Token[1] = '\') then begin
      TryCode := ' ';
      done := false;
      while (TryCode <= #126) and not done do begin
         if (Token = GreekTrans[TryCode]) then begin
            done := true;
            ItsTran := Symbol + TryCode;
         end else
            TryCode := Succ(TryCode);
      end;
      if done then
         ItsClass := CSChar
      else
         ItsClass := CSOther;
   end else
      ItsClass := CSOther;
end; { ClassToken }



function Continued (var Line: longstring; Posn: integer): boolean;
   var s: string;
   begin      {Continued}
      s := Copy (Line, Posn, Length(Line) + 1 - Posn);
      Continued := (s = ContinueStr) or (s = ContinueStr1);
   end;       {Continued}


procedure DoContinue (var Line: longstring; Posn: integer; CS: string);
   { Kill Line from Posn on, save CS to push to next line }
   begin     {DoContinue}
      Delete (Line, Posn, length(Line) + 1 - Posn);
      Continuation := true;
      Pushed := CS;
   end;      {DoContinue}


function ETCmd (var Line: longstring; Posn: integer): boolean;
   {Is this an ET command?  Posn points to %ET then - or space}
   var s: string;
       L: integer;
   begin      {ETCmd}
      L := length (CmdIntro);
      if Length(Line) <= Posn + L - 1 then begin
         ETCmd := false;
      end else begin
         s := Copy (Line, Posn, L);
         ETCmd := Continued (Line, Posn) or (s = CmdIntro);
      end;
   end;       {ETCmd}


procedure ObeyETCmd (var Line: longstring; Posn: integer);
   var CmdStr: string;
       Cmd: ETCmdType;
   begin     {ObeyETCmd}
      if Continued (Line, Posn) then begin
         Cmd := ETCmdCont;
          { ===== Should not get here =====}
      end else if not ETCmd (Line, Posn) then begin
         Cmd := ETCmdNone;
          { ===== Should not get here =====}
      end else begin
         Posn := Posn + Length(CmdIntro);
         SkipSpace (Line, Posn);
         if (Posn <= length(Line)) then begin
            CmdStr := copy (Line, Posn, Length(Line) - Posn + 1);
            UC (CmdStr);
            if GoodAbbrev(CmdStr, 'NOTRANSLATE', 4) then begin
               Cmd := ETCmdNoTran;
            end else if GoodAbbrev(CmdStr, 'TRANSLATE', 2) then begin
               Cmd := ETCmdTran;
            end else begin
               Cmd := ETCmdBad;
            end;
         end;
      end;
      writeln ('===ObeyETCmd:  ', line);
      writeln ('   cmdstr: ', cmdstr);
      if translate then begin
         case Cmd of
            ETCmdTran: Translate := true;
            ETCmdNoTran: Translate := false;
         end;
      end else begin
         case Cmd of
            ETCmdTran: Translate := true;
         end;
      end;
   end;      {ObeyETCmd}


procedure PushComment (var Line: LongString; var Posn: integer);
   begin
      if (NumPushedComments < MAXPushedComments) then begin
         inc (NumPushedComments);
         PushedComment[NumPushedComments] :=
              Copy (Line, Posn, Length(Line) +1 - Posn);
      end else begin
         writeln ('Overcapacity for pushing comments in line ',
              Numline);
         writeln ('I will ignore the comment in ');
         writeln (Line);
      end;
      Delete (Line, Posn, Length(Line) + 1 - Posn);
   end; {PushComment}


procedure PopComments;
   var i: integer;
   begin
      for i := 1 to NumPushedComments do begin
         if (ETCmd(PushedComment[i], 1)) then
            ObeyETCmd (PushedComment[i], 1);
         writeln (Dest, PushedComment[i]);
      end;
      NumPushedComments := 0;
   end;   {PopComments}



procedure OpenGroup (ss: SubSupType);
   {Assume all text processing for the opengroup has been done}
   begin
      BraceLevel := BraceLevel + 1;
      if BraceLevel <= MaxBrace then
         BraceType[BraceLevel] := ss
      else
         writeln ('Too deep braces on line ', NumLine);
   end;  {OpenGroup}



procedure StartConstruct (ss: subsuptype;
                    var Line: LongString; var posn: integer;
                    FullLen: integer);
   { Start construct.  Assume Line[Posn] is first of its CS.   }
   begin
      OpenGroup (ss);
      inc (PendingConstructs);
      case ss of
         subscript: Line[Posn] := beginsub;
         superscript: Line[Posn] := beginsup;
         setfrac: Line[Posn] := beginfrac;
      end;
      Delete (Line, Posn+1, FullLen -1);
      SearchState := FindArg;
   end; {StartConstruct}



procedure StartArg (var Line: LongString; var posn: integer);
  { Assume Line[Posn] is first potential character of argment.
    Set up start of beginarg-endarg pair.
    Posn points to last character before beginarg.}
begin  {StartArg}
   inc (Posn);
   Insert (BeginArg, Line, Posn);
   OpenGroup (arg);
   SearchState := FindArg;
end;     {StartArg}


procedure CloseGroup (var Line: LongString; var Posn: integer;
                      FullLen: integer);
   {Assume a group is to be closed.
    Posn points to CS triggering the CloseGroup.  FullLen characters
    are to be replaced.  If FullLen = 0 then no characters are to be
    removed but the close group symbol is to placed after it.
   }
   var CurType : SubSupType;
       Repl: string;
   begin {CloseGroup}
      SearchState := NoSearch;
      if BraceLevel < 1 then
         writeln ('Brace error on line ', NumLine)
      else if BraceLevel > MaxBrace then
         BraceLevel := BraceLevel - 1
      else begin
         CurType := BraceType[BraceLevel];
         BraceLevel := BraceLevel - 1;
         Repl := ''; {default}
         case CurType of
            subscript: Repl := endsub;
            superscript: Repl := endsup;
            arg:       Repl := endarg;
            normal:    Repl := '}'
         end; {case}
         if (FullLen = 0) then begin
            insert (Repl, Line, Posn+1);
            inc (Posn, Length(Repl));
         end else if CurType = normal then begin
            {Do nothing}
         end else begin
            Replace (Line, Posn, Posn, FullLen, Repl);
            inc (Posn, length(Repl)-1);
            {So that Posn points to end of Repl}
         end;
         {Now the special cases}
         if (CurType in [subscript, superscript, SetFrac]) then
            dec (PendingConstructs);
         if (BraceLevel >= 1) and (BraceLevel <= MaxBrace) then begin
            CurType := BraceType[BraceLevel];
            if (CurType = GetArg) then begin
               dec (BraceLevel);
               StartArg(Line, Posn);
            end else if (CurType = SetFrac) then begin
               dec (BraceLevel);
               dec (PendingConstructs);
               inc (Posn);
               Insert (endfrac, Line, Posn);
            end;
         end; {if}
      end; {else}
   end; {CloseGroup}



procedure ConvertToken (var MyParams: Params;
                        var Line: LongString; var Posn: integer);
{ Convert token at Posn: only converted tokens are CSs
  Update Posn to point at last character read.
  For a CS that that translates to Greek/symbol and is all letters
  followed by spaces, remove one of the spaces, to invert the
  transformation made by ETTOTEX.
  For \frac and others that would have exactly one trailing space if
  generated by ETTOTEX, remove all the trailing spaces.
}
   var
      ReplLen : integer;
      done : boolean;
      TryCode : char;
      ReplStr, Token : LongString;

   begin
      GetToken (Line, Posn, Token, ReplLen);
      if (Length(Token) <= 1) then exit;
      TryCode := ' ';
      done := false;
      while (TryCode <= #126) and not done do
         if (Token = GreekTrans[TryCode]) then begin
            done := true;
            ReplStr := Symbol + TryCode;
         { Remove at most one space after the CS.  This will make TEXTOET
           invert the transformation made by ETTOTEX, which will insert
           one extra space after a CS like '\alpha':}
            ReplLen := min(length(Token)+1, ReplLen);
            Replace (Line, Posn, Posn, ReplLen, ReplStr);
            ReplLen := Length (ReplStr);
         end else TryCode := Succ(TryCode);
      if not done then begin
         if (Token = CSBksp) then begin
            Replace (Line, Posn, Posn, ReplLen, bksp);
            ReplLen := 1;
         end else if (Token = CSFrac) then begin
            if Continued (Line, Posn + ReplLen) then begin
               {For continuation line, postpone treating the CS till then}
               DoContinue (Line, Posn, CSFrac+' ');
            end else begin
               StartConstruct (setfrac, Line, Posn, ReplLen);
               ReplLen := 1;
                  { Flag another argument to come after the first, and need to
                    finish the fraction: }
               OpenGroup (getarg);
               StartArg (Line, Posn);
            end;
         end;
      end;
      Posn := Posn + ReplLen - 1;
   end; { ConvertToken }


procedure ConvertMath (var MyParams: Params;
                        var Line: LongString; var Posn: integer);
   { Given that Line[Posn] = '$' convert to begin/end math/eq. }
   begin                {ConvertMath}
           (*=========   with MyParams do   =====*)
      if (Length(Line) > Posn) and (Line[Posn+1] = '$') then begin
         { Toggle equation mode }
         case CurrentMode of
            InEq:   begin
                  delete(Line, Posn, 1);
                  Line[Posn] := EndEq;
                  CurrentMode := InText;
               end;
            InText: begin
                  delete(Line, Posn, 1);
                  Line[Posn] := BeginEq;
                  CurrentMode := InEq;
               end;
            InMath: begin
                  writeln ('Attempt to toggle eq mode while in math, ',
                           'in line ', NumLine, '.');
                  writeln (Line);
               end;
         end;
      end else begin
         { Toggle inline math mode }
         case CurrentMode of
            InMath: begin
                  Line[Posn] := EndMath;
                  CurrentMode := InText;
               end;
            InText: begin
                  Line[Posn] := BeginMath;
                  CurrentMode := InMath;
               end;
            InEq: begin
                  writeln ('Attempt to toggle math mode while in eq, ',
                           'in line ', NumLine, '.');
                  writeln (Line);
               end;
         end;
      end;
   end;              {ConvertMath}


procedure SearchArg (var Line: LongString; var Posn: integer);
   {?? =====  WHY NOT LEAVE THIS TO PROCESSLINE?
       LET IT DO A SKIP SPACE AS NEEDED AND HANDLE CONTINUATIONS
       SPECIAL CASES E.G. '$', FOR ERRORS ??  ??
       BUT THERE ARE SO MANY SPECIAL CASES!!???}
   {Assume that Posn points to the last character processed.
    And that a construct has been started for which an argument is
    needed, which may either be braced or a single token.
    On arrival here SearchState = FindArg.}
   var TryPosn, FullLen: integer;
       ItsClass: CSType;
       Token, ItsTran: LongString;
   begin {SearchArg}
      inc(Posn);
      TryPosn := Posn;
      SkipSpace (Line, TryPosn);
      {TryPosn now points to first non-space.  Now delete the space:}
      delete (Line, Posn, TryPosn-Posn);
      GetToken (Line, Posn, Token, FullLen);
      ClassToken (Token, ItsClass, ItsTran);
      if (Posn > Length(Line)) then begin
         {We must continue the search on the next line, and ignore the n/l}
         Continuation := true;
      end else begin
         case ItsClass of
           bgroup: begin
              Delete (Line, Posn, FullLen);
              dec (Posn); {So that it points to the last character used.}
              SearchState := NoSearch;
           end;
           egroup: begin
              {This appears to be an error: the argument ended before it began.}
              writeln ('A brace appears to be wrong in line ',
                   'in line ', NumLine, '.');
              writeln (Line);
              {SHOULD CLOSE CONSTRUCTS AND END THE GROUPS!!!!!!!!???===}
              {Fudge: process it next time:}
              SearchState := NoSearch;
              dec (Posn);
           end;
           CSComment: begin
              {We have a comment.
               If it is a continuation then we ignore it,
               else we push it.  Since we are skipping space,
               and we know the previous character was an ET control,
               it is correct to set continuation, so that no space is
               generated by the new line --- see ProcessTeXFile.}
             if (Continued(Line, Posn)) then
                DoContinue(Line, Posn, '')
             else begin
                PushComment (Line, Posn);
                continuation := true;
             end;
           end;
           else begin
             {Single token argument.  Leave a flag to finish it off.}
              SearchState := OneCharArg;
              {Process it next time:}
              dec (Posn);
           end;
(*====      ???? Better treatment here.  FOR NOW DON'T WORRY??
            else begin
             {This appears to be an error:
             the argument isn't a single character.}
             writeln ('Apparently a missing argument in line ',
                  'in line ', NumLine, '.');
             writeln (Line);
             {SHOULD CLOSE CONSTRUCTS AND END THE GROUPS!!!!!!!!???===}
             {Fudge: process it next time:  ?? WHY NOT DO IT NOW??}
             SearchState := NoSearch;
             dec (Posn);
           end;
=================*)
         end; {case}
      end;  {else}
   end;  {SearchArg}

procedure ProcessLine (var MyParams: Params; var Line: LongString);
var
   Posn, ReplLen : integer;
begin                {ProcessLine}
   if not translate then begin
      if (Pushed <> '') then begin
         write (Pushed);
         Pushed := '';
      end;
      Posn := 1;
      Skipspace (Line, Posn);
      if ETCmd (Line, Posn) then
         ObeyETCmd (Line, Posn);
      exit;
   end;
   Posn := 0;   {Last character that was read}
   rtb (Line);
   if (Pushed <> '') then begin
      Line := Pushed + Line;
      Pushed := '';
   end;
   if (Line = '') then begin
      if (PendingConstructs > 0) then begin
        {?? SHOULD CLOSE THEM!!!! ??}
         writeln ('End of paragraph with open constructs ',
                  'in line ', numline);
      end;
      PendingConstructs := 0;   {Paragraph}
   end;
   Continuation:= false;
   while Posn < Length(Line) do begin
      if SearchState = FindArg then begin
         SearchArg (Line, Posn);
      end else begin
         { Assume Posn points to last character read.  }
         Posn := Posn + 1;
         case line[Posn] of
            '\': ConvertToken (MyParams, Line, Posn);
            '$': if MyParams.TranDollar then
                      ConvertMath  (MyParams, Line, Posn);
            '{': OpenGroup (normal);
            '}': CloseGroup (Line, Posn, 1);
            '^': begin
                    if (Posn < length(Line)) and (Line[Posn+1] = '^') then
                       { ^^A: ignore the next two characters!}
                       inc (Posn, 2)
                    else
                       StartConstruct (superscript, Line, Posn, 1);
                 end;
            '_': StartConstruct (subscript, Line, Posn, 1);
            '%': begin
                  if Continued (Line, Posn) then begin
                     DoContinue (Line, Posn, '');
                  end else if (PendingConstructs > 0) then begin
                     {????? SHOULD I SET continuation := true; Else get space at newline
                      BUT in \al%comment the %comment is a terminator
                      for the \al.  THE SPACE WILL BE IGNORED BY TeX}
                     PushComment (Line, Posn);
                  end else begin
                     if ETCmd (Line, Posn) then begin
                        ObeyETCmd (Line, Posn);
                     end;
                     Posn := Length (Line);
                  end;
               end;
            else
               { Do nothing }
         end; {case}
         if (SearchState = OneCharArg) then begin
            CloseGroup (Line, Posn, 0);
         end;
      end; {else}
   end; {while}
end;                 {ProcessLine}

procedure ProcessTeXFile  (var MyParams : Params);
var
   Line : LongString;
   SourceBuf, DestBuf : ^TextBuf;

begin                {ProcessTeXFile}
   with MyParams do begin
      Source := fopen (SourceName, 'r');
      if Source = nil then begin
         writeln ('Cannot open input file ''', SourceName, '''.');
         exit;
      end;

      if openw (Dest, DestName) <> 0 then begin
         writeln ('Cannot open output device ''', DestName, '''.');
         exit;
      end;

      New (DestBuf);
      if DestBuf <> nil then SetTextBuf (Dest, DestBuf^);

      Restart (MyParams);
      while not feof(Source) do begin
         fgets (Source, Line);
         NumLine := Numline + 1;
         ProcessLine (MyParams, Line);
         if Continuation then begin
           Write (Dest, Line);
         end else if (PendingConstructs > 0) then begin
           {new line is equivalent to white space:}
           Write (Dest, Line, ' ');
         end else begin
            Writeln (Dest, Line);
            if (NumPushedComments > 0) then
               PopComments;
         end;
         if (NumLine mod 50) = 0 then
            write (Err, NumLine, cr);
      end; {while}
      close (Dest);
      fclose (Source);
      writeln (Err);
      if DestBuf <> nil then
         Dispose (DestBuf);
      writeln ('FINISHED: ', NumLine, ' lines processed.');
   end;
end;                 {ProcessTeXFile}

{ ==================== INITIALIZATION ============================  }
begin
end.
