from gtk import *
from gnome.ui import *
import GdkImlib
import string
import os, os.path, sys
import ConfigParser, gettext

import addressbook_vcard
import utils
import mk_letter 
import error

from main import GTEX_LETTER_VERSION

gettext.bindtextdomain('gtex-letter', '/usr/share/locale')
gettext.textdomain('gtex-letter')
_ = gettext.gettext

VERTICAL = 1
HORIZONTAL = 2

class GUI:

	def __init__ (self, rc, letter):
		self.rc = rc
		self.l = letter

		self.app = GnomeApp ("gtex-letter", "gtex-letter")
		self.app.connect ("destroy", self.quit)
		self.app.connect ("delete_event", self.quit)
		
		try:
			file = utils.get_path("logo.xpm", self.rc.prg_dir)
			if not file: # The problem is GnomeDruidPageStandard. it really wants to have a logo
				raise IOError, 'logo.xpm'
			self.logo = GdkImlib.Image (file)
		except IOError, file:
				print _("Could not find '%s'. Aborting.") % file
				sys.exit()

		try:
			file = utils.get_path("wmark.jpg", self.rc.prg_dir)
			if file:
				self.wmark = GdkImlib.Image (file)
			else:
				self.wmark = None
				raise IOError, 'wmark.jpg'
		except IOError, file:
				print _("Could not find '%s'.") % file

		self.comboopening = GtkCombo()
		self.entryopening = GtkEntry (1024)
		self.openingbuttons = []
		self.openinglabels = []

		for i in self.rc.openingdefaults:
			self.mk_button (i, self.openingbuttons, 
					self.openinglabels, 
					self.entryopening)
	
		self.comboclosing = GtkCombo()
		self.entryclosing = GtkEntry (64)
		self.closingbuttons=[]
		self.closinglabels = []

		for i in self.rc.closingdefaults:
			self.mk_button (i, self.closingbuttons, 
					self.closinglabels, 
					self.entryclosing)

		self.druid = GnomeDruid ()
		self.druid.connect ("cancel", self.quit)

		if self.rc.guilevel == 'beginner':
			self.mk_novice_druid()
		
		elif self.rc.guilevel == 'normal':
			self.mk_intermediate_druid()
		
		elif self.rc.guilevel == 'advanced':
			self.mk_expert_druid()

		
		self.app.set_contents (self.druid)

		self.app.show_all ()
		
	def mk_novice_druid(self):
		if self.rc.splash:
			page = GnomeDruidPageStart ("gtex-letter", self.get_splash_text(),
					self.logo, self.wmark)
			self.druid.add ( page )

		page = GnomeDruidPageStandard (" " + _("Address") + " ", self.logo)
		page.vbox.set_border_width (5)
		page.vbox.pack_start (self.address_frame(), FALSE, FALSE, 5)
		page.connect ("next", self.pageflip, FALSE, FALSE)
		self.druid.add ( page )
		
		page = GnomeDruidPageStandard (" " + _("Subject and Opening") + " ", self.logo)
		page.vbox.set_border_width (5)
		page.vbox.pack_start (self.subject_frame(), FALSE, FALSE, 5)
		page.vbox.pack_start (self.opening_frame_combo(), FALSE, FALSE, 5)
		page.connect ("next", self.pageflip, FALSE, FALSE)
		self.druid.add ( page )
		
		page = GnomeDruidPageStandard (" " + _("Contents and Closing") + " ", self.logo)
		page.vbox.set_border_width (5)
		page.vbox.pack_start (self.contents_frame(), FALSE, FALSE, 5)
		page.vbox.pack_start (self.closing_frame_combo(), FALSE, FALSE, 5)
		page.connect ("next", self.pageflip)
		self.druid.add ( page )
		
		page = GnomeDruidPageStandard (" " + _("Header and Filename") + " ", self.logo)
		page.vbox.set_border_width (5)
		page.vbox.pack_start (self.header_frame(), FALSE, FALSE, 5)
		page.vbox.pack_start (self.filename_frame(), FALSE, FALSE, 5)
		page.connect ("next", self.pageflip, TRUE)
		self.druid.add ( page )
		
		page = GnomeDruidPageStandard (" " + _("Makeup"), self.logo)
		page.vbox.set_border_width (5)
		page.vbox.pack_start (self.latex_frame(page), FALSE, FALSE, 5)
		page.connect ("next", self.pageflip)
		self.druid.add ( page )

		page = GnomeDruidPageFinish (_("Finish gtex-letter"), \
					_("Thankyou for using me."), \
					self.logo, self.wmark)
		page.connect ("finish", self.end_druid)
		self.druid.add ( page )

	def mk_intermediate_druid(self):
		if self.rc.splash:
			page = GnomeDruidPageStart (_("gtex-letter"), self.get_splash_text(),
						self.logo, self.wmark)
			self.druid.add ( page )

		page = GnomeDruidPageStandard (" " + _("Address, Subject and Opening") + " ", self.logo)
		page.vbox.set_border_width (5)
		page.vbox.pack_start (self.address_frame(), FALSE, FALSE, 5)
		page.vbox.pack_start (self.subject_frame(), FALSE, FALSE, 5)
		page.vbox.pack_start (self.opening_frame_buttons(), FALSE, FALSE, 5)
		page.connect ("next", self.pageflip)
		self.druid.add ( page )
		
		page = GnomeDruidPageStandard (" " + _("Contents, Closing, Header and Filename") + " ", self.logo)
		page.vbox.set_border_width (5)
		page.vbox.pack_start (self.contents_frame(), FALSE, FALSE, 5)
		page.vbox.pack_start (self.closing_frame_buttons(), FALSE, FALSE, 5)
		page.vbox.pack_start (self.header_frame(), FALSE, FALSE, 5)
		page.vbox.pack_start (self.filename_frame(), FALSE, FALSE, 5)
		page.connect ("next", self.pageflip, TRUE)
		self.druid.add ( page )
		
		page = GnomeDruidPageStandard (" " + _("Makeup") + " ", self.logo)
		page.vbox.set_border_width (5)
		page.vbox.pack_start (self.latex_frame(page), FALSE, FALSE, 5)
		page.connect ("next", self.pageflip)
		self.druid.add ( page )

		page = GnomeDruidPageFinish ("Finish gtex-letter", \
					"Thankyou for using me.", \
					self.logo, self.wmark)
		page.connect ("finish", self.end_druid)
		self.druid.add ( page )

	def mk_expert_druid(self):
		
		page = GnomeDruidPageStandard (" " + _("All in one big page") + " ", self.logo)
		page.vbox.set_border_width (5)
		page.vbox.set_spacing(10)
		hbox = GtkHBox(spacing = 10)
		hbox.pack_start (self.address_frame(), expand=TRUE, fill=TRUE)
		hbox.pack_start (self.subject_frame(), expand=TRUE, fill=TRUE)
		page.vbox.pack_start (hbox)
		hbox.show()
		hbox = GtkHBox(spacing = 10)
		hbox.pack_start (self.opening_frame_buttons(), expand=TRUE, fill=TRUE)
		hbox.pack_start (self.closing_frame_buttons(), expand=TRUE, fill=TRUE)
		hbox.show()
		page.vbox.pack_start (hbox)
		page.vbox.pack_start (self.contents_frame(HORIZONTAL), expand=TRUE, fill=TRUE)
		hbox = GtkHBox(spacing = 10)
		hbox.pack_start (self.header_frame(HORIZONTAL), expand=TRUE, fill=TRUE)
		hbox.pack_start (self.filename_frame(HORIZONTAL), expand=TRUE, fill=TRUE)
		page.vbox.pack_start (hbox)
		hbox.show()
		page.connect ("next", self.pageflip, TRUE)
		
		
		
		self.druid.add ( page )
		
		page = GnomeDruidPageStandard (" " + _("Makeup") + " ", self.logo)
		page.vbox.set_border_width (5)
		page.vbox.pack_start (self.latex_frame(page), FALSE, FALSE, 5)
		page.connect ("next", self.pageflip)
		self.druid.add ( page )

		page = GnomeDruidPageFinish (_("Finish gtex-letter"), \
					_("Thankyou for using me."), \
					self.logo, self.wmark)
		page.connect ("finish", self.end_druid)
		self.druid.add ( page )
	
	def init_latex_output(self, quite_latex):
		if quite_latex == 0 or not quite_latex \
			or quite_latex == 'no' \
			or quite_latex=='false':
			self.latex_output = ''
		else:
			self.latex_output = '>/dev/null'

	def mk_button(self, text, buttons, labels, entry):
		def cp_text(_button, text, self=self, entry=entry):
			if len(self.l.addresscards) <= 1:
				text = utils.general_mkup_text(self.l, text, self.rc)
			entry.set_text(text)
			
		buttons.append(GtkButton())
		
		simple_text = utils.simplify_txt(text)
		labels.append(GtkLabel(simple_text))
		
		box = GtkHBox()
		box.add(labels[-1])
		labels[-1].show()
		buttons[-1].add(box)
		buttons[-1].show()
		buttons[-1].connect("clicked", cp_text, text)
		
	def mk_entry_with_label(self, box, labeltext, defaulttext=''):
		label = GtkLabel (labeltext)
		entry = GtkEntry (255)
		entry.set_text (defaulttext)
		
		box.pack_start (label, FALSE, FALSE, 5)
		box.pack_start (entry)
		return entry

	def mkup_text(self, text):
		if len(self.l.addresscards) >1:
			return text
		while 1:
			class clause:
				def __init__ (self, clause):
					self.clause=clause
				def key(self):
					if string.find(self.clause, '=') > -1:
						return self.clause[0+2:string.find(self.clause, '=')-2]
				def param(self):
					if string.find(self.clause, '=') > -1:
						return utils.stripmarks(self.clause[string.find(self.clause, '=')+1:string.find(self.clause, ':')])
				def value(self):
					if string.find(self.clause, ':') > -1:
						return utils.stripmarks(self.clause[string.find(self.clause, ':')+1:])
				def check(self, letter, rc):
					try:
						err=FALSE
						if not self.key():
							err=TRUE
						if not self.param():
							err=TRUE
						if not self.value():
							err=TRUE
						if utils.get_attr_by_name(letter, self.key(), rc)==None:
							err=TRUE
						if err:
							raise error.MalformedClause, self.clause
					except error.Malformed.Clause, clause:
						print _("The clause '%s' is malformed. Aborting.") % clause
						sys.exit()
			while 1:
				br_start = string.find(text, "[")
				br_end = string.find(text, "]")	
				try:
					if (br_start>-1 and not br_end > -1) or \
						(br_end >-1 and not br_start >-1) or \
						br_start > br_end:
						raise error.MalformedClause, text
				except error.MalformedClause, clause:
					print _("The clause '%s' is malformed. Aborting.") % clause
					sys.exit()

				if br_start > -1:
					cl = clause(text[br_start+1:br_end])
					cl.check(self.l, self.rc)
					if utils.get_attr_by_name(self.l, cl.key(), rc) == cl.param():
						text = text[0:br_start] + cl.value() + text[br_end+1:]
					else:
						text = text[0:br_start] + text[br_end+1:]
				else:
					break

			start = string.find(text, "__")
			end = string.find(text, "__", start + 1)
			if start == -1:
				break
			
			key = text[start+2:end]
			
			text = string.replace(text, '__' + key + '__', \
				utils.get_attr_by_name(self.l, key), rc)

		return text

	def set_adr(self, entry, string):
		
		entry.freeze()
		num=entry.get_length()
		entry.backward_delete(num)
		entry.insert_defaults(string)
		entry.thaw()
		
		for i in range(0, len(self.openingbuttons)):
			if len(self.l.addresscards) <= 1:
				text = (utils.general_mkup_text(\
					self.l, self.rc.openingdefaults[i], self.rc))
			else:
				text = utils.simplify_txt(self.rc.openingdefaults[i])
			self.openinglabels[i].set_text(text)
		if len(self.l.addresscards) <= 1:
			self.comboopening.set_popdown_strings(map(\
				lambda x, l=self.l, rc=self.rc : \
					utils.general_mkup_text(l, x, rc), \
				self.rc.openingdefaults))
			self.comboclosing.set_popdown_strings(map(\
				lambda x, l=self.l, rc=self.rc : \
					utils.general_mkup_text(l, x, rc), \
				self.rc.closingdefaults))
		else:
			self.comboopening.set_popdown_strings(self.rc.openingdefaults)
			self.comboclosing.set_popdown_strings(self.rc.closingdefaults)


	def quit (self, event = None, data = None):
		mk_letter.rm_latex_files(self.l)
		mainquit ()

	def mainloop (self):
		mainloop ()

	def create_file_selection(_button, self, entry, path=''):
		win = GtkFileSelection(" " + _("Search Files") + " ")
		if path and os.path.isdir(path):
			win.set_filename(path)
		def delete_event(win, event=None):
			win.destroy()
			return TRUE
		def file_selection_ok(_button, fs=win, entry=entry):
			entry.set_text(fs.get_filename())
			fs.destroy()
		win.connect("delete_event", delete_event)
		win.ok_button.connect("clicked", file_selection_ok)
		win.cancel_button.connect("clicked", win.destroy)
		win.show()

	def dir_GtkBox(self, dir, spacing = 10):
		if dir == VERTICAL: return GtkVBox(homogeneous=FALSE, spacing=spacing)
		if dir == HORIZONTAL: return GtkHBox(homogeneous=FALSE, spacing=spacing)

	def get_splash_text(self):
		str = _("Welcome to gtex-letter.") + "\n\n"
		str = str + _("Follow me to make a LaTeX-letter.")
		str = str + "\n\n\n\n"
		str = str + _("This is version") + " " + GTEX_LETTER_VERSION + " " + _("of gtex-letter.") + "\n"
		str = str + _("The") + " '" + self.rc.guilevel + "'" + _("-user-interface is being used.") 
		return str

	
	def address_frame(self, direction = HORIZONTAL):
		frame = GtkFrame (" " + _("Destination-Address") + " ")
		box = self.dir_GtkBox (direction)
		box.set_border_width(10)
		
		self.textadr = GtkText ()
		self.textadr.set_editable (TRUE)
		self.textadr.set_usize(120, -1)

		box2 = GtkVBox (spacing = 2)
		
		swin = GtkScrolledWindow()
		swin.set_policy(POLICY_AUTOMATIC, POLICY_AUTOMATIC)

		swin.show()

		self.textadr.show()
		swin.add(self.textadr)
		box2.add(swin)
		
		box2.show()
		box.add(box2)
		
		if self.l.address:
			self.set_adr(self.textadr, self.l.address)
		
		def search_addressbook(_button, self, text=self.textadr, ):
			ab = addressbook_vcard.addressbook(self.rc.addressbooks, \
					self.rc.addressbook_column_widths, \
					self.rc.addressbook_columns)
			ab.read_file()
			s = ab.show()
			if s:
				str = ''
				self.l.addresscards = []
				for name in s:
					card = ab.get_card(name)
					self.l.addresscards.append(card)
					if str:
						str = str + '\n'
					str = str + utils.mk_adr(card, \
						self.rc.addressformats, \
						self.rc.mycountry)

				self.l.address = str
					
				self.set_adr(text, self.l.address)

		box3 = GtkVBox()
		box3 = GtkVBox (spacing = 20)

		box1 = GtkHButtonBox()
		button = GtkButton(_("Browse Addresses"))
		button.connect("clicked", search_addressbook, self)
		box1.pack_start (button)
		box1.show()
		box3.pack_start(box1)
		
		label = GtkLabel(_("Divide multiple\naddresses by\nempty lines."))
		label.show()
		box3.add(label)
		
		box.pack_start(box3)
		box3.show()
		
		frame.add (box)
		return frame
	
	def header_frame(self, direction = HORIZONTAL):
		frame = GtkFrame (" " + _("Header-File") + " ")
		box = self.dir_GtkBox (direction)
		box.set_border_width(10)
		label = GtkLabel (_("Filename:"))
		box.pack_start (label, FALSE, FALSE, 5)
		
		combo = GtkCombo()
		combo.entry.set_max_length(100)
		self.entryheader = combo.entry
		combo.set_popdown_strings(self.rc.headerdefaults)
		if self.l.header:
			combo.entry.set_text(self.l.header)
		combo.set_use_arrows_always(1)
		combo.show()
		box.pack_start(combo)
		
		button = GtkButton(_("Search"))
		button.connect("clicked", self.create_file_selection, self.entryheader, self.rc.filename_guess_path)
		box.pack_start (button)

		frame.add (box)
		return frame
	
	def filename_frame(self, direction = HORIZONTAL):
		frame = GtkFrame (" " + _("LaTeX-File (this is where the letter is saved)") + " ")
		box = self.dir_GtkBox (direction)
		box.set_border_width(10)
		self.entryfilename = self.mk_entry_with_label(box, _('Filename:'), \
			self.l.filename)
		button = GtkButton(_("Search"))
		button.connect("clicked", self.create_file_selection, self.entryfilename, self.rc.filename_guess_path)
		box.pack_start (button)

		frame.add (box)
		return frame

	def opening_frame_combo (self, direction = HORIZONTAL):
		frame = GtkFrame (" " + _("Opening") + " ")
		box = self.dir_GtkBox (direction)
		box.set_border_width(10)
		label = GtkLabel (_("Opening:"))
		box.pack_start (label, FALSE, FALSE, 5)
		
		self.comboopening = GtkCombo()
		self.comboopening.entry.set_max_length(100)
		self.entryopening = self.comboopening.entry
		if len(self.l.addresscards) <= 1:
			self.comboopening.set_popdown_strings(map(\
				lambda x, l=self.l, rc=self.rc : \
					utils.general_mkup_text(l, x, rc), \
				self.rc.openingdefaults))
		else:
			self.comboopening.set_popdown_strings(self.rc.openingdefaults)
			
		if self.l.opening:
			self.comboopening.entry.set_text(self.l.opening)
		self.comboopening.set_use_arrows_always(1)
		self.comboopening.show()
		box.pack_start(self.comboopening)

		frame.add (box)
		return frame

	def closing_frame_combo (self, direction = HORIZONTAL):
		frame = GtkFrame (" " + _("Closing") + " ")
		box = self.dir_GtkBox (direction, spacing = 1)
		box.set_border_width(10)
		label = GtkLabel (_("Closing:"))
		box.pack_start (label, FALSE, FALSE, 5)
		
		self.comboclosing = GtkCombo()
		self.comboclosing.entry.set_max_length(100)
		self.entryclosing = self.comboclosing.entry
		if len(self.l.addresscards) <= 1:
			self.comboclosing.set_popdown_strings(map(\
				lambda x, l=self.l, rc=self.rc : \
					utils.general_mkup_text(l, x, rc), \
				self.rc.closingdefaults))
		else:
			self.comboclosing.set_popdown_strings(self.rc.closingdefaults)

		if self.l.closing:
			self.comboclosing.entry.set_text(self.l.closing)
		self.comboclosing.set_use_arrows_always(1)
		self.comboclosing.show()
		box.pack_start(self.comboclosing)

		frame.add (box)
		return frame

	def opening_frame_buttons (self, direction = HORIZONTAL ):
		frame = GtkFrame (" " + _("Opening") + " ")
		box1 = self.dir_GtkBox (direction)
		boxV1 = GtkVButtonBox ()
		boxV1.set_spacing(1)
		boxV1.set_layout(BUTTONBOX_SPREAD)
		boxV1.queue_resize()
		boxV1.set_border_width (5)
		boxV2 = GtkVBox ()
		boxV2.set_border_width (5)
		for button in self.openingbuttons:
			boxV1.pack_start(button)
		
		label = GtkLabel (_("Opening"))
		label.set_justify (JUSTIFY_LEFT)
		boxV2.pack_start(label)
		
		if self.l.opening:
			self.entryopening.set_text(self.l.opening)
		else:
			default=self.rc.openingdefaults[0]
			self.entryopening.set_text (utils.general_mkup_text(\
				self.l, default, self.rc))
		boxV2.pack_start(self.entryopening)

		box1.add (boxV1)
		box1.add (boxV2)
		
		frame.add (box1)
		return frame
	
	def closing_frame_buttons(self, direction = HORIZONTAL):
		frame = GtkFrame (" " + _("Closing") + " ")
		box1 = self.dir_GtkBox (direction)
		boxV1 = GtkVButtonBox ()
		boxV1.set_spacing(1)
		boxV1.set_layout(BUTTONBOX_SPREAD)
		boxV1.queue_resize()
		boxV1.set_border_width (5)
		boxV2 = GtkVBox ()
		boxV2.set_border_width (5)

		for button in self.closingbuttons:
			boxV1.pack_start(button)
		
		label = GtkLabel (_("Closing"))
		label.set_justify (JUSTIFY_LEFT)
		boxV2.pack_start(label)
		
		if self.l.closing:
			self.entryclosing.set_text(self.l.closing)
		else:
			default=self.rc.closingdefaults[0]
			self.entryclosing.set_text (default)
		boxV2.pack_start(self.entryclosing)
		
		box1.add (boxV1)
		box1.add (boxV2)
		
		frame.add (box1)
		return frame
	
	def subject_frame(self, direction = HORIZONTAL):
		frame = GtkFrame (" " + _("Subject") + " ")
		box = self.dir_GtkBox (direction)
		box.set_border_width (5)

		self.entrysubject = self.mk_entry_with_label(box, _('Subject') + ':')
		if self.l.subject:
			self.entrysubject.set_text(self.l.subject)

		frame.add(box)
		return frame	
	
	def contents_frame(self, direction = VERTICAL):
		def import_textfile(_button, self):
			win = GtkFileSelection(" " + _("Import File") + " ")
			def delete_event(win, event=None):
				win.destroy()
				return TRUE
			win.connect("delete_event", delete_event)
			def file_selection_ok(_button, fs=win, self=self):
				filename = fs.get_filename()
				if not os.path.isfile(filename):
					print _("error: file does not exist")
				else:
					file = open(filename, "r")
					text = file.read()
					self.contentsfield.insert_defaults(text)
					file.close()
				fs.destroy()

			win.ok_button.connect("clicked", file_selection_ok)
			win.cancel_button.connect("clicked", win.destroy)
			win.show()

		def save_textfile(_button, self):
			win = GtkFileSelection(" " + _("Export File") + " ")
			def delete_event(win, event=None):
				win.destroy()
				return TRUE
			win.connect("delete_event", delete_event)

			def file_selection_ok(_button, fs=win, self=self):
				try:
					filename = fs.get_filename()
					if os.path.isfile(filename):
						raise error.FileExists, filename
				except error.FileExists, file:
						print "File '%s' exists. It will be overwritten."  % file

				file = open(filename, "w")
				l = self.contentsfield.get_length ()
				text = self.contentsfield.get_chars (0, l)
				file.write(text)
				file.close()
				fs.destroy()

			win.ok_button.connect("clicked", file_selection_ok)
			win.cancel_button.connect("clicked", win.destroy)
			win.show()

		frame = GtkFrame (" " + _("Contents") + " ")
		box = self.dir_GtkBox (direction)
		box.set_border_width (5)

		self.contentsfield = GtkText ()
		self.contentsfield.set_editable (TRUE)
		self.contentsfield.insert_defaults(self.l.contents)
		box.pack_start (self.contentsfield)

		if direction == HORIZONTAL:
			box1 = GtkVButtonBox()
		else:
			box1 = GtkHButtonBox()
		
		box1.set_usize(10, -1)
		box1.set_layout(BUTTONBOX_SPREAD)
		box1.queue_resize()

		button = GtkButton(_("Import Textfile"))
		button.connect("clicked", import_textfile, self)
		box1.pack_start (button)
		button = GtkButton(_("Save Contents"))
		button.connect("clicked", save_textfile, self)
		box1.pack_start (button)

		box.pack_start(box1)
		box1.show()

		frame.add (box)
		return frame
	
	def latex_frame(self, page):
		frame = GtkFrame (" " + _("LaTeX") + " ")
		box = GtkHBox ()
		box.set_usize(280, -1)

		def mk_tex_xdvi(self, widget, event=None, data = None):
			if widget.l.letter_written:
				mk_letter.tex_latex(widget.l, widget.rc)
				mk_letter.tex_xdvi(widget.l, widget.rc)
			else:
				print _("Error: No letter written so far. Can not show.")
		def mk_tex_pdf(self, widget, event=None, data = None):
			if widget.l.letter_written:
				mk_letter.tex_latex(widget.l, widget.rc)
				mk_letter.tex_pdf(widget.l, widget.rc)
			else:
				print _("error: no letter written so far. Can not convert.")
		def mk_tex_print(self, widget, event=None, data = None):
			if widget.l.letter_written:
				mk_letter.tex_latex(widget.l, widget.rc)
				mk_letter.tex_print(widget.l, widget.rc)
			else:
				print _("error: no letter written so far. Can not print.")
		def mk_tex_postscript(self, widget, event=None, data = None):
			if widget.l.letter_written:
				mk_letter.tex_latex(widget.l, widget.rc)
				mk_letter.tex_postscript(widget.l, widget.rc)
			else:
				print _("error: no letter written so far. Can not convert.")
		def continue_editor(self, widget, event=None, data = None):
			if widget.l.letter_written:
				mk_letter.continue_editor(widget.l, widget.rc)
			else:
				print _("error: no letter written so far. Can not open file.")
		bbox = GtkHButtonBox()
		
		table = GtkTable(5, 5)
		bbox.pack_start(table)
		table.show()
		bbox.show()
		box.pack_start(bbox)

		boxV = GtkVButtonBox()
		boxV.show()
		button = GtkButton(_("show letter"))
		boxV.pack_start (button)
		button.connect("clicked", mk_tex_xdvi, self)
		table.attach(boxV, 1,2, 2,3, xoptions=FILL, yoptions=FILL, xpadding=5, ypadding=5)
		
		boxV = GtkVButtonBox()
		boxV.show()
		button = GtkButton(_("save as\npostscript"))
		boxV.pack_start (button)
		button.connect("clicked", mk_tex_postscript, self)
		table.attach(boxV, 2,3, 1,2, xoptions=FILL, yoptions=FILL, xpadding=5, ypadding=5)

		boxV = GtkVButtonBox()
		boxV.show()
		button = GtkButton()

		file = utils.get_path("print.xpm", self.rc.prg_dir)
		try:
				if file:
					pix, mask = create_pixmap_from_xpm(page, None, file)		
					buttonpix = GtkPixmap(pix, mask)
					buttonpix.show()
					pixbox = GtkHBox()
					pixbox.add(buttonpix)
					button.add(pixbox)
					pixbox.show()
				else:
					raise IOError, 'print.xpm'
		except IOError, file:
					print _("Could not find the file '%s'. Text substituted.") % file
					label = GtkLabel(_("Print"))
					label.show()
					button.add(label)
		
		boxV.pack_start (button)
		button.connect("clicked", mk_tex_print, self)
		table.attach(boxV, 2,3, 2,3, xoptions=FILL, yoptions=FILL, xpadding=5, ypadding=5)
	
		boxV = GtkVButtonBox()
		boxV.show()
		button = GtkButton(_("save as\npdf"))
		boxV.pack_start (button)
		button.connect("clicked", mk_tex_pdf, self)
		table.attach(boxV, 2,3, 3,4, xoptions=FILL, yoptions=FILL, xpadding=5, ypadding=5)
		
		boxV = GtkVButtonBox()
		boxV.show()
		editorbutton = GtkButton(_("Continue\nwith editor"))
		boxV.pack_start (editorbutton)
		editorbutton.connect("clicked", continue_editor, self)
		table.attach(boxV, 3,4, 2,3, xoptions=FILL, yoptions=FILL, xpadding=5, ypadding=5)

		frame.add (box)
		return frame

	def get_letter (self, event = None, data = None):
		l = self.textadr.get_length ()
		self.l.address = self.textadr.get_chars (0, l)
		self.l.address_slashes = utils.add_slashes (self.l.address)
		self.l.opening = self.entryopening.get_chars (0, 256)
		self.l.closing = self.entryclosing.get_chars (0, 256)
		self.l.filename = self.entryfilename.get_chars (0, 256)
		self.l.path = utils.get_path_from_file(self.l.filename)

		self.l.header = self.entryheader.get_chars (0, 256)	
		save = self.l.header
		try:
			if self.l.header[-4:] <> '.tex': 
				self.l.header = self.l.header + '.tex' 
			self.l.header = utils.get_path(self.l.header, self.rc.prg_dir)
			if self.l.header:
				if not os.path.split(self.l.header)[0]: # if header is still local, we make it absolute
					self.l.header = os.path.join(os.getcwd(), \
							self.l.header)
			else:
				raise IOError, save
		except IOError, file:
			print "Submitted headerfile '%s' not found. No header used." % file
			self.l.header = ''
			
		self.l.subject = self.entrysubject.get_chars (0, 256)
		
		l = self.contentsfield.get_length ()
		self.l.contents = self.contentsfield.get_chars (0, l)
	
	def write_letter(self):
		self.l.letter_written = not mk_letter.write_file(self.l, self.rc)


	def pageflip (self, event = None, data = None, write_letter=FALSE, guess_filename=TRUE):
		self.get_letter()
		if guess_filename and not self.l.filename and not self.entryfilename.get_chars (0, 256):
			self.l.filename = utils.guess_filename(self.l, self.rc)
			if self.l.filename:
				self.entryfilename.set_text(self.l.filename)
		if write_letter:
			self.write_letter()
		
	def end_druid (self, event = None, data = None):
		mk_letter.rm_latex_files(self.l)
		self.quit (event, data)

