/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import org.mariadb.jdbc.MySQLConnection;

public class MySQLPooledConnection
implements PooledConnection {
    MySQLConnection connection;
    List<ConnectionEventListener> connectionEventListeners;
    List<StatementEventListener> statementEventListeners;

    public MySQLPooledConnection(MySQLConnection connection) {
        this.connection = connection;
        connection.pooledConnection = this;
        this.statementEventListeners = new ArrayList<StatementEventListener>();
        this.connectionEventListeners = new ArrayList<ConnectionEventListener>();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public void close() throws SQLException {
        this.connection.pooledConnection = null;
        this.connection.close();
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.add(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.remove(listener);
    }

    public void fireStatementClosed(Statement st) {
        if (st instanceof PreparedStatement) {
            StatementEvent event = new StatementEvent(this, (PreparedStatement)st);
            for (StatementEventListener listener : this.statementEventListeners) {
                listener.statementClosed(event);
            }
        }
    }

    public void fireStatementErrorOccured(Statement st, SQLException e) {
        if (st instanceof PreparedStatement) {
            StatementEvent event = new StatementEvent(this, (PreparedStatement)st, e);
            for (StatementEventListener listener : this.statementEventListeners) {
                listener.statementErrorOccurred(event);
            }
        }
    }

    public void fireConnectionClosed() {
        ConnectionEvent event = new ConnectionEvent(this);
        CopyOnWriteArrayList<ConnectionEventListener> copyListeners = new CopyOnWriteArrayList<ConnectionEventListener>(this.connectionEventListeners);
        for (ConnectionEventListener listener : copyListeners) {
            listener.connectionClosed(event);
        }
    }

    public void fireConnectionErrorOccured(SQLException e) {
        ConnectionEvent event = new ConnectionEvent(this, e);
        for (ConnectionEventListener listener : this.connectionEventListeners) {
            listener.connectionErrorOccurred(event);
        }
    }
}

