/*
 * SOURCE:  profile.c
 * PROJECT: EasyTeX
 *
 * PURPOSE: initialization file routines
 *
 * UPDATES: 08/15/1991 - major rewrite
 *
 * (c)M.Schollmeyer
 */
#include "main.h"

void *profiledesc[MAXPROFILEENTRIES];

long profnull = 0L;      // can be used as default to return null

unsigned int virtfiles[] = { 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 ,35 ,36,
                             37, 38, 39, 40, 41, 42, 43, 44, 65, 102, 164, 0 };

/* GetProfileData() and PutProfileData reside in init.c */



/*
 *    Name: GetProfileData
 *  Return: a pointer to the requested data
 * Purpose: this routine is  used to read data from the
 *          profile memory.
 *
 *
 * (c)M.Schollmeyer
 */
void *GetProfileData( unsigned int slot, void *def ) {

    if( slot > MAXPROFILEENTRIES )
        return NULL;

    if( profiledesc[slot] )
        return profiledesc[slot];

    return def;
}


/*
 *    Name: PutprofileData
 *  Return: TRUE if successful, FALSE if not
 * Purpose: Stores profile data in memory and erases old entries.
 *
 *
 *
 * (c)M.Schollmeyer
 */
BOOL PutProfileData( unsigned int slot, void *data, int size ) {

    void *eptr = NULL;
    int   ret  = FALSE;

    if( slot > MAXPROFILEENTRIES )
        return FALSE;

    /* for less heap fragmentation, we'd better free first and then
       allocate a new heap entry, but if the allocation fails, we
       still have the old entry by first allocation and then freeing
       the old one.
     */

    /* if data is passed, try to get heap space for it */
    if( data ) {
        if( !(eptr = AllocHeap( size )) )
            goto done;

        memcpy( eptr, data, size );
    }

    /* look if there is an old entry */
    if( profiledesc[slot] )
        free( profiledesc[slot] );

    profiledesc[slot] = eptr;

    ret = TRUE;
done:
    return ret;
}


/*
 *    Name: SwapProfileData
 *  Return: void
 * Purpose: Swaps the entry of two slots.
 *          (useful for sorting...)
 *
 *
 * (c)M.Schollmeyer
 */
void SwapProfileData( unsigned int slot1, unsigned int slot2 ) {

    void *save;

    save = profiledesc[slot1];
    profiledesc[slot1] = profiledesc[slot2];
    profiledesc[slot2] = save;
}


/* end of file profile.c */
