/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.runtime;

import java.util.ArrayList;
import java.util.TooManyListenersException;
import org.ascape.model.Scape;
import org.ascape.model.event.DefaultScapeListener;
import org.ascape.model.event.ScapeEvent;
import org.ascape.model.event.ScapeListener;
import org.ascape.view.nonvis.ConsoleOutView;

public class RuntimeEnvironment
extends DefaultScapeListener {
    private static final long serialVersionUID = -4376665907245552553L;
    private ConsoleOutView consoleOutView;
    transient ArrayList environmentViews = new ArrayList();

    public RuntimeEnvironment() {
        this.setConsole(new ConsoleOutView());
        this.showConsoleNotice();
    }

    public void addView(ScapeListener view, boolean createFrame) {
        if (view.getScape() == null && !view.isLifeOfScape() && this.getScape() != null) {
            this.getScape().addView(view, false);
        }
        if (!view.isLifeOfScape()) {
            this.environmentViews.add(view);
        }
    }

    public void addView(ScapeListener view) {
        this.addView(view, true);
    }

    public void addViews(ScapeListener[] views) {
        this.addViews(views, true);
    }

    public void addViews(ScapeListener[] views, boolean createFrame) {
        ScapeListener[] componentViews = new ScapeListener[views.length];
        System.arraycopy(views, 0, componentViews, 0, componentViews.length);
        int i = 0;
        while (i < componentViews.length) {
            ScapeListener componentView = componentViews[i];
            if (!componentView.isLifeOfScape()) {
                this.environmentViews.add(componentView);
            }
            if (componentView.getScape() == null) {
                if (!componentView.isLifeOfScape()) {
                    if (this.getScape() != null) {
                        this.getScape().addView(componentView, false);
                    }
                } else {
                    throw new Error("Tried to add a scape specific view directly to the user environment. Use scape.addView() instead.");
                }
            }
            ++i;
        }
    }

    public void removeView(ScapeListener view) {
        if (!view.isLifeOfScape()) {
            this.environmentViews.remove(view);
        }
    }

    public void removeViews(ScapeListener[] views) {
        int i = 0;
        while (i < views.length) {
            ScapeListener view = views[i];
            this.removeView(view);
            ++i;
        }
    }

    public void environmentQuiting(ScapeEvent scapeEvent) {
        this.scape = null;
    }

    public void quit() {
        if (this.getScape() != null) {
            this.getScape().getRunner().quit();
        } else {
            int i = 0;
            while (i < this.environmentViews.size()) {
                ScapeListener scapeListener = (ScapeListener)this.environmentViews.get(i);
                scapeListener.environmentQuiting(new ScapeEvent(this, -3));
                ++i;
            }
            RuntimeEnvironment.exit();
        }
    }

    public static void exit() {
        try {
            System.exit(0);
        }
        catch (SecurityException e) {
            System.out.println("Can't quit in this security context. (Scape is probably running in browser or viewer; quit or change that.)");
        }
    }

    public void scapeAdded(ScapeEvent scapeEvent) throws TooManyListenersException {
        this.scape = (Scape)scapeEvent.getSource();
        int i = 0;
        while (i < this.environmentViews.size()) {
            ScapeListener scapeListener = (ScapeListener)this.environmentViews.get(i);
            ((Scape)scapeEvent.getSource()).addView(scapeListener, false);
            ++i;
        }
        this.getConsole().setName(this.scape + " Standard (Text) Output");
        ((Scape)scapeEvent.getSource()).addView(this.getConsole());
    }

    public ConsoleOutView getConsole() {
        return this.consoleOutView;
    }

    public void setConsole(ConsoleOutView consoleOutView) {
        this.consoleOutView = consoleOutView;
    }

    public ArrayList getEnvironmentViews() {
        return this.environmentViews;
    }

    private void showConsoleNotice() {
        this.getConsole().println();
        this.getConsole().println("Ascape");
        this.getConsole().println("An agent-based modeling framework and runtime environment.");
        this.getConsole().println("Design and development: Miles T. Parker");
        this.getConsole().println("Additional development: Mario Inchiosa, Josh Miller and others");
        this.getConsole().println();
        this.getConsole().println("Copyright 1998-2007 The Brookings Institution, NuTech Solutions,Inc., Metascape LLC, and contributors.");
        this.getConsole().println("All rights reserved.");
        this.getConsole().println("This program and the accompanying materials are made available solely under");
        this.getConsole().println("the incliude BSD license 'ascape-license.txt'.");
        this.getConsole().println("Any referenced or included libraries carry licenses of their respective copyright holders.");
        this.getConsole().println();
        this.getConsole().println("THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS");
        this.getConsole().println("'AS IS' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT");
        this.getConsole().println("LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR");
        this.getConsole().println("A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR");
        this.getConsole().println("CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,");
        this.getConsole().println("EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,");
        this.getConsole().println("PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR");
        this.getConsole().println("PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF");
        this.getConsole().println("LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING");
        this.getConsole().println("NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS");
        this.getConsole().println("SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. ");
        this.getConsole().println();
    }
}

