/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.testing.ide;

import java.util.Date;
import org.ascape.util.data.DataSeries;
import org.eclipse.amp.amf.abase.IInterpreterProvider;
import org.eclipse.amp.amf.abase.aBase.Value;
import org.eclipse.amp.amf.parameters.AParInterpreter;
import org.eclipse.amp.amf.parameters.aPar.AParFactory;
import org.eclipse.amp.amf.parameters.aPar.Import;
import org.eclipse.amp.amf.parameters.aPar.Model;
import org.eclipse.amp.amf.parameters.aPar.Parameter;
import org.eclipse.amp.amf.parameters.aPar.SingleParameter;
import org.eclipse.amp.amf.testing.ATestInterpreter;
import org.eclipse.amp.amf.testing.aTest.ATestFactory;
import org.eclipse.amp.amf.testing.aTest.Constraint;
import org.eclipse.amp.amf.testing.ares.ConstraintTest;
import org.eclipse.amp.amf.testing.ares.Issue;
import org.eclipse.amp.amf.testing.ares.ResultType;
import org.eclipse.amp.amf.testing.ares.Run;
import org.eclipse.amp.amf.testing.ares.RunSet;
import org.eclipse.amp.amf.testing.ares.impl.AresFactoryImpl;
import org.eclipse.amp.amf.testing.ide.TestRunSet;
import org.eclipse.amp.escape.ide.EclipseEscapeRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.metaabm.SAttributeType;
import org.metaabm.SContext;

public class TestRun {
    EclipseEscapeRunner runner;
    private Run run;
    private boolean success;
    private RunSet runSet;
    private IProject project;
    private TestRunSet testRunSet;
    private Resource aTestEMFResource;
    private org.eclipse.amp.amf.testing.aTest.Model aTest;
    private AParInterpreter aParInterpreter;
    private Model aPar;
    private SContext rootContext;
    private IInterpreterProvider aParPool;
    boolean loading;
    private IProgressMonitor parentMonitor;
    private MultiStatus status;
    private boolean cancelled;

    public TestRun(TestRunSet testRunSet, RunSet runSet, IProject project, Resource atestResource, IInterpreterProvider aParPool) {
        this.testRunSet = testRunSet;
        this.runSet = runSet;
        this.project = project;
        this.aTestEMFResource = atestResource;
        this.aParPool = aParPool;
    }

    private void loadInterpreter() {
        this.loading = true;
        Job loadTest = new Job("Load " + this.aTestEMFResource.getURI().trimFileExtension().lastSegment()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    TestRun.this.loadTest();
                    TestRun.this.run = AresFactoryImpl.eINSTANCE.createRun();
                    TestRun.this.run.setResult(ResultType.INCOMPLETE);
                    TestRun.this.run.setParameterization(TestRun.this.aPar);
                    TestRun.this.run.setModel(TestRun.this.rootContext);
                    for (Constraint constraint : TestRun.this.aTest.getContraints()) {
                        Constraint shallowCopy = ATestFactory.eINSTANCE.createConstraint();
                        shallowCopy.setAgent(constraint.getAgent());
                        shallowCopy.setAttribute(constraint.getAttribute());
                        shallowCopy.setMaxValue((Value)EcoreUtil.copy((EObject)constraint.getMaxValue()));
                        shallowCopy.setMinValue((Value)EcoreUtil.copy((EObject)constraint.getMinValue()));
                        shallowCopy.setMeasure(constraint.getMeasure());
                        shallowCopy.setQualifier(constraint.getQualifier());
                        TestRun.this.run.getConstraints().add((Object)shallowCopy);
                    }
                    for (Parameter param : TestRun.this.aPar.getParameters()) {
                        if (!(param instanceof SingleParameter)) continue;
                        SingleParameter sp = (SingleParameter)param;
                        SingleParameter shallowCopy = AParFactory.eINSTANCE.createSingleParameter();
                        shallowCopy.setAttribute(sp.getAttribute());
                        shallowCopy.setValue((Value)EcoreUtil.copy((EObject)sp.getValue()));
                        TestRun.this.run.getParameters().add((Object)shallowCopy);
                    }
                    TestRun.this.run.setTest(TestRun.this.aTest);
                    TestRun.this.run.setStarted(new Date());
                    TestRun.this.run.setResult(ResultType.INCOMPLETE);
                    TestRun.this.loading = false;
                    if (monitor.isCanceled()) {
                        TestRun.this.cancelled = true;
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
                catch (RuntimeException e) {
                    TestRun.this.testRunSet.testComplete(TestRun.this, e);
                    TestRun.this.cancelled = true;
                    return new Status(4, "org.eclipse.amp.escape.testing.ide", "Couldn't load interpreter file for " + TestRun.this.aTestEMFResource.getURI(), (Throwable)e);
                }
            }
        };
        loadTest.setPriority(30);
        loadTest.schedule();
        while (this.loading) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void loadTest() {
        this.aTest = (org.eclipse.amp.amf.testing.aTest.Model)this.aTestEMFResource.getContents().get(0);
        URI aparURI = ATestInterpreter.getParameterURI((Resource)this.aTestEMFResource);
        Resource aparAnalog = this.testRunSet.getResourceSet().getResource(aparURI, true);
        if (aparAnalog == null) {
            StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.amp.amf.parameters", "Couldn't locate apar resource."));
        } else {
            this.aParInterpreter = (AParInterpreter)this.aParPool.getInterpreter(aparURI);
            this.aPar = this.aParInterpreter.getModel();
            Resource agentModelResource = this.testRunSet.getResourceSet().getResource(URI.createURI((String)AParInterpreter.convertURI((Import)this.aPar.getModel()), (boolean)true), true);
            this.rootContext = (SContext)agentModelResource.getContents().get(0);
        }
    }

    private void run() {
        this.runner = new EclipseEscapeRunner(){
            private static final long serialVersionUID = 1L;

            protected synchronized void runMainLoop() {
                try {
                    super.runMainLoop();
                    if (!TestRun.this.parentMonitor.isCanceled() && this.getMonitor() != null && !this.getMonitor().isCanceled()) {
                        TestRun.this.evaluateTest();
                    }
                    this.close();
                    TestRun.this.testRunSet.testComplete(TestRun.this, null);
                }
                catch (Error e) {
                    TestRun.this.run.setResult(ResultType.ERROR);
                    this.close();
                    TestRun.this.testRunSet.testComplete(TestRun.this, e);
                }
                catch (RuntimeException e) {
                    TestRun.this.run.setResult(ResultType.ERROR);
                    this.close();
                    TestRun.this.testRunSet.testComplete(TestRun.this, e);
                }
            }

            public void openImplementation(String[] args, boolean block) {
                TestRun.this.aParInterpreter.assignValues(new Object[]{this.getRootScape(), this}, TestRun.this.status);
                super.openImplementation(args, block);
            }
        };
        new MonitorParentStatus("Watch Run Set Monitor").start();
        this.runner.setAutoRestart(false);
        this.runner.open((IResource)this.project, this.rootContext.getImplementation().getQualifiedName(), this.aTest.eResource().getURI().trimFileExtension().lastSegment(), new String[0], false);
    }

    protected void runTest(IProgressMonitor parentMonitor, MultiStatus status, boolean block) {
        this.parentMonitor = parentMonitor;
        this.status = status;
        this.loadInterpreter();
        if (!this.cancelled && !parentMonitor.isCanceled()) {
            this.run();
        }
    }

    private void evaluateTest() {
        this.success = true;
        for (Constraint constraint : this.run.getConstraints()) {
            String constraintName = String.valueOf(constraint.getMeasure().getLiteral()) + " " + constraint.getAgent().getLabel() + " ";
            if (constraint.getQualifier() != null) {
                constraintName = String.valueOf(constraintName) + constraint.getQualifier().getLabel() + " ";
            }
            if (constraint.getAttribute().getSType() == SAttributeType.BOOLEAN_LITERAL) {
                constraintName = String.valueOf(constraintName) + "is ";
            }
            constraintName = String.valueOf(constraintName) + constraint.getAttribute().getLabel();
            int seriesIndex = this.runner.getData().getIndexOfSeries(constraintName);
            if (seriesIndex >= 0) {
                DataSeries ds = this.runner.getData().getSeries(constraintName);
                if (ds != null) {
                    if (ds.getValue() < ATestInterpreter.doubleValue((EObject)constraint.getMinValue())) {
                        this.result(constraint, Issue.BELOW_RANGE, ds.getValue());
                        continue;
                    }
                    if (ds.getValue() > ATestInterpreter.doubleValue((EObject)constraint.getMaxValue())) {
                        this.result(constraint, Issue.ABOVE_RANGE, ds.getValue());
                        continue;
                    }
                    this.result(constraint, Issue.NONE, ds.getValue());
                    continue;
                }
                this.result(constraint, Issue.NOT_FOUND, Double.NaN);
                continue;
            }
            this.status.add((IStatus)new Status(4, "org.eclipse.amp.amf.testing", "Data Series not found for:" + constraintName));
            this.result(constraint, Issue.NOT_FOUND, Double.NaN);
        }
        if (this.success) {
            this.run.setResult(ResultType.SUCCESS);
        } else {
            this.run.setResult(ResultType.FAILURE);
        }
        this.run.setFinished(new Date());
    }

    private void result(Constraint constraint, Issue issue, double value) {
        ConstraintTest res = AresFactoryImpl.eINSTANCE.createConstraintTest();
        this.run.getResults().add((Object)res);
        res.setConstraint(constraint);
        res.setActualValue(value);
        res.setIssue(issue);
        if (issue != Issue.NONE) {
            this.success = false;
        }
    }

    public Run getRun() {
        return this.run;
    }

    private final class MonitorParentStatus
    extends Thread {
        private MonitorParentStatus(String name) {
            super(name);
        }

        public void run() {
            while (!TestRun.this.runner.isRunning()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            while (TestRun.this.runner.isRunning()) {
                if (TestRun.this.parentMonitor.isCanceled() && !TestRun.this.runner.isCloseRequested()) {
                    TestRun.this.runner.close();
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

