/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.validation.validators;

import java.util.List;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.modeler.core.validation.validators.AbstractBpmn2ElementValidator;
import org.eclipse.bpmn2.modeler.core.validation.validators.ProcessValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.IValidationContext;

public class ItemAwareElementValidator
extends AbstractBpmn2ElementValidator<ItemAwareElement> {
    public ItemAwareElementValidator(IValidationContext ctx) {
        super(ctx);
    }

    public ItemAwareElementValidator(AbstractBpmn2ElementValidator parent) {
        super(parent);
    }

    @Override
    public IStatus validate(ItemAwareElement object) {
        if (ProcessValidator.isContainingProcessExecutable((EObject)object) && ItemAwareElementValidator.isEmpty(object.getItemSubjectRef())) {
            EObject container = object.eContainer();
            if (container instanceof InputOutputSpecification) {
                container = container.eContainer();
            }
            EStructuralFeature doaFeature = container.eClass().getEStructuralFeature("dataOutputAssociation");
            EStructuralFeature diaFeature = container.eClass().getEStructuralFeature("dataInputAssociation");
            if (object instanceof DataOutput) {
                if (doaFeature != null) {
                    for (DataOutputAssociation doa : (List)container.eGet(doaFeature)) {
                        ItemAwareElement target;
                        if (!doa.getSourceRef().contains(object) || (target = doa.getTargetRef()) == null) continue;
                        return this.getResult();
                    }
                }
            } else if (object instanceof DataInput && diaFeature != null) {
                for (DataInputAssociation dia : (List)container.eGet(diaFeature)) {
                    if (dia.getTargetRef() != object) continue;
                    for (ItemAwareElement source : dia.getSourceRef()) {
                        if (source == null) continue;
                        return this.getResult();
                    }
                }
            }
            this.addMissingFeatureStatus((EObject)object, "itemSubjectRef", new EObject[]{container}, 4);
        }
        return this.getResult();
    }
}

