/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.handler.reqif;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.handlers.AbstractArtifactHandler;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.handler.reqif.preferences.ReqifPreferences;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecRelation;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;

public class ReqIfHandler
extends AbstractArtifactHandler<SpecHierarchy> {
    public EObject createWrapper(SpecHierarchy spec, EObject artifactModel) {
        return spec;
    }

    public SpecHierarchy resolveWrapper(EObject wrapper) {
        return (SpecHierarchy)wrapper;
    }

    public String getDisplayName(SpecHierarchy spec) {
        IEclipsePreferences preference = ReqifPreferences.getPreferences();
        String idAttribute = preference.get("", "ID");
        SpecObject specObject = spec.getObject();
        if (specObject != null) {
            AttributeValue attributeValue = ReqIF10Util.getAttributeValueForLabel((SpecElementWithAttributes)specObject, (String)idAttribute);
            if (attributeValue != null) {
                return ReqIF10Util.getTheValue((AttributeValue)attributeValue).toString();
            }
            AttributeValue defaultAttributeValue = (AttributeValue)specObject.getValues().get(0);
            return ReqIF10Util.getTheValue((AttributeValue)defaultAttributeValue).toString();
        }
        return "";
    }

    public String generateMarkerMessage(IResourceDelta delta, String wrapperUri) {
        return null;
    }

    public List<Connection> getInternalLinks(EObject investigatedElement, List<String> selectedRelationshipTypes) {
        if (investigatedElement instanceof SpecHierarchy) {
            SpecHierarchy spec = (SpecHierarchy)investigatedElement;
            EList specRelations = ReqIF10Util.getReqIF((Object)spec).getCoreContent().getSpecRelations();
            EList specifications = ReqIF10Util.getReqIF((Object)spec).getCoreContent().getSpecifications();
            List relevantRelations = specRelations.stream().filter(r -> r.getSource().equals(spec.getObject()) || r.getTarget().equals(spec.getObject())).collect(Collectors.toList());
            ArrayList<Connection> connections = new ArrayList<Connection>();
            for (SpecRelation r2 : relevantRelations) {
                ArrayList<SpecHierarchy> targets = new ArrayList<SpecHierarchy>();
                for (Specification specification : specifications) {
                    for (EObject object : EMFHelper.linearize((Object)specification)) {
                        SpecHierarchy spechierachy;
                        if (!(object instanceof SpecHierarchy) || !(spechierachy = (SpecHierarchy)object).getObject().getIdentifier().equals(r2.getTarget().getIdentifier()) && !spechierachy.getObject().getIdentifier().equals(r2.getSource().getIdentifier())) continue;
                        targets.add(spechierachy);
                    }
                    connections.add(new Connection(Arrays.asList(investigatedElement), targets, (EObject)r2));
                }
            }
            return connections;
        }
        return Collections.emptyList();
    }

    public boolean isThereAnInternalTraceBetween(EObject first, EObject second) {
        return false;
    }
}

