/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.common.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.UnsignedInteger;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.eclipse.cbi.common.util.MorePosixFilePermissions;

public class Zips {
    private static final int PERM_MASK = 511;
    private static final String ZIP_ENTRY_NAME_SEPARATOR = "/";
    private static final String BACKSLASH_ESCAPE_REPLACEMENT = "\\\\\\\\";
    private static final Pattern BACKSLASH_PATTERN = Pattern.compile("\\\\");

    public static void main(String[] args) throws IOException {
        Path zip = Paths.get(args[0], new String[0]);
        Path targetFolder = Paths.get(args[1], new String[0]);
        Files.createDirectories(targetFolder, new FileAttribute[0]);
        System.out.println("Unpacking " + zip + " to " + targetFolder);
        Zips.unpackZip(zip, targetFolder);
    }

    public static int unpackZip(Path source, Path outputDir) throws IOException {
        Zips.checkPathExists(source, "'source' path must exists");
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipFile zipFile = new ZipFile(Files.newByteChannel(source, new OpenOption[0]));){
            return Zips.unpack(zipFile, outputDir);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static int unpack(ZipFile zipFile, Path outputDir) throws IOException {
        int unpack = 0;
        Enumeration<ZipArchiveEntry> entries = zipFile.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = entries.nextElement();
            Zips.unpackEntry(zipFile, entry, outputDir);
            ++unpack;
        }
        return unpack;
    }

    private static Path unpackEntry(ZipFile zipFile, ZipArchiveEntry entry, Path outputDir) throws IOException {
        Path entryPath = outputDir.resolve(entry.getName());
        if (entry.isDirectory()) {
            Files.createDirectories(entryPath, new FileAttribute[0]);
        } else {
            Path parentPath = entryPath.normalize().getParent();
            Files.createDirectories(parentPath, new FileAttribute[0]);
            if (entry.isUnixSymlink()) {
                Files.createSymbolicLink(entryPath, parentPath.resolve(zipFile.getUnixSymlink(entry)), new FileAttribute[0]);
            } else {
                Files.copy(zipFile.getInputStream(entry), entryPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        Zips.setPermissions(entryPath, entry, LinkOption.NOFOLLOW_LINKS);
        Zips.setLastModifiedTime(entryPath, FileTime.from(entry.getTime(), TimeUnit.MILLISECONDS), LinkOption.NOFOLLOW_LINKS);
        return entryPath;
    }

    private static Path setLastModifiedTime(Path path, FileTime fileTime, LinkOption ... linkOptions) throws IOException {
        BasicFileAttributeView attributes;
        if (!Files.isSymbolicLink(path) && (attributes = Files.getFileAttributeView(path, BasicFileAttributeView.class, linkOptions)) != null) {
            attributes.setTimes(fileTime, null, null);
        }
        return path;
    }

    private static Path setPermissions(Path path, ZipArchiveEntry entry, LinkOption ... linkOptions) throws IOException {
        PosixFileAttributeView attributes;
        if (!Files.isSymbolicLink(path) && (attributes = Files.getFileAttributeView(path, PosixFileAttributeView.class, linkOptions)) != null) {
            attributes.setPermissions(MorePosixFilePermissions.fromFileMode(entry.getUnixMode() & 0x1FF));
        }
        return path;
    }

    public static int unpackJar(Path source, Path outputDir) throws IOException {
        Zips.checkPathExists(source, "'source' path must exists");
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipFile zipFile = new ZipFile(Files.newByteChannel(source, new OpenOption[0]));){
            return Zips.unpack(zipFile, outputDir);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static int unpackTarGz(Path sourcePath, Path outputDir) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream(new GZIPInputStream(Files.newInputStream(sourcePath, new OpenOption[0])));){
            return Zips.unpack(tarArchiveInputStream, outputDir);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    static int unpack(TarArchiveInputStream tais, Path outputDir) throws IOException {
        int unpackedEntries = 0;
        TarArchiveEntry entry = tais.getNextTarEntry();
        while (entry != null) {
            Zips.unpackEntry(tais, entry, outputDir);
            ++unpackedEntries;
            entry = tais.getNextTarEntry();
        }
        return unpackedEntries;
    }

    private static Path unpackEntry(TarArchiveInputStream tais, TarArchiveEntry entry, Path outputDir) throws IOException {
        Path entryPath = outputDir.resolve(entry.getName());
        if (entry.isDirectory()) {
            Files.createDirectories(entryPath, new FileAttribute[0]);
        } else {
            Path parentPath = entryPath.normalize().getParent();
            Files.createDirectories(parentPath, new FileAttribute[0]);
            if (entry.isLink()) {
                Files.createLink(entryPath, outputDir.resolve(entry.getLinkName()));
            } else if (entry.isSymbolicLink()) {
                Files.createSymbolicLink(entryPath, outputDir.resolve(entry.getLinkName()), new FileAttribute[0]);
            } else if (entry.isFile()) {
                Files.copy(tais, entryPath, StandardCopyOption.REPLACE_EXISTING);
            } else {
                throw new IOException("Type of a Tar entry is not supported");
            }
        }
        Zips.setPermissions(entryPath, entry, LinkOption.NOFOLLOW_LINKS);
        Zips.setLastModifiedTime(entryPath, FileTime.from(entry.getLastModifiedDate().getTime(), TimeUnit.MILLISECONDS), LinkOption.NOFOLLOW_LINKS);
        return entryPath;
    }

    private static Path setPermissions(Path path, TarArchiveEntry entry, LinkOption ... linkOptions) throws IOException {
        PosixFileAttributeView attributes = Files.getFileAttributeView(path, PosixFileAttributeView.class, linkOptions);
        if (attributes != null) {
            attributes.setPermissions(MorePosixFilePermissions.fromFileMode(entry.getMode()));
        }
        return path;
    }

    public static int packZip(Path source, Path targetZip, boolean preserveRoot) throws IOException {
        Zips.checkPathExists(source, "'source' path must exists");
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(Zips.newBufferedOutputStream(targetZip));){
            return Zips.packEntries(source, zos, preserveRoot, ImmutableSet.of());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static int packJar(Path source, Path targetJar, boolean preserveRoot) throws IOException {
        Zips.checkPathExists(source, "'source' path must exists");
        Throwable throwable = null;
        Object var4_5 = null;
        try (JarArchiveOutputStream jos = new JarArchiveOutputStream(Zips.newBufferedOutputStream(targetJar));){
            Set<Object> pathToExcludes = !preserveRoot ? Zips.packManifestIfAny(source, jos) : ImmutableSet.of();
            return Zips.packEntries(source, jos, preserveRoot, pathToExcludes) + pathToExcludes.size();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Set<Path> packManifestIfAny(Path source, JarArchiveOutputStream jos) throws IOException {
        ImmutableSet<Path> ret;
        if (Files.isDirectory(source, new LinkOption[0])) {
            Path metaInf = source.resolve("META-INF");
            Path manifest = metaInf.resolve("MANIFEST.MF");
            if (Files.exists(manifest, new LinkOption[0])) {
                Zips.putDirectoryEntry(metaInf, jos, source.relativize(metaInf));
                Zips.putFileEntry(manifest, jos, source.relativize(manifest));
                ret = ImmutableSet.of(metaInf, manifest);
            } else {
                ret = ImmutableSet.of();
            }
        } else {
            ret = ImmutableSet.of();
        }
        return ret;
    }

    private static Path checkPathExists(Path source, String msg) {
        if (!Files.exists(source, new LinkOption[0])) {
            throw new IllegalArgumentException(msg);
        }
        return source;
    }

    private static BufferedOutputStream newBufferedOutputStream(Path path) throws IOException {
        return new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
    }

    private static int packEntries(Path source, ZipArchiveOutputStream zos, boolean preserveRoot, Set<Path> pathToExcludes) throws IOException {
        PathMapper pathMapper = preserveRoot ? new PreserveRootPathMapper(source) : new NoPreserveRootPathMapper(source);
        if (Files.isDirectory(source, new LinkOption[0])) {
            PackerFileVisitor packerFileVisitor = new PackerFileVisitor(zos, pathMapper, pathToExcludes);
            Files.walkFileTree(source, packerFileVisitor);
            return packerFileVisitor.packedEntries();
        }
        if (Files.isSymbolicLink(source)) {
            Zips.putSymlinkEntry(source, zos, pathMapper, source.getFileName());
            return 1;
        }
        Zips.putFileEntry(source, zos, source.getFileName());
        return 1;
    }

    private static String entryNameFrom(Path path, boolean isDirectory) {
        String escapedEntryName;
        String pathFsSeparator = path.getFileSystem().getSeparator();
        if (pathFsSeparator != ZIP_ENTRY_NAME_SEPARATOR) {
            String separatorRegex = BACKSLASH_PATTERN.matcher(pathFsSeparator).replaceAll(BACKSLASH_ESCAPE_REPLACEMENT);
            escapedEntryName = path.toString().replaceAll(separatorRegex, ZIP_ENTRY_NAME_SEPARATOR);
        } else {
            escapedEntryName = path.toString();
        }
        if (isDirectory && !escapedEntryName.endsWith(ZIP_ENTRY_NAME_SEPARATOR)) {
            return String.valueOf(escapedEntryName) + ZIP_ENTRY_NAME_SEPARATOR;
        }
        return escapedEntryName;
    }

    private static void putSymlinkEntry(Path file, ZipArchiveOutputStream zos, PathMapper pathMapper, Path entryPath) throws IOException {
        ZipArchiveEntry zipEntry = Zips.createArchiveEntry(zos, Zips.entryNameFrom(entryPath, false));
        zipEntry.setTime(Files.getLastModifiedTime(file, LinkOption.NOFOLLOW_LINKS).toMillis());
        Path linkTarget = Files.readSymbolicLink(file);
        ZipEncoding zipEncoding = ZipEncodingHelper.getZipEncoding(zos.getEncoding());
        ByteBuffer rawLinkTargetEntryPath = zipEncoding.encode(Zips.entryNameFrom(pathMapper.mapTo(linkTarget), Files.isDirectory(linkTarget, new LinkOption[0])));
        byte[] b = new byte[rawLinkTargetEntryPath.remaining()];
        rawLinkTargetEntryPath.get(b);
        zipEntry.setSize(b.length);
        zipEntry.setUnixMode(41471);
        zos.putArchiveEntry(zipEntry);
        ByteStreams.copy(new ByteArrayInputStream(b), zos);
        zos.closeArchiveEntry();
    }

    private static void putFileEntry(Path file, ZipArchiveOutputStream zos, Path entryPath) throws IOException {
        ZipArchiveEntry zipEntry = Zips.createArchiveEntry(zos, Zips.entryNameFrom(entryPath, false));
        zipEntry.setTime(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis());
        zipEntry.setSize(Files.size(file));
        PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0]);
        if (posixFileAttributeView != null) {
            PosixFileAttributes posixFileAttributes = posixFileAttributeView.readAttributes();
            zipEntry.setUnixMode(UnsignedInteger.valueOf(MorePosixFilePermissions.toFileMode(posixFileAttributes.permissions())).intValue());
        }
        zos.putArchiveEntry(zipEntry);
        Files.copy(file, zos);
        zos.closeArchiveEntry();
    }

    private static void putDirectoryEntry(Path dir, ZipArchiveOutputStream zos, Path entryPath) throws IOException {
        ZipArchiveEntry zipEntry = Zips.createArchiveEntry(zos, Zips.entryNameFrom(entryPath, true));
        zipEntry.setTime(Files.getLastModifiedTime(dir, new LinkOption[0]).toMillis());
        PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(dir, PosixFileAttributeView.class, new LinkOption[0]);
        if (posixFileAttributeView != null) {
            PosixFileAttributes posixFileAttributes = posixFileAttributeView.readAttributes();
            zipEntry.setUnixMode(UnsignedInteger.valueOf(MorePosixFilePermissions.toFileMode(posixFileAttributes.permissions())).intValue());
        }
        zos.putArchiveEntry(zipEntry);
        zos.closeArchiveEntry();
    }

    private static ZipArchiveEntry createArchiveEntry(ZipArchiveOutputStream zos, String entryName) {
        if (zos instanceof JarArchiveOutputStream) {
            return new JarArchiveEntry(entryName);
        }
        return new ZipArchiveEntry(entryName);
    }

    private static final class NoPreserveRootPathMapper
    implements PathMapper {
        private final Path source;

        private NoPreserveRootPathMapper(Path source) {
            this.source = source;
        }

        @Override
        public Path mapTo(Path path) {
            return this.source.relativize(path);
        }
    }

    private static final class PackerFileVisitor
    extends SimpleFileVisitor<Path> {
        private final PathMapper pathMapper;
        private final ZipArchiveOutputStream zos;
        private final Set<Path> pathToExcludes;
        private int packedEntries;

        private PackerFileVisitor(ZipArchiveOutputStream zos, PathMapper pathMapper, Set<Path> pathToExcludes) {
            this.pathMapper = pathMapper;
            this.zos = zos;
            this.pathToExcludes = pathToExcludes;
        }

        int packedEntries() {
            return this.packedEntries;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (!this.pathToExcludes.contains(dir)) {
                Path entryPath = this.pathMapper.mapTo(dir);
                if (!Strings.isNullOrEmpty(entryPath.toString())) {
                    Zips.putDirectoryEntry(dir, this.zos, entryPath);
                    ++this.packedEntries;
                }
            } else {
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (!this.pathToExcludes.contains(file)) {
                Path entryPath = this.pathMapper.mapTo(file);
                if (Files.isSymbolicLink(file)) {
                    Zips.putSymlinkEntry(file, this.zos, this.pathMapper, entryPath);
                } else {
                    Zips.putFileEntry(file, this.zos, entryPath);
                }
                ++this.packedEntries;
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private static interface PathMapper {
        public Path mapTo(Path var1);
    }

    private static final class PreserveRootPathMapper
    implements PathMapper {
        private final Path source;

        private PreserveRootPathMapper(Path source) {
            this.source = source;
        }

        @Override
        public Path mapTo(Path path) {
            return this.source.getFileName().resolve(this.source.relativize(path));
        }
    }
}

