/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.jrebel;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.jrebel.ReflectionHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.wst.server.core.IModule;
import org.osgi.framework.Bundle;

public class JRebelIntegrationUtility {
    public static boolean isJRebelEnabled(IModule module, CloudFoundryServer cloudServer) {
        IProject project;
        IProject iProject = project = module != null ? module.getProject() : null;
        return JRebelIntegrationUtility.supportedServer(cloudServer) && project != null && project.isAccessible() && JRebelIntegrationUtility.hasNature(project, "org.zeroturnaround.eclipse.remoting.remotingNature") && JRebelIntegrationUtility.hasNature(project, "org.zeroturnaround.eclipse.jrebelNature");
    }

    private static boolean supportedServer(CloudFoundryServer cloudServer) {
        return cloudServer != null && cloudServer.getUrl() != null && cloudServer.getUrl().contains("api.run.pivotal.io");
    }

    public static boolean hasNature(IProject project, String nature) {
        try {
            return project.hasNature(nature);
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
            return false;
        }
    }

    public static void setAutoGeneratedXMLDisabledProperty(IProject project) throws CoreException {
        project.setPersistentProperty(new QualifiedName("org.zeroturnaround.eclipse.jrebel", "autoGenerateRebelXml"), "false");
    }

    public static Bundle getJRebelBundle() {
        Bundle bundle = null;
        try {
            bundle = Platform.getBundle((String)"org.zeroturnaround.eclipse");
        }
        catch (Throwable e) {
            CloudFoundryPlugin.logError(e);
        }
        return bundle;
    }

    public static boolean isJRebelIDEInstalled() {
        return JRebelIntegrationUtility.getJRebelBundle() != null;
    }

    public static boolean isRemotingProject(Object remoteProjectObj) {
        return remoteProjectObj != null && remoteProjectObj.getClass().getName().equals("org.zeroturnaround.eclipse.jrebel.remoting.RemotingProject");
    }

    public static ReflectionHandler createReflectionHandler() {
        return new ReflectionHandler();
    }

    public static boolean shouldReplaceRemotingUrl(int eventType) {
        return eventType == 430;
    }
}

