/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.wizards.RegisterAccountWizardPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

public class RegisterAccountWizard
extends Wizard {
    private final CloudFoundryServer cloudServer;
    private RegisterAccountWizardPage page;
    private String email;
    private String password;

    public RegisterAccountWizard(CloudFoundryServer cloudServer) {
        this.cloudServer = cloudServer;
        this.setWindowTitle(Messages.RegisterAccountWizard_TITLE_REGISTER_ACC);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new RegisterAccountWizardPage(this.cloudServer);
        this.addPage((IWizardPage)this.page);
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean performFinish() {
        final String url = this.cloudServer.getUrl();
        this.email = this.page.getEmail();
        this.password = this.page.getPassword();
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            CloudFoundryServerBehaviour.register((String)url, (String)RegisterAccountWizard.this.email, (String)RegisterAccountWizard.this.password, (boolean)RegisterAccountWizard.this.cloudServer.isSelfSigned(), (IProgressMonitor)monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                String message = NLS.bind((String)Messages.RegisterAccountWizard_ERROR_REGISTER_ACC, (Object)this.cloudServer.getServer().getName(), (Object)e.getCause().getMessage());
                this.page.setErrorMessage(message);
                Status status = new Status(4, "org.eclipse.cft.server.core", message, (Throwable)e);
                StatusManager.getManager().handle((IStatus)status, 1);
            } else {
                Status status = new Status(4, "org.eclipse.cft.server.core", NLS.bind((String)Messages.RegisterAccountWizard_ERROR_UNEXPECTED, (Object)e.getMessage()), (Throwable)e);
                StatusManager.getManager().handle((IStatus)status, 7);
            }
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }
}

