/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.application;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cft.server.core.AbstractApplicationDelegate;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.application.ApplicationProvider;
import org.eclipse.cft.server.core.internal.application.ICloudFoundryServerApplicationDelegate;
import org.eclipse.cft.server.core.internal.application.ModuleResourceApplicationDelegate;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IModule;

public class ApplicationRegistry {
    private static Map<Priority, List<ApplicationProvider>> delegates;
    private static final String APPLICATION_DELEGATE_EXT_ELEMENT = "applicationDelegate";
    public static final String DEFAULT_JAVA_WEB_PROVIDER_ID = "org.eclipse.cft.server.application.javaweb";
    public static String EXTENSION_POINT;

    static {
        EXTENSION_POINT = "org.eclipse.cft.server.core.application";
    }

    public static AbstractApplicationDelegate getApplicationDelegate(IModule module) {
        ApplicationProvider provider = ApplicationRegistry.getApplicationProvider(module);
        if (provider != null) {
            return (AbstractApplicationDelegate)provider.getDelegate();
        }
        return null;
    }

    public static AbstractApplicationDelegate getApplicationDelegate(IModule module, CloudFoundryServer cloudServer) {
        List<ApplicationProvider> providers;
        AbstractApplicationDelegate delegate = null;
        if (cloudServer != null && (providers = ApplicationRegistry.getApplicationProviders(module)) != null) {
            for (ApplicationProvider prv : providers) {
                AbstractApplicationDelegate appDel = (AbstractApplicationDelegate)prv.getDelegate();
                if (!(appDel instanceof ICloudFoundryServerApplicationDelegate) || !cloudServer.getUrl().contains(((ICloudFoundryServerApplicationDelegate)((Object)appDel)).getServerUri())) continue;
                delegate = appDel;
                break;
            }
        }
        return delegate != null ? delegate : ApplicationRegistry.getApplicationDelegate(module);
    }

    public static ApplicationProvider getDefaultJavaWebApplicationProvider() {
        ApplicationProvider provider = ApplicationRegistry.getApplicationProvider(DEFAULT_JAVA_WEB_PROVIDER_ID);
        if (provider == null) {
            CloudFoundryPlugin.logError("Unable to load default Java Web application provider with this ID: org.eclipse.cft.server.application.javaweb. Please check that the plug-in is correctly installed.");
        }
        return provider;
    }

    public static ApplicationProvider getApplicationProvider(IModule module) {
        if (delegates == null) {
            delegates = ApplicationRegistry.load();
        }
        ApplicationProvider provider = null;
        Priority[] priorityArray = Priority.values();
        int n = priorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Priority priority = priorityArray[n2];
            List<ApplicationProvider> providerList = delegates.get((Object)priority);
            if (providerList != null) {
                for (ApplicationProvider prv : providerList) {
                    if (!ApplicationRegistry.supportsModule(module, prv)) continue;
                    provider = prv;
                    return provider;
                }
            }
            ++n2;
        }
        return provider;
    }

    public static List<ApplicationProvider> getApplicationProviders(IModule module) {
        if (delegates == null) {
            delegates = ApplicationRegistry.load();
        }
        ArrayList<ApplicationProvider> providers = new ArrayList<ApplicationProvider>();
        Priority[] priorityArray = Priority.values();
        int n = priorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Priority priority = priorityArray[n2];
            List<ApplicationProvider> providerList = delegates.get((Object)priority);
            if (providerList != null) {
                for (ApplicationProvider prv : providerList) {
                    if (!ApplicationRegistry.supportsModule(module, prv)) continue;
                    providers.add(prv);
                }
            }
            ++n2;
        }
        return providers;
    }

    public static ApplicationProvider getApplicationProvider(String providerID) {
        if (providerID == null) {
            return null;
        }
        if (delegates == null) {
            delegates = ApplicationRegistry.load();
        }
        ApplicationProvider provider = null;
        Priority[] priorityArray = Priority.values();
        int n = priorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Priority priority = priorityArray[n2];
            List<ApplicationProvider> providerList = delegates.get((Object)priority);
            if (providerList != null) {
                for (ApplicationProvider prv : providerList) {
                    if (!providerID.equals(prv.getProviderID())) continue;
                    provider = prv;
                    break;
                }
            }
            ++n2;
        }
        return provider;
    }

    public static boolean isSupportedModule(IModule module) {
        String moduleID;
        String string = moduleID = module != null && module.getModuleType() != null ? module.getModuleType().getId() : null;
        if (moduleID == null) {
            return false;
        }
        if (delegates == null) {
            delegates = ApplicationRegistry.load();
        }
        for (List<ApplicationProvider> providerList : delegates.values()) {
            if (providerList == null) continue;
            for (ApplicationProvider provider : providerList) {
                if (!ApplicationRegistry.supportsModule(module, provider)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean supportsModule(IModule module, ApplicationProvider provider) {
        List<String> supportedModuleIDs;
        String moduleID;
        if (module == null) {
            return false;
        }
        String string = moduleID = module != null && module.getModuleType() != null ? module.getModuleType().getId() : null;
        if (moduleID != null && (supportedModuleIDs = provider.getModuleIDs()) != null) {
            for (String supportedID : supportedModuleIDs) {
                if (!moduleID.equals(supportedID)) continue;
                return true;
            }
        }
        return false;
    }

    private static Map<Priority, List<ApplicationProvider>> load() {
        HashMap<Priority, List<ApplicationProvider>> providerMap = new HashMap<Priority, List<ApplicationProvider>>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT);
        if (extensionPoint == null) {
            CloudFoundryPlugin.logError("Failed to load application type providers from: " + EXTENSION_POINT);
        } else {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (APPLICATION_DELEGATE_EXT_ELEMENT.equals(config.getName())) {
                        ApplicationProvider provider = new ApplicationProvider(config, EXTENSION_POINT);
                        Priority priority = provider.getPriority();
                        String providerID = provider.getProviderID();
                        if (priority == null || providerID == null) {
                            CloudFoundryPlugin.logError("Failed to load Cloud Foundry application provider from extension point: " + EXTENSION_POINT + ". Missing provider ID and priority values");
                        } else {
                            ArrayList<ApplicationProvider> providers = (ArrayList<ApplicationProvider>)providerMap.get((Object)priority);
                            if (providers == null) {
                                providers = new ArrayList<ApplicationProvider>();
                                providerMap.put(priority, providers);
                            }
                            providers.add(provider);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return providerMap;
    }

    public static boolean shouldSetDefaultUrl(AbstractApplicationDelegate delegate, CloudFoundryApplicationModule appModule) {
        return delegate == null || !(delegate instanceof ModuleResourceApplicationDelegate ? !((ModuleResourceApplicationDelegate)delegate).shouldSetDefaultUrl(appModule) : !delegate.requiresURL());
    }

    public static enum Priority {
        High,
        Medium,
        Low;

    }
}

