/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.incremental;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.IMergeSelector;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.bridge.api.IBridge;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeTrace;
import org.eclipse.emf.diffmerge.bridge.api.incremental.IIncrementalBridgeExecution;
import org.eclipse.emf.diffmerge.bridge.impl.emf.AbstractWrappingIncrementalEMFBridge;
import org.eclipse.emf.diffmerge.bridge.incremental.BridgeTraceBasedMatchPolicy;
import org.eclipse.emf.diffmerge.bridge.incremental.IntermediateModelScope;
import org.eclipse.emf.diffmerge.bridge.traces.gen.bridgetraces.BridgetracesFactory;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFIncrementalBridge<SD, TD extends IEditableModelScope>
extends AbstractWrappingIncrementalEMFBridge<SD, TD> {
    public static final Role TARGET_DATA_ROLE = Role.TARGET;
    private final IDiffPolicy _diffPolicy;
    private final IMergePolicy _mergePolicy;
    private final IMergeSelector _mergeSelector;

    public EMFIncrementalBridge(IBridge<SD, TD> bridge_p, IDiffPolicy diffPolicy_p, IMergePolicy mergePolicy_p, IMergeSelector merger_p) {
        super(bridge_p);
        this._diffPolicy = diffPolicy_p;
        this._mergePolicy = mergePolicy_p;
        this._mergeSelector = merger_p;
    }

    protected EComparison compare(IEditableModelScope created_p, IEditableModelScope existing_p, IBridgeTrace createdTrace_p, IBridgeTrace existingTrace_p, IProgressMonitor monitor_p) {
        EComparisonImpl result = new EComparisonImpl(existing_p, created_p);
        IMatchPolicy matchPolicy = this.createMatchPolicy(created_p, existing_p, createdTrace_p, existingTrace_p);
        result.compute(matchPolicy, this.getDiffPolicy(), this.getMergePolicy(), monitor_p);
        return result;
    }

    public IEditableModelScope createIntermediateDataSet(SD sourceDataSet_p, TD targetDataSet_p) {
        return new IntermediateModelScope(sourceDataSet_p, (IModelScope)targetDataSet_p);
    }

    protected IMatchPolicy createMatchPolicy(IEditableModelScope created_p, IEditableModelScope existing_p, IBridgeTrace createdTrace_p, IBridgeTrace existingTrace_p) {
        return new BridgeTraceBasedMatchPolicy((IModelScope)created_p, createdTrace_p, existingTrace_p);
    }

    protected IBridgeTrace.Editable createTrace() {
        return BridgetracesFactory.eINSTANCE.createTrace();
    }

    protected IDiffPolicy getDiffPolicy() {
        return this._diffPolicy;
    }

    protected IMergePolicy getMergePolicy() {
        return this._mergePolicy;
    }

    protected IMergeSelector getMergeSelector() {
        return this._mergeSelector;
    }

    protected void handleMergedDifferences(IComparison comparison_p, IBridgeTrace createdTrace_p, IBridgeTrace existingTrace_p) {
        if (existingTrace_p instanceof IBridgeTrace.Editable) {
            IBridgeTrace.Editable existingTrace = (IBridgeTrace.Editable)existingTrace_p;
            for (IMatch match : comparison_p.getMapping().getContents()) {
                IElementPresence presence = match.getElementPresenceDifference();
                if (presence == null || !presence.isMerged() || presence.getMergeDestination() != TARGET_DATA_ROLE) continue;
                if (presence.getPresenceRole() == TARGET_DATA_ROLE) {
                    EObject removedTarget = presence.getElement();
                    existingTrace.removeTarget((Object)removedTarget);
                    continue;
                }
                EObject generated = presence.getElementMatch().get(TARGET_DATA_ROLE.opposite());
                Object cause = createdTrace_p.getCause((Object)generated);
                if (cause == null) continue;
                EObject addedTarget = presence.getElementMatch().get(TARGET_DATA_ROLE);
                existingTrace.putCause(cause, (Object)addedTarget);
            }
        }
    }

    protected void intermediateDataSetFilled(IEditableModelScope intermediateDataSet_p) {
    }

    protected boolean isAlwaysInteractive() {
        return false;
    }

    public IStatus merge(IEditableModelScope created_p, TD existing_p, IIncrementalBridgeExecution execution_p, IProgressMonitor monitor_p) {
        this.intermediateDataSetFilled(created_p);
        IBridgeTrace createdTrace = execution_p.getTrace();
        IBridgeTrace existingTrace = execution_p.getReferenceTrace();
        EComparison comparison = this.compare(created_p, (IEditableModelScope)existing_p, createdTrace, existingTrace, monitor_p);
        ((IIncrementalBridgeExecution.Editable)execution_p).setInteractiveMergeData((Object)comparison);
        IStatus result = this.mergeAutomatically(comparison, monitor_p);
        if (result.isOK() && !execution_p.mustDeferInteractiveMerge()) {
            result = this.mergeInteractively(execution_p, monitor_p);
        }
        return result;
    }

    protected IStatus mergeAutomatically(EComparison comparison_p, IProgressMonitor monitor_p) {
        IMergeSelector merger = this.getMergeSelector();
        if (merger != null) {
            comparison_p.merge(merger, true, monitor_p);
        }
        return Status.OK_STATUS;
    }

    public IStatus mergeInteractively(IIncrementalBridgeExecution execution_p, IProgressMonitor monitor_p) {
        Object mergeData;
        IStatus result = execution_p.getStatus();
        if (result.isOK() && (mergeData = execution_p.getInteractiveMergeData()) instanceof EComparison) {
            EComparison comparison = (EComparison)mergeData;
            if (this.isAlwaysInteractive() || comparison.hasRemainingDifferences()) {
                result = this.mergeInteractively(comparison, monitor_p);
            }
            if (result.isOK()) {
                this.handleMergedDifferences((IComparison)comparison, execution_p.getTrace(), execution_p.getReferenceTrace());
            }
        }
        return result;
    }

    protected IStatus mergeInteractively(EComparison comparison_p, IProgressMonitor monitor_p) {
        return Status.OK_STATUS;
    }

    public int getWorkAmount(SD sourceDataSet_p, TD targetDataSet_p) {
        int result = this.getTransformationBridge().getWorkAmount(sourceDataSet_p, targetDataSet_p);
        result = Math.max(result, 0) + 2;
        return result;
    }
}

