/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fx.internal.projects;

import java.net.URL;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBoxBuilder;
import javafx.scene.layout.Pane;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.util.fx.EMFUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.ESWorkspaceProvider;
import org.eclipse.emf.emfstore.fx.internal.projects.Activator;
import org.eclipse.emf.emfstore.fx.internal.projects.CreateEObjectStage;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

public final class ESLocalProjectTreeCell
extends TreeCell<Object> {
    private final ComposedAdapterFactory adapterFactory;
    private EObject currentItem;
    private final AdapterImpl adapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            ESLocalProjectTreeCell.this.updateItem(msg.getNotifier(), false);
            Event.fireEvent((EventTarget)ESLocalProjectTreeCell.this.getTreeItem(), (Event)new TreeItem.TreeModificationEvent(TreeItem.valueChangedEvent(), ESLocalProjectTreeCell.this.getTreeItem(), (Object)ESLocalProjectTreeCell.this.currentItem));
        }
    };
    private final ContextMenu localProjectMenu = new ContextMenu();
    private final ContextMenu sharedProjectMenu = new ContextMenu();
    private MenuItem saveItem;

    public ESLocalProjectTreeCell(ComposedAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        this.setupRemoteProjectContextMenu();
    }

    private void setupRemoteProjectContextMenu() {
        MenuItem commitItem = new MenuItem();
        ImageView imgCommit = new ImageView(Activator.getContext().getBundle().getResource("icons/commit.png").toExternalForm());
        commitItem.setGraphic((Node)((HBoxBuilder)HBoxBuilder.create().alignment(Pos.CENTER_LEFT).children(new Node[]{imgCommit, new Label("Commit")})).build());
        commitItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                ESLocalProject localProject = (ESLocalProject)ESLocalProjectTreeCell.this.getTreeItem().getValue();
                try {
                    localProject.getRemoteProject().getServer().login("super", "super");
                    localProject.commit((IProgressMonitor)new NullProgressMonitor());
                }
                catch (ESException e) {
                    e.printStackTrace();
                }
            }
        });
        MenuItem updateItem = new MenuItem();
        ImageView imgUpdate = new ImageView(Activator.getContext().getBundle().getResource("icons/update.png").toExternalForm());
        updateItem.setGraphic((Node)((HBoxBuilder)HBoxBuilder.create().alignment(Pos.CENTER_LEFT).children(new Node[]{imgUpdate, new Label("Update")})).build());
        updateItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                ESLocalProject localProject = (ESLocalProject)ESLocalProjectTreeCell.this.getTreeItem().getValue();
                ESUsersession session = ((ESServer)ESWorkspaceProvider.INSTANCE.getWorkspace().getServers().get(0)).getLastUsersession();
                try {
                    session.refresh();
                    localProject.update((IProgressMonitor)new NullProgressMonitor());
                }
                catch (ESException e) {
                    e.printStackTrace();
                }
            }
        });
        MenuItem shareItem = new MenuItem();
        ImageView imgShare = new ImageView(Activator.getContext().getBundle().getResource("icons/share.png").toExternalForm());
        shareItem.setGraphic((Node)((HBoxBuilder)HBoxBuilder.create().alignment(Pos.CENTER_LEFT).children(new Node[]{imgShare, new Label("Share")})).build());
        shareItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                ESLocalProject localProject = (ESLocalProject)ESLocalProjectTreeCell.this.getTreeItem().getValue();
                ESUsersession session = ((ESServer)ESWorkspaceProvider.INSTANCE.getWorkspace().getServers().get(0)).getLastUsersession();
                try {
                    session.refresh();
                    localProject.shareProject(session, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (ESException e) {
                    e.printStackTrace();
                }
            }
        });
        MenuItem addElement = new MenuItem();
        ImageView imgAdd = new ImageView(Activator.getContext().getBundle().getResource("icons/add.png").toExternalForm());
        addElement.setGraphic((Node)((HBoxBuilder)HBoxBuilder.create().alignment(Pos.CENTER_LEFT).children(new Node[]{imgAdd, new Label("Add Element")})).build());
        addElement.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                ESLocalProject localProject = (ESLocalProject)ESLocalProjectTreeCell.this.getTreeItem().getValue();
                CreateEObjectStage stage = new CreateEObjectStage();
                stage.showAndWait();
                EObject result = stage.getResult();
                if (result == null) {
                    return;
                }
                localProject.getModelElements().add((Object)result);
            }
        });
        this.saveItem = new MenuItem();
        ImageView imgSave = new ImageView(Activator.getContext().getBundle().getResource("icons/save.png").toExternalForm());
        this.saveItem.setGraphic((Node)((HBoxBuilder)HBoxBuilder.create().alignment(Pos.CENTER_LEFT).children(new Node[]{imgSave, new Label("Save")})).build());
        this.saveItem.setDisable(true);
        this.saveItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                Object value = ESLocalProjectTreeCell.this.getTreeItem().getValue();
                ESLocalProject localProject = null;
                if (ESLocalProject.class.isInstance(value)) {
                    localProject = (ESLocalProject)value;
                } else if (EObject.class.isInstance(value)) {
                    localProject = ESWorkspaceProvider.INSTANCE.getWorkspace().getLocalProject((EObject)value);
                }
                if (localProject != null) {
                    localProject.save();
                }
                ESLocalProjectTreeCell.this.saveItem.setDisable(true);
            }
        });
        this.treeItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<Object>>(){

            public void changed(ObservableValue<? extends TreeItem<Object>> observable, TreeItem<Object> oldValue, TreeItem<Object> newValue) {
                ESLocalProjectTreeCell.this.saveItem.setDisable(true);
                if (newValue == null) {
                    return;
                }
                Object value = newValue.getValue();
                ESLocalProject localProject = null;
                if (EObject.class.isInstance(value)) {
                    localProject = ESWorkspaceProvider.INSTANCE.getWorkspace().getLocalProject((EObject)value);
                } else if (ESLocalProject.class.isInstance(value)) {
                    localProject = (ESLocalProject)value;
                }
                if (localProject != null && localProject.hasUnsavedChanges()) {
                    ESLocalProjectTreeCell.this.saveItem.setDisable(false);
                }
            }
        });
        this.sharedProjectMenu.getItems().add((Object)this.saveItem);
        this.sharedProjectMenu.getItems().add((Object)commitItem);
        this.sharedProjectMenu.getItems().add((Object)updateItem);
        this.sharedProjectMenu.getItems().add((Object)addElement);
        this.localProjectMenu.getItems().add((Object)this.saveItem);
        this.localProjectMenu.getItems().add((Object)shareItem);
        this.localProjectMenu.getItems().add((Object)addElement);
    }

    public void updateItem(Object item, boolean empty) {
        super.updateItem(item, empty);
        String cellText = null;
        ImageView graphics = null;
        if (item != null) {
            if (ESLocalProject.class.isInstance(item)) {
                ESLocalProject localProject = (ESLocalProject)item;
                cellText = String.valueOf(localProject.getProjectName()) + (localProject.isShared() ? " [" + localProject.getBaseVersion().getBranch() + " " + localProject.getBaseVersion().getIdentifier() + "]" : "");
                graphics = new ImageView(Activator.getContext().getBundle().getResource("icons/localProject.gif").toExternalForm());
                if (localProject.isShared()) {
                    this.setContextMenu(this.sharedProjectMenu);
                } else {
                    this.setContextMenu(this.localProjectMenu);
                }
            }
            if (EObject.class.isInstance(item)) {
                IItemLabelProvider labelProvider;
                if (this.currentItem != item) {
                    this.updatedAdapter((EObject)item);
                }
                if ((labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(item, IItemLabelProvider.class)) != null) {
                    cellText = labelProvider.getText(item);
                    graphics = this.graphicFromObject(labelProvider.getImage(item));
                }
                ContextMenu eObjectMenu = new ContextMenu();
                eObjectMenu.getItems().add((Object)this.saveItem);
                MenuItem childrenMenu = EMFUtil.getCreateChildrenMenu((EObject)this.currentItem);
                if (childrenMenu != null) {
                    eObjectMenu.getItems().add((Object)childrenMenu);
                }
                this.setContextMenu(eObjectMenu);
            }
        }
        this.setGraphic((Node)graphics);
        this.setText(cellText);
    }

    private Node graphicFromObject(Object object) {
        if (object instanceof URL) {
            return new ImageView(((URL)object).toExternalForm());
        }
        if (object instanceof ComposedImage) {
            Pane pane = new Pane();
            for (Object image : ((ComposedImage)object).getImages()) {
                if (!(image instanceof URL)) continue;
                ImageView imageView = new ImageView(((URL)image).toExternalForm());
                pane.getChildren().add((Object)imageView);
            }
            return pane;
        }
        return null;
    }

    private void updatedAdapter(EObject item) {
        if (this.currentItem instanceof Notifier) {
            this.currentItem.eAdapters().remove((Object)this.adapter);
        }
        this.currentItem = item;
        if (this.currentItem instanceof Notifier) {
            this.currentItem.eAdapters().add((Object)this.adapter);
        }
    }
}

