/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.nebula.grid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.internal.table.swt.TableConfigurationHelper;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emfforms.spi.common.converter.EStructuralFeatureValueConverterService;
import org.eclipse.emfforms.spi.common.validation.PreSetValidationService;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class GridPasteKeyListener
implements KeyListener {
    private static final String TAB = "\t";
    private static final String NT = "\n\t";
    private static final String IS_INPUTTABLE = "isInputtable";
    private final Clipboard clipboard;
    private final EMFFormsDatabindingEMF dataBinding;
    private final EStructuralFeatureValueConverterService converterService;
    private final VControl vControl;
    private boolean selectPastedCells = true;
    private boolean alreadyPasted;
    private final PreSetValidationService preSetValidationService;
    private final Display display;
    private final EMFFormsLocalizationService localizationService;

    public GridPasteKeyListener(Display display, VControl vControl, EMFFormsDatabindingEMF dataBinding, EStructuralFeatureValueConverterService converterService, EMFFormsLocalizationService localizationService, boolean selectPastedCells) {
        this.display = display;
        this.localizationService = localizationService;
        this.clipboard = new Clipboard(display);
        this.vControl = vControl;
        this.dataBinding = dataBinding;
        this.converterService = converterService;
        this.selectPastedCells = selectPastedCells;
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(PreSetValidationService.class);
        this.preSetValidationService = serviceReference != null ? (PreSetValidationService)bundleContext.getService(serviceReference) : null;
    }

    public void keyPressed(KeyEvent e) {
        if ((e.stateMask & 0x40000) != 0 && e.keyCode == 118) {
            if (!this.alreadyPasted) {
                Grid grid = (Grid)e.widget;
                Object contents = this.clipboard.getContents((Transfer)TextTransfer.getInstance());
                if (contents instanceof String) {
                    this.pasteSelection(grid, (String)contents);
                }
                this.alreadyPasted = true;
            }
        } else {
            this.alreadyPasted = false;
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void pasteSelection(Grid grid, String contents) {
        if (grid.getCellSelection().length == 0 || !this.vControl.isEnabled() || this.vControl.isReadonly()) {
            return;
        }
        ArrayList<Point> pastedCells = new ArrayList<Point>();
        if (grid.getCellSelection().length > 1 && new StringTokenizer(contents, NT, false).countTokens() == 1 && GridPasteKeyListener.fillSelectionWithMultipleCopies(grid.getCellSelection(), contents)) {
            Point[] pointArray = GridPasteKeyListener.getFillStartPoints(grid.getCellSelection());
            int n = pointArray.length;
            int n2 = 0;
            while (n2 < n) {
                Point startItem = pointArray[n2];
                pastedCells.addAll(this.pasteContents(startItem, grid, contents));
                ++n2;
            }
        } else {
            Point startItem = grid.getCellSelection()[0];
            pastedCells.addAll(this.pasteContents(startItem, grid, contents));
        }
        if (this.selectPastedCells && !pastedCells.isEmpty() && grid.isCellSelectionEnabled()) {
            grid.setCellSelection(pastedCells.toArray(new Point[0]));
        }
    }

    static Point[] getFillStartPoints(Point[] cellSelection) {
        Map<Integer, Set<Integer>> rowToSelectedColumns = GridPasteKeyListener.createSelectionMap(cellSelection);
        Point[] result = new Point[rowToSelectedColumns.size()];
        Set<Integer> columns = rowToSelectedColumns.values().iterator().next();
        int startColumn = Collections.min(columns);
        int i = 0;
        for (Integer startRow : rowToSelectedColumns.keySet()) {
            result[i++] = new Point(startColumn, startRow.intValue());
        }
        return result;
    }

    static boolean fillSelectionWithMultipleCopies(Point[] cellSelection, String contents) {
        Map<Integer, Set<Integer>> rowToSelectedColumns = GridPasteKeyListener.createSelectionMap(cellSelection);
        if (rowToSelectedColumns.size() < 2) {
            return false;
        }
        Iterator<Set<Integer>> columnSetInterator = rowToSelectedColumns.values().iterator();
        Set<Integer> referenceSet = columnSetInterator.next();
        while (columnSetInterator.hasNext()) {
            Set<Integer> next = columnSetInterator.next();
            if (referenceSet.equals(next)) continue;
            return false;
        }
        if (referenceSet.size() == 1) {
            return true;
        }
        if (contents.split(TAB).length != referenceSet.size()) {
            return false;
        }
        ArrayList<Integer> selectedColumnIndices = new ArrayList<Integer>(referenceSet);
        Collections.sort(selectedColumnIndices);
        Iterator<Integer> selectedColumnIndicesIterator = selectedColumnIndices.iterator();
        Integer ref = selectedColumnIndicesIterator.next();
        while (selectedColumnIndicesIterator.hasNext()) {
            if ((ref = Integer.valueOf(ref + 1)) == selectedColumnIndicesIterator.next()) continue;
            return false;
        }
        return true;
    }

    private static Map<Integer, Set<Integer>> createSelectionMap(Point[] cellSelection) {
        LinkedHashMap<Integer, Set<Integer>> rowToSelectedColumns = new LinkedHashMap<Integer, Set<Integer>>();
        Point[] pointArray = cellSelection;
        int n = cellSelection.length;
        int n2 = 0;
        while (n2 < n) {
            Point point = pointArray[n2];
            if (!rowToSelectedColumns.containsKey(point.y)) {
                rowToSelectedColumns.put(point.y, new LinkedHashSet());
            }
            ((Set)rowToSelectedColumns.get(point.y)).add(point.x);
            ++n2;
        }
        return rowToSelectedColumns;
    }

    public List<Point> pasteContents(Point startItem, Grid grid, String contents) {
        String[] rows;
        int startColumn = startItem.x;
        int startRow = startItem.y;
        ArrayList<Point> pastedCells = new ArrayList<Point>();
        ArrayList<String> invalidValues = new ArrayList<String>();
        int relativeRow = 0;
        String[] stringArray = rows = contents.split("\r\n|\n", -1);
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            String row = stringArray[n2];
            int relativeColumn = 0;
            String[] stringArray2 = row.split(TAB, -1);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String cellValue = stringArray2[n4];
                int insertionColumnIndex = startColumn + relativeColumn;
                int insertionRowIndex = startRow + relativeRow;
                if (insertionColumnIndex >= grid.getColumnCount()) {
                    ++relativeColumn;
                } else {
                    VDomainModelReference dmr = (VDomainModelReference)grid.getColumn(insertionColumnIndex).getData("domain_model_reference");
                    if (dmr == null || this.vControl instanceof VTableControl && TableConfigurationHelper.isReadOnly((VTableControl)((VTableControl)this.vControl), (VDomainModelReference)dmr)) {
                        ++relativeColumn;
                    } else {
                        block20: {
                            if (insertionRowIndex < grid.getItemCount()) {
                                EObject eObject = (EObject)grid.getItem(insertionRowIndex).getData();
                                IObservableValue value = null;
                                try {
                                    try {
                                        boolean valid;
                                        value = this.dataBinding.getObservableValue(dmr, eObject);
                                        EStructuralFeature feature = (EStructuralFeature)value.getValueType();
                                        Object convertedValue = this.getConverterService().convertToModelValue(eObject, feature, cellValue);
                                        boolean bl = valid = convertedValue != null;
                                        if (this.preSetValidationService != null) {
                                            LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>();
                                            context.put("rootEObject", ((IObserving)IObserving.class.cast(value)).getObserved());
                                            Diagnostic diag = this.preSetValidationService.validate(feature, (Object)cellValue, context);
                                            boolean bl2 = valid = diag.getSeverity() == 0;
                                            if (!valid) {
                                                invalidValues.add(this.extractDiagnosticMessage(diag, feature, cellValue));
                                            }
                                        }
                                        if (!this.canBePasted(feature, cellValue)) {
                                            invalidValues.add(cellValue);
                                        } else if (valid) {
                                            this.setValue(value, convertedValue);
                                            pastedCells.add(new Point(insertionColumnIndex, insertionRowIndex));
                                        }
                                    }
                                    catch (Exception exception) {
                                        if (value != null) {
                                            value.dispose();
                                        }
                                        break block20;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (value != null) {
                                        value.dispose();
                                    }
                                    throw throwable;
                                }
                                if (value != null) {
                                    value.dispose();
                                }
                            }
                        }
                        ++relativeColumn;
                    }
                }
                ++n4;
            }
            ++relativeRow;
            ++n2;
        }
        this.showErrors(invalidValues);
        return pastedCells;
    }

    private void showErrors(List<String> msgs) {
        if (!msgs.isEmpty()) {
            GridPasteKeyListener.showDialog(this.display.getActiveShell(), this.localizationService.getString(FrameworkUtil.getBundle(this.getClass()), "InvalidPaste.Title"), this.localizationService.getString(FrameworkUtil.getBundle(this.getClass()), "InvalidPaste.Message"), msgs);
        }
    }

    private boolean canBePasted(EStructuralFeature feature, String cellValue) {
        if (!EEnum.class.isInstance(feature.getEType())) {
            return true;
        }
        EEnum eEnum = (EEnum)feature.getEType();
        for (EEnumLiteral literal : eEnum.getELiterals()) {
            String isInputtable = EcoreUtil.getAnnotation((EModelElement)literal, (String)"http://org/eclipse/emf/ecp/view/model/170", (String)IS_INPUTTABLE);
            if (!literal.getLiteral().equals(cellValue) || isInputtable == null) continue;
            return Boolean.getBoolean(isInputtable);
        }
        return true;
    }

    protected void setValue(IObservableValue value, Object convertedValue) {
        value.setValue(convertedValue);
    }

    protected String extractDiagnosticMessage(Diagnostic diag, EStructuralFeature feature, String value) {
        return ((Diagnostic)diag.getChildren().get(0)).getMessage();
    }

    private static void showDialog(Shell shell, String title, String msg, List<String> warnings) {
        StringBuilder builder = new StringBuilder();
        builder.append(msg);
        for (String warning : warnings) {
            builder.append("- " + warning).append("\n");
        }
        MessageDialog.openWarning((Shell)shell, (String)title, (String)builder.toString());
    }

    protected EStructuralFeatureValueConverterService getConverterService() {
        return this.converterService;
    }
}

