/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.recorder;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edapt.common.LoggingUtils;
import org.eclipse.emf.edapt.common.MetamodelExtent;
import org.eclipse.emf.edapt.common.MetamodelUtils;
import org.eclipse.emf.edapt.history.Change;
import org.eclipse.emf.edapt.history.CompositeChange;
import org.eclipse.emf.edapt.history.History;
import org.eclipse.emf.edapt.history.provider.HistoryEditPlugin;
import org.eclipse.emf.edapt.history.recorder.ChangeRecorder;
import org.eclipse.emf.edapt.history.recorder.HistoryChangeRecorder;
import org.eclipse.emf.edapt.history.recorder.IChangeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandStackListener
implements org.eclipse.emf.common.command.CommandStackListener {
    private final CommandStack commandStack;
    private ChangeRecorder metamodelRecorder;
    private HistoryChangeRecorder historyRecorder;
    private boolean listening;
    private final Stack<Integer> numberChanges;
    private MetamodelExtent extent;
    private final Resource historyResource;

    public CommandStackListener(CommandStack commandStack, Resource historyResource) {
        this.commandStack = commandStack;
        this.numberChanges = new Stack();
        this.listening = false;
        this.historyResource = historyResource;
    }

    public void beginListening() {
        if (this.isListening()) {
            throw new IllegalStateException("Listener already activated");
        }
        this.commandStack.addCommandStackListener((org.eclipse.emf.common.command.CommandStackListener)this);
        this.extent = new MetamodelExtent(MetamodelUtils.getAllRootPackages((ResourceSet)this.historyResource.getResourceSet()));
        this.metamodelRecorder = new ChangeRecorder(this.getHistoryRootPackages());
        this.historyRecorder = new HistoryChangeRecorder(this.getHistory());
        this.listening = true;
    }

    public void endListening() {
        if (!this.isListening()) {
            throw new IllegalStateException("Listener already deactivated");
        }
        this.commandStack.removeCommandStackListener((org.eclipse.emf.common.command.CommandStackListener)this);
        this.commandStack.flush();
        this.numberChanges.clear();
        this.extent.dispose();
        this.metamodelRecorder.endRecording();
        this.historyRecorder.endRecording();
        this.listening = false;
    }

    public boolean isListening() {
        return this.listening;
    }

    public void resetRecorder() {
        if (!this.checkRecorder()) {
            this.metamodelRecorder.endRecording();
            this.historyRecorder.endRecording();
            this.metamodelRecorder = new ChangeRecorder(this.getHistoryRootPackages());
            EcoreUtil.resolveAll((Resource)this.historyResource);
            this.historyRecorder = new HistoryChangeRecorder(this.getHistory());
            this.extent.setRootPackages(MetamodelUtils.getAllRootPackages((ResourceSet)this.historyResource.getResourceSet()));
            LoggingUtils.logInfo((Plugin)HistoryEditPlugin.getPlugin(), (String)"Recorder got out of sync and was safely restarted.");
        }
    }

    private boolean checkRecorder() {
        return !((EObject)this.metamodelRecorder.getElements().get(0)).eIsProxy();
    }

    public void commandStackChanged(EventObject event) {
        Command command = this.commandStack.getMostRecentCommand();
        this.process(command);
        this.extent.clearExtentMap();
    }

    private void process(Command command) {
        this.metamodelRecorder.endRecording();
        this.historyRecorder.endRecording();
        if (!this.checkRecorder()) {
            LoggingUtils.logError((Plugin)HistoryEditPlugin.getPlugin(), (String)"Recorder no longer working");
        }
        if (command != null) {
            if (this.isUndo(command)) {
                this.pop();
            } else {
                CompositeChange changeContainer = this.metamodelRecorder.getChanges();
                if (command instanceof IChangeProvider) {
                    IChangeProvider changeProvider = (IChangeProvider)command;
                    List changes = changeProvider.getChanges((List)changeContainer.getChanges());
                    this.push(changes);
                } else {
                    this.push((List<Change>)changeContainer.getChanges());
                }
            }
        }
        this.metamodelRecorder = new ChangeRecorder(this.getHistoryRootPackages());
        this.historyRecorder = new HistoryChangeRecorder(this.getHistory());
    }

    private boolean isUndo(Command command) {
        return command == this.commandStack.getRedoCommand();
    }

    private void pop() {
        int number = this.numberChanges.pop();
        if (number == 0) {
            return;
        }
        EList changes = this.getHistory().getLastRelease().getChanges();
        ArrayList<Change> changesToRemove = new ArrayList<Change>();
        int size = changes.size();
        int i = size - number;
        while (i < size) {
            changesToRemove.add((Change)changes.get(i));
            ++i;
        }
        changes.removeAll(changesToRemove);
    }

    private void push(List<Change> changes) {
        this.numberChanges.push(changes.size());
        this.getHistory().getLastRelease().getChanges().addAll(changes);
    }

    public History getHistory() {
        History history = (History)this.historyResource.getContents().get(0);
        return history;
    }

    public List<EPackage> getHistoryRootPackages() {
        return this.getHistory().getRootPackages();
    }

    MetamodelExtent getExtent() {
        return this.extent;
    }
}

