/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.lang.model.tck;

import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.AnnotationMember;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import org.jboss.cdi.lang.model.tck.AnnotationMembers;
import org.jboss.cdi.lang.model.tck.LangModelUtils;
import org.jboss.cdi.lang.model.tck.SimpleAnnotation;
import org.jboss.cdi.lang.model.tck.SimpleEnum;

public class AnnotationInstances {
    @AnnotationMembers
    void defaultValues() {
    }

    @AnnotationMembers(booleanMember=false, byteMember=-1, shortMember=-2, intMember=-3, longMember=-4L, floatMember=-5.0f, doubleMember=-6.0, charMember=97, stringMember="bb", classMember=AnnotationInstances.class, enumMember=SimpleEnum.NO, annotationMember=@SimpleAnnotation(value="ccc"), booleanArrayMember={false, true}, byteArrayMember={-1, -2}, shortArrayMember={-3, -4}, intArrayMember={-5, -6}, longArrayMember={-7L, -8L}, floatArrayMember={-9.0f, -10.0f}, doubleArrayMember={-11.0, -12.0}, charArrayMember={97, 98}, stringArrayMember={"cc", "dd"}, classArrayMember={AnnotationInstances.class, AnnotationMembers.class}, enumArrayMember={SimpleEnum.NO, SimpleEnum.YES}, annotationArrayMember={@SimpleAnnotation(value="eee"), @SimpleAnnotation(value="fff")})
    void nondefaultValues() {
    }

    public static void verify(ClassInfo clazz) {
        AnnotationInstances.verifyDefaultValues(clazz);
        AnnotationInstances.verifyNondefaultValues(clazz);
    }

    private static void verifyDefaultValues(ClassInfo clazz) {
        MethodInfo method = LangModelUtils.singleMethod(clazz, "defaultValues");
        assert (method.annotations().size() == 1);
        assert (method.annotations(it -> it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnotationMembers")).size() == 1);
        assert (method.annotations(it -> !it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnotationMembers")).size() == 0);
        assert (method.hasAnnotation(AnnotationMembers.class));
        assert (method.hasAnnotation(it -> it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnotationMembers")));
        assert (!method.hasAnnotation(it -> !it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnotationMembers")));
        AnnotationInfo ann = method.annotation(AnnotationMembers.class);
        assert (ann.hasMember("booleanMember"));
        assert (ann.member("booleanMember").isBoolean());
        assert (ann.member("booleanMember").asBoolean());
        assert (ann.hasMember("byteMember"));
        assert (ann.member("byteMember").isByte());
        assert (ann.member("byteMember").asByte() == 1);
        assert (ann.hasMember("shortMember"));
        assert (ann.member("shortMember").isShort());
        assert (ann.member("shortMember").asShort() == 2);
        assert (ann.hasMember("intMember"));
        assert (ann.member("intMember").isInt());
        assert (ann.member("intMember").asInt() == 3);
        assert (ann.hasMember("longMember"));
        assert (ann.member("longMember").isLong());
        assert (ann.member("longMember").asLong() == 4L);
        assert (ann.hasMember("floatMember"));
        assert (ann.member("floatMember").isFloat());
        assert (ann.member("floatMember").asFloat() == 5.0f);
        assert (ann.hasMember("doubleMember"));
        assert (ann.member("doubleMember").isDouble());
        assert (ann.member("doubleMember").asDouble() == 6.0);
        assert (ann.hasMember("charMember"));
        assert (ann.member("charMember").isChar());
        assert (ann.member("charMember").asChar() == 'A');
        assert (ann.hasMember("stringMember"));
        assert (ann.member("stringMember").isString());
        assert (ann.member("stringMember").asString().equals("BB"));
        assert (ann.hasMember("classMember"));
        assert (ann.member("classMember").isClass());
        assert (ann.member("classMember").asType().isClass());
        assert (ann.member("classMember").asType().asClass().declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnotationMembers"));
        assert (ann.hasMember("enumMember"));
        assert (ann.member("enumMember").isEnum());
        assert (ann.member("enumMember").asEnum(SimpleEnum.class) == SimpleEnum.YES);
        assert (ann.member("enumMember").asEnumClass().name().equals("org.jboss.cdi.lang.model.tck.SimpleEnum"));
        assert (ann.member("enumMember").asEnumConstant().equals("YES"));
        assert (ann.hasMember("annotationMember"));
        assert (ann.member("annotationMember").isNestedAnnotation());
        assert (ann.member("annotationMember").asNestedAnnotation().declaration().name().equals("org.jboss.cdi.lang.model.tck.SimpleAnnotation"));
        assert (ann.member("annotationMember").asNestedAnnotation().hasValue());
        assert (ann.member("annotationMember").asNestedAnnotation().value().isString());
        assert (ann.member("annotationMember").asNestedAnnotation().value().asString().equals("CCC"));
        assert (ann.hasMember("booleanArrayMember"));
        assert (ann.member("booleanArrayMember").isArray());
        assert (ann.member("booleanArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("booleanArrayMember").asArray().get(0)).isBoolean());
        assert (((AnnotationMember)ann.member("booleanArrayMember").asArray().get(0)).asBoolean());
        assert (((AnnotationMember)ann.member("booleanArrayMember").asArray().get(1)).isBoolean());
        assert (!((AnnotationMember)ann.member("booleanArrayMember").asArray().get(1)).asBoolean());
        assert (ann.hasMember("byteArrayMember"));
        assert (ann.member("byteArrayMember").isArray());
        assert (ann.member("byteArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("byteArrayMember").asArray().get(0)).isByte());
        assert (((AnnotationMember)ann.member("byteArrayMember").asArray().get(0)).asByte() == 1);
        assert (((AnnotationMember)ann.member("byteArrayMember").asArray().get(1)).isByte());
        assert (((AnnotationMember)ann.member("byteArrayMember").asArray().get(1)).asByte() == 2);
        assert (ann.hasMember("shortArrayMember"));
        assert (ann.member("shortArrayMember").isArray());
        assert (ann.member("shortArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("shortArrayMember").asArray().get(0)).isShort());
        assert (((AnnotationMember)ann.member("shortArrayMember").asArray().get(0)).asShort() == 3);
        assert (((AnnotationMember)ann.member("shortArrayMember").asArray().get(1)).isShort());
        assert (((AnnotationMember)ann.member("shortArrayMember").asArray().get(1)).asShort() == 4);
        assert (ann.hasMember("intArrayMember"));
        assert (ann.member("intArrayMember").isArray());
        assert (ann.member("intArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("intArrayMember").asArray().get(0)).isInt());
        assert (((AnnotationMember)ann.member("intArrayMember").asArray().get(0)).asInt() == 5);
        assert (((AnnotationMember)ann.member("intArrayMember").asArray().get(1)).isInt());
        assert (((AnnotationMember)ann.member("intArrayMember").asArray().get(1)).asInt() == 6);
        assert (ann.hasMember("longArrayMember"));
        assert (ann.member("longArrayMember").isArray());
        assert (ann.member("longArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("longArrayMember").asArray().get(0)).isLong());
        assert (((AnnotationMember)ann.member("longArrayMember").asArray().get(0)).asLong() == 7L);
        assert (((AnnotationMember)ann.member("longArrayMember").asArray().get(1)).isLong());
        assert (((AnnotationMember)ann.member("longArrayMember").asArray().get(1)).asLong() == 8L);
        assert (ann.hasMember("floatArrayMember"));
        assert (ann.member("floatArrayMember").isArray());
        assert (ann.member("floatArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("floatArrayMember").asArray().get(0)).isFloat());
        assert (((AnnotationMember)ann.member("floatArrayMember").asArray().get(0)).asFloat() == 9.0f);
        assert (((AnnotationMember)ann.member("floatArrayMember").asArray().get(1)).isFloat());
        assert (((AnnotationMember)ann.member("floatArrayMember").asArray().get(1)).asFloat() == 10.0f);
        assert (ann.hasMember("doubleArrayMember"));
        assert (ann.member("doubleArrayMember").isArray());
        assert (ann.member("doubleArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("doubleArrayMember").asArray().get(0)).isDouble());
        assert (((AnnotationMember)ann.member("doubleArrayMember").asArray().get(0)).asDouble() == 11.0);
        assert (((AnnotationMember)ann.member("doubleArrayMember").asArray().get(1)).isDouble());
        assert (((AnnotationMember)ann.member("doubleArrayMember").asArray().get(1)).asDouble() == 12.0);
        assert (ann.hasMember("charArrayMember"));
        assert (ann.member("charArrayMember").isArray());
        assert (ann.member("charArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("charArrayMember").asArray().get(0)).isChar());
        assert (((AnnotationMember)ann.member("charArrayMember").asArray().get(0)).asChar() == 'A');
        assert (((AnnotationMember)ann.member("charArrayMember").asArray().get(1)).isChar());
        assert (((AnnotationMember)ann.member("charArrayMember").asArray().get(1)).asChar() == 'B');
        assert (ann.hasMember("stringArrayMember"));
        assert (ann.member("stringArrayMember").isArray());
        assert (ann.member("stringArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("stringArrayMember").asArray().get(0)).isString());
        assert (((AnnotationMember)ann.member("stringArrayMember").asArray().get(0)).asString().equals("CC"));
        assert (((AnnotationMember)ann.member("stringArrayMember").asArray().get(1)).isString());
        assert (((AnnotationMember)ann.member("stringArrayMember").asArray().get(1)).asString().equals("DD"));
        assert (ann.hasMember("classArrayMember"));
        assert (ann.member("classArrayMember").isArray());
        assert (ann.member("classArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("classArrayMember").asArray().get(0)).isClass());
        assert (((AnnotationMember)ann.member("classArrayMember").asArray().get(0)).asType().isClass());
        assert (((AnnotationMember)ann.member("classArrayMember").asArray().get(0)).asType().asClass().declaration().name().equals("org.jboss.cdi.lang.model.tck.SimpleAnnotation"));
        assert (((AnnotationMember)ann.member("classArrayMember").asArray().get(1)).isClass());
        assert (((AnnotationMember)ann.member("classArrayMember").asArray().get(1)).asType().isClass());
        assert (((AnnotationMember)ann.member("classArrayMember").asArray().get(1)).asType().asClass().declaration().name().equals("org.jboss.cdi.lang.model.tck.SimpleEnum"));
        assert (ann.hasMember("enumArrayMember"));
        assert (ann.member("enumArrayMember").isArray());
        assert (ann.member("enumArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("enumArrayMember").asArray().get(0)).isEnum());
        assert (((AnnotationMember)ann.member("enumArrayMember").asArray().get(0)).asEnum(SimpleEnum.class) == SimpleEnum.YES);
        assert (((AnnotationMember)ann.member("enumArrayMember").asArray().get(1)).isEnum());
        assert (((AnnotationMember)ann.member("enumArrayMember").asArray().get(1)).asEnumClass().name().equals("org.jboss.cdi.lang.model.tck.SimpleEnum"));
        assert (((AnnotationMember)ann.member("enumArrayMember").asArray().get(1)).asEnumConstant().equals("NO"));
        assert (ann.hasMember("annotationArrayMember"));
        assert (ann.member("annotationArrayMember").isArray());
        assert (ann.member("annotationArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(0)).isNestedAnnotation());
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(0)).asNestedAnnotation().declaration().name().equals("org.jboss.cdi.lang.model.tck.SimpleAnnotation"));
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(0)).asNestedAnnotation().hasValue());
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(0)).asNestedAnnotation().value().isString());
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(0)).asNestedAnnotation().value().asString().equals("EEE"));
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(1)).isNestedAnnotation());
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(1)).asNestedAnnotation().declaration().name().equals("org.jboss.cdi.lang.model.tck.SimpleAnnotation"));
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(1)).asNestedAnnotation().hasValue());
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(1)).asNestedAnnotation().value().isString());
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(1)).asNestedAnnotation().value().asString().equals("FFF"));
    }

    private static void verifyNondefaultValues(ClassInfo clazz) {
        MethodInfo method = LangModelUtils.singleMethod(clazz, "nondefaultValues");
        assert (method.annotations().size() == 1);
        assert (method.annotations(it -> it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnotationMembers")).size() == 1);
        assert (method.annotations(it -> !it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnotationMembers")).size() == 0);
        assert (method.hasAnnotation(AnnotationMembers.class));
        assert (method.hasAnnotation(it -> it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnotationMembers")));
        assert (!method.hasAnnotation(it -> !it.declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnotationMembers")));
        AnnotationInfo ann = method.annotation(AnnotationMembers.class);
        assert (ann.hasMember("booleanMember"));
        assert (ann.member("booleanMember").isBoolean());
        assert (!ann.member("booleanMember").asBoolean());
        assert (ann.hasMember("byteMember"));
        assert (ann.member("byteMember").isByte());
        assert (ann.member("byteMember").asByte() == -1);
        assert (ann.hasMember("shortMember"));
        assert (ann.member("shortMember").isShort());
        assert (ann.member("shortMember").asShort() == -2);
        assert (ann.hasMember("intMember"));
        assert (ann.member("intMember").isInt());
        assert (ann.member("intMember").asInt() == -3);
        assert (ann.hasMember("longMember"));
        assert (ann.member("longMember").isLong());
        assert (ann.member("longMember").asLong() == -4L);
        assert (ann.hasMember("floatMember"));
        assert (ann.member("floatMember").isFloat());
        assert (ann.member("floatMember").asFloat() == -5.0f);
        assert (ann.hasMember("doubleMember"));
        assert (ann.member("doubleMember").isDouble());
        assert (ann.member("doubleMember").asDouble() == -6.0);
        assert (ann.hasMember("charMember"));
        assert (ann.member("charMember").isChar());
        assert (ann.member("charMember").asChar() == 'a');
        assert (ann.hasMember("stringMember"));
        assert (ann.member("stringMember").isString());
        assert (ann.member("stringMember").asString().equals("bb"));
        assert (ann.hasMember("classMember"));
        assert (ann.member("classMember").isClass());
        assert (ann.member("classMember").asType().isClass());
        assert (ann.member("classMember").asType().asClass().declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnotationInstances"));
        assert (ann.hasMember("enumMember"));
        assert (ann.member("enumMember").isEnum());
        assert (ann.member("enumMember").asEnum(SimpleEnum.class) == SimpleEnum.NO);
        assert (ann.member("enumMember").asEnumClass().name().equals("org.jboss.cdi.lang.model.tck.SimpleEnum"));
        assert (ann.member("enumMember").asEnumConstant().equals("NO"));
        assert (ann.hasMember("annotationMember"));
        assert (ann.member("annotationMember").isNestedAnnotation());
        assert (ann.member("annotationMember").asNestedAnnotation().declaration().name().equals("org.jboss.cdi.lang.model.tck.SimpleAnnotation"));
        assert (ann.member("annotationMember").asNestedAnnotation().hasValue());
        assert (ann.member("annotationMember").asNestedAnnotation().value().isString());
        assert (ann.member("annotationMember").asNestedAnnotation().value().asString().equals("ccc"));
        assert (ann.hasMember("booleanArrayMember"));
        assert (ann.member("booleanArrayMember").isArray());
        assert (ann.member("booleanArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("booleanArrayMember").asArray().get(0)).isBoolean());
        assert (!((AnnotationMember)ann.member("booleanArrayMember").asArray().get(0)).asBoolean());
        assert (((AnnotationMember)ann.member("booleanArrayMember").asArray().get(1)).isBoolean());
        assert (((AnnotationMember)ann.member("booleanArrayMember").asArray().get(1)).asBoolean());
        assert (ann.hasMember("byteArrayMember"));
        assert (ann.member("byteArrayMember").isArray());
        assert (ann.member("byteArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("byteArrayMember").asArray().get(0)).isByte());
        assert (((AnnotationMember)ann.member("byteArrayMember").asArray().get(0)).asByte() == -1);
        assert (((AnnotationMember)ann.member("byteArrayMember").asArray().get(1)).isByte());
        assert (((AnnotationMember)ann.member("byteArrayMember").asArray().get(1)).asByte() == -2);
        assert (ann.hasMember("shortArrayMember"));
        assert (ann.member("shortArrayMember").isArray());
        assert (ann.member("shortArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("shortArrayMember").asArray().get(0)).isShort());
        assert (((AnnotationMember)ann.member("shortArrayMember").asArray().get(0)).asShort() == -3);
        assert (((AnnotationMember)ann.member("shortArrayMember").asArray().get(1)).isShort());
        assert (((AnnotationMember)ann.member("shortArrayMember").asArray().get(1)).asShort() == -4);
        assert (ann.hasMember("intArrayMember"));
        assert (ann.member("intArrayMember").isArray());
        assert (ann.member("intArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("intArrayMember").asArray().get(0)).isInt());
        assert (((AnnotationMember)ann.member("intArrayMember").asArray().get(0)).asInt() == -5);
        assert (((AnnotationMember)ann.member("intArrayMember").asArray().get(1)).isInt());
        assert (((AnnotationMember)ann.member("intArrayMember").asArray().get(1)).asInt() == -6);
        assert (ann.hasMember("longArrayMember"));
        assert (ann.member("longArrayMember").isArray());
        assert (ann.member("longArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("longArrayMember").asArray().get(0)).isLong());
        assert (((AnnotationMember)ann.member("longArrayMember").asArray().get(0)).asLong() == -7L);
        assert (((AnnotationMember)ann.member("longArrayMember").asArray().get(1)).isLong());
        assert (((AnnotationMember)ann.member("longArrayMember").asArray().get(1)).asLong() == -8L);
        assert (ann.hasMember("floatArrayMember"));
        assert (ann.member("floatArrayMember").isArray());
        assert (ann.member("floatArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("floatArrayMember").asArray().get(0)).isFloat());
        assert (((AnnotationMember)ann.member("floatArrayMember").asArray().get(0)).asFloat() == -9.0f);
        assert (((AnnotationMember)ann.member("floatArrayMember").asArray().get(1)).isFloat());
        assert (((AnnotationMember)ann.member("floatArrayMember").asArray().get(1)).asFloat() == -10.0f);
        assert (ann.hasMember("doubleArrayMember"));
        assert (ann.member("doubleArrayMember").isArray());
        assert (ann.member("doubleArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("doubleArrayMember").asArray().get(0)).isDouble());
        assert (((AnnotationMember)ann.member("doubleArrayMember").asArray().get(0)).asDouble() == -11.0);
        assert (((AnnotationMember)ann.member("doubleArrayMember").asArray().get(1)).isDouble());
        assert (((AnnotationMember)ann.member("doubleArrayMember").asArray().get(1)).asDouble() == -12.0);
        assert (ann.hasMember("charArrayMember"));
        assert (ann.member("charArrayMember").isArray());
        assert (ann.member("charArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("charArrayMember").asArray().get(0)).isChar());
        assert (((AnnotationMember)ann.member("charArrayMember").asArray().get(0)).asChar() == 'a');
        assert (((AnnotationMember)ann.member("charArrayMember").asArray().get(1)).isChar());
        assert (((AnnotationMember)ann.member("charArrayMember").asArray().get(1)).asChar() == 'b');
        assert (ann.hasMember("stringArrayMember"));
        assert (ann.member("stringArrayMember").isArray());
        assert (ann.member("stringArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("stringArrayMember").asArray().get(0)).isString());
        assert (((AnnotationMember)ann.member("stringArrayMember").asArray().get(0)).asString().equals("cc"));
        assert (((AnnotationMember)ann.member("stringArrayMember").asArray().get(1)).isString());
        assert (((AnnotationMember)ann.member("stringArrayMember").asArray().get(1)).asString().equals("dd"));
        assert (ann.hasMember("classArrayMember"));
        assert (ann.member("classArrayMember").isArray());
        assert (ann.member("classArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("classArrayMember").asArray().get(0)).isClass());
        assert (((AnnotationMember)ann.member("classArrayMember").asArray().get(0)).asType().isClass());
        assert (((AnnotationMember)ann.member("classArrayMember").asArray().get(0)).asType().asClass().declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnotationInstances"));
        assert (((AnnotationMember)ann.member("classArrayMember").asArray().get(1)).isClass());
        assert (((AnnotationMember)ann.member("classArrayMember").asArray().get(1)).asType().isClass());
        assert (((AnnotationMember)ann.member("classArrayMember").asArray().get(1)).asType().asClass().declaration().name().equals("org.jboss.cdi.lang.model.tck.AnnotationMembers"));
        assert (ann.hasMember("enumArrayMember"));
        assert (ann.member("enumArrayMember").isArray());
        assert (ann.member("enumArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("enumArrayMember").asArray().get(0)).isEnum());
        assert (((AnnotationMember)ann.member("enumArrayMember").asArray().get(0)).asEnum(SimpleEnum.class) == SimpleEnum.NO);
        assert (((AnnotationMember)ann.member("enumArrayMember").asArray().get(1)).isEnum());
        assert (((AnnotationMember)ann.member("enumArrayMember").asArray().get(1)).asEnumClass().name().equals("org.jboss.cdi.lang.model.tck.SimpleEnum"));
        assert (((AnnotationMember)ann.member("enumArrayMember").asArray().get(1)).asEnumConstant().equals("YES"));
        assert (ann.hasMember("annotationArrayMember"));
        assert (ann.member("annotationArrayMember").isArray());
        assert (ann.member("annotationArrayMember").asArray().size() == 2);
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(0)).isNestedAnnotation());
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(0)).asNestedAnnotation().declaration().name().equals("org.jboss.cdi.lang.model.tck.SimpleAnnotation"));
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(0)).asNestedAnnotation().hasValue());
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(0)).asNestedAnnotation().value().isString());
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(0)).asNestedAnnotation().value().asString().equals("eee"));
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(1)).isNestedAnnotation());
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(1)).asNestedAnnotation().declaration().name().equals("org.jboss.cdi.lang.model.tck.SimpleAnnotation"));
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(1)).asNestedAnnotation().hasValue());
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(1)).asNestedAnnotation().value().isString());
        assert (((AnnotationMember)ann.member("annotationArrayMember").asArray().get(1)).asNestedAnnotation().value().asString().equals("fff"));
    }
}

